<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cgel-04-b="http://www.igae.pap.meh.es/cgel-04-b" xmlns:str="http://exslt.org/strings" exclude-result-prefixes="str">
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
<xsl:template match="/">
		<html>
			<head>
				<script language="Javascript" src="./funciones.js"></script> 
				<link rel="stylesheet" type="text/css" href="./estiloHTML.css"></link>
				<title>Modelo Básico</title>
		</head>
		<body>
			<table id="Principal" bgcolor="#ffffff" cellspacing="0" style="LEFT:0px; POSITION:absolute; TOP:0px">
				<tr bgcolor="darkblue" ID="Tr1">
					<td colspan="6" ID="Td6"><img src='./null.gif' height="10"/>
					</td>
				</tr>
				<tr bgcolor="darkblue" align="center">
						<td height="30">
						<table ID="Table1">
							<tr onmousedown="verMenu('LiqPpto')">
								<td><a href="#"><b>Liquidación del Presupuesto</b></a><img src='./tridownAm.gif' id="LiqPptoF" align="absmiddle"/></td>
							</tr>
							<tr>
								<td>
									<div onclick="verMenu('LiqPpto')" id="LiqPpto">
										<table cellpadding="4" cellspacing="0" class="tablaMenu">
											<tr>
												<td class="celdaMenu"><a href="#LiqPptoGast">Liquidación del presupuesto de gastos</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#LiqPptoIng">Liquidación del presupuesto de ingresos</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#Res">Resultado presupuestario</a></td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>	
					<td ID="Td2">
						<table bgcolor="darkblue" ID="Table2">
							<tr onmousedown="verMenu('InfEjePres')">
								<td><a href="#"><b>Ejecución Presupuestaria</b></a><img src='./tridownAm.gif' id="InfEjePresF" align="absmiddle"/></td>
							</tr>
							<tr>
								<td>
									<div onclick="verMenu('InfEjePres')" id="InfEjePres" >
										<table cellpadding="4" cellspacing="0" class="tablaMenu">
											<tr>
												<td class="celdaMenu"><a href="#DevIng">Devoluciones de Ingresos</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#ObligPptosCerr">Obligaciones de Presupuestos Cerrado</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#DerACobPptosCerr">Derechos a Cobrar de Presupuestos Cerrados</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#CompPptosPosts">Compromisos de Gasto con Cargo a Presupuestos de Ejercicios Posteriores</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#RecAfect">Recursos Afectados</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#RemTes">Remanente de Tesorería</a></td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>
					<td ID="Td3">
						<table bgcolor="darkblue" ID="Table3" style="WIDTH: 80px">
							<tr onmousedown="verMenu('InfTes')">
								<td><a href="#"><b>Tesorería</b></a><img src='./tridownAm.gif' id="InfTesF" align="absmiddle"/></td>
							</tr>
							<tr>
								<td>
									<div onclick="verMenu('InfTes')" id="InfTes" >
										<table cellpadding="4" cellspacing="0" class="tablaMenu">
											<tr>
												<td class="celdaMenu"><a href="#Tes">Información sobre Tesorería</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#EstConcBanc">Estado de Conciliación Bancaria</a></td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>	
	<!--					
					<td ID="Td3" style="WIDTH: 95px">
						<table bgcolor="darkblue" ID="Table3">
							<tr>
								<td><a href="#Tes"><b>Tesorería</b></a></td>
							</tr>
							<tr>
								<td>
									<div></div>
								</td>
							</tr>
						</table>
					</td>
-->
					<td ID="Td4" style="WIDTH: 140px">
						<table bgcolor="darkblue" ID="Table4">
							<tr>
								<td><a href="#End"><b>Endeudamiento</b></a></td>
							</tr>
							<tr>
								<td>
									<div></div>
								</td>
							</tr>
						</table>
					</td>
					<td ID="Td7">
						<table bgcolor="darkblue" ID="Table5">
							<tr onmousedown="verMenu('OpsNoPres')">
								<td><a href="#"><b>Operaciones No Presupuestarias</b></a><img src='./tridownAm.gif' id="OpsNoPresF" align="absmiddle"/></td>
							</tr>
							<tr>
								<td>
									<div onclick="verMenu('OpsNoPres')" id="OpsNoPres" >
										<table cellpadding="4" cellspacing="0" class="tablaMenu">
											<tr>
												<td class="celdaMenu"><a href="#Deud">Operaciones No Presupuestarias de Naturaleza Deudora</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#Acr">Operaciones No Presupuestarias de Naturaleza Acreedora</a></td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>
					<td ID="Td5" width="17%">
					</td>
				</tr>
				<tr bgcolor="darkblue">
					<td colspan="6"><img src='./null.gif' height="10"/>
					</td>
				</tr>
				<tr width="100%" bgcolor="#ffffff">
					<td colspan="6" width="900">
					<br></br>
							<font color="darkblue">
								<h2 style="MARGIN-LEFT: 8px">Cuenta Modelo Básico</h2>
							</font>
							<hr/>
							<!-- Cabecera -->
							<xsl:apply-templates select="//*[@tipo='I']"/>
							<!-- Listados -->
							<xsl:apply-templates select="//*[@tipo='L']"/>
					</td>
				</tr>
			</table>
		</body>
	</html>
	</xsl:template>
	<!-- Plantilla Cabecera -->
	<xsl:template name="cabecera" match="//*[@tipo='I']">
		<table cellpadding="4" width="100%" style="border-collapse:collapse">
			<tbody>
				<tr>
					<td>
						<h2 style="BACKGROUND-COLOR: darkblue">
							<font color="gold">
								<xsl:value-of select="@des"/>
								<!---Esto es el titulo del listado-->
							</font>
						</h2>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<table cellspacing="0" cellpadding="4" style="border-collapse:collapse">
			<tbody>
				<xsl:for-each select=".//*[@tipo='D']">
					<tr style="font size:8pt">
						<td/>
						<td style="border: solid; border-width:1; border-color=black" bgcolor="LightSteelBlue">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<xsl:value-of select="."/>
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>
	<!-- Plantilla Listados -->
	<xsl:template name="listado" match="//*[@tipo='L']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<table cellpadding="4" width="100%">
			<tbody>
				<tr>
					<td>
						<h2 style="BACKGROUND-COLOR: darkblue">
							<font color="gold">
								<a>
								<xsl:attribute name="name">
									<xsl:value-of select="local-name()"/>
								</xsl:attribute>
								<xsl:value-of select="@des"/>
								</a>
								<a href='javascript:VolverAlPrincipio()'><img src='./ArrowUp.gif' align='absmiddle' alt='Volver al Principio'/></a>
								<!---Esto es el titulo del listado-->
							</font>
						</h2>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<table cellspacing="0" cellpadding="4" width="900px" style="border-collapse:collapse">
			<tbody>
				<font face="verdana">
					<tr style="font size:8pt" align="center">
						<td/>
						<td/>
						<xsl:for-each select=".//*[@tipo='C' and @des!='']">
							<!---Aqui se crean las cabeceras de las columnas-->
							<td style="border: solid; border-width:1; border-color=black" bgcolor="LightSteelBlue">
								<strong>
									<xsl:value-of select="translate(@des, $small, $CAPS)"/>
								</strong>
							</td>
						</xsl:for-each>
					</tr>
					<xsl:apply-templates select=".//*[@tipo='D']"/>
					<xsl:call-template name="totales"/>
					<tr>
						<th/>
					</tr>
				</font>
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>
	<!-- Plantilla Detalles listados -->
	<xsl:template name="detalle" match="//*[@tipo='D']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<tr style="font size:8pt">
			<td/>
			<xsl:choose>
				<xsl:when test="@des!=''">
					<td style="border: solid; border-width:1; border-color:black">
					<!---Columnas con descripcion que no son cabeceras ni datos-->
						<strong>
							<xsl:value-of select="@des"/>
						</strong>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td width="0"></td>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select=".//*[@tipo='C']">
				<!---Aqui se crean las columnas con datos-->
				<xsl:choose>
					<xsl:when test=".=0">
						<td style="border: solid; border-width:1;border-color=black" align="right">0,00</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')='NaN' or (format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')='')">
						<td style="border: solid; border-width:1;border-color=black" align="left">
							<xsl:value-of select="concat(substring(translate(., $small, $CAPS),1,1),substring(translate(., $CAPS, $small),2))"/>
						</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')!=''">
						<td style="border: solid; border-width:1;border-color=black" align="right">
							<xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
						</td>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>
	<!-- Plantilla totales -->
	<xsl:template name="totales">
		<tr style="font size:8pt" align="right">
		<td/>
			<xsl:for-each select=".//*[@tipo='D' and position()=1]">
				<xsl:choose>
					<!--Liquidacion del Presupuesto de Gastos-->
					<xsl:when test="local-name()='LiqPptoGastApp'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="4" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:CredIni), '###.##0,00', 'european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:ModCred), '###.##0,00', 'european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:CredDef), '###.##0,00', 'european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:Oblig), '###.##0,00', 'european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:Pag),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:ObligPendPag),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:RemCredComp),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:RemCredNoComp),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Liquidacion del Presupuesto de Ingresos-->
					<xsl:when test="local-name()='LiqPptoIngApp'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PrevIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:ModPrev),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PrevDef),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:Der),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:Ing),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:DerPendCob),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:GradoRealizacion),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Devoluciones de Ingresos-->
					<xsl:when test="local-name()='DevIngApp'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PendPag1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:RectYBaj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:RecEje),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:TotRec),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PagEje),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Obligaciones de Presupuestos Cerrados-->
					<xsl:when test="local-name()='ObligPptosCerrAnio'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PendPag1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:RectYBaj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:TotOblig),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PagReal),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Derechos a Cobrar de Presupuestos Cerrados-->
					<xsl:when test="local-name()='DerACobPptosCerrAnio'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PendCob1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:RectYBaj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:TotDerACob),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:Rec),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PendCob31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Compromisos de Gasto con Cargo a Presupuestos de Ejercicios Posteriores-->
					<xsl:when test="local-name()='CompPptosPostsApp'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="5" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:CompGast),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Recursos Afectados-->
					<xsl:when test="local-name()='RecAfectDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:IngCorr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:IngCerr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:GastCorr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:GastCerr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:DesvFinAcu),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Estado de conciliación bancaria-->
					<xsl:when test="local-name()='EstConcBancDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:SaldSegEntBanc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:CobrContEntYNoBanc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PagContEntYNoBanc),'###.##0,00','european')"/>
								</strong>
							</td>							
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:CobrContBancYNoEnt),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:PagContBancYNoEnt),'###.##0,00','european')"/>
								</strong>
							</td>							
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:SaldConc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:SaldSegEnt),'###.##0,00','european')"/>
								</strong>
							</td>			
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:DifSald),'###.##0,00','european')"/>
								</strong>
							</td>											
					</xsl:when>															
					<!--Informacion Sobre Endeudamiento-->
					<xsl:when test="local-name()='EndPresYCred'">
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:SaldPendCanc1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:AltEnd),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:CancEnd),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:SaldPendCanc31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:IntImpPpto),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Naturaleza Deudora-->
					<xsl:when test="local-name()='DeudAntCajFij'">
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:Sald1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:RectYBaj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:CargEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:TotDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:AbEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:Sald31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Naturaleza Acreedora-->
					<xsl:when test="local-name()='AcrFianzYDep'">
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:Sald1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:RectYBaj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:AbEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:TotAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:CargEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-b:Sald31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>
</xsl:stylesheet>
