<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cgel-04-n="http://www.igae.pap.meh.es/cgel-04-n" xmlns:str="http://exslt.org/strings" exclude-result-prefixes="str">
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
	<xsl:template match="/">
		<html>
			<head>
				<script language="Javascript" src="./funciones.js"></script> 
				<link rel="stylesheet" type="text/css" href="./estiloHTML.css"></link>
				<title>Modelo Normal</title>
			</head>
		<body onload="establecerVisibilidad()">
			<table id="Principal" bgcolor="#ffffff" cellspacing="0" style="LEFT:0px; POSITION:absolute; TOP:0px" border="0">
				<tr bgcolor="darkblue" ID="Tr1">
					<td colspan="8" ID="Td6"><img src='./null.gif' height="10"/>
					</td>
				</tr>
				<tr bgcolor="darkblue">
					<td ID="Td7" width="140px">
						<table bgcolor="darkblue" ID="Table5">
							<tr onmousedown="verMenu('Mem')">
								<td class="Menu"><b>Memoria</b><img src='./tridownAm.gif' id="MemF" align="absmiddle"/></td>
							</tr>
							<tr>
								<td>
									<div id="Mem">
										<table cellpadding="4" cellspacing="0" class="tablaMenu" width="450px">
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InvDestUsoGen" id="celdaInvDestUsoGen">Inversiones Destinadas al Uso General</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#PatEntUsoGen" id="celdaPatEntUsoGen">Patrimonio Entregado al Uso General</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InmovInmat" id="celdaInmovInmat">Inmovilizaciones Inmateriales</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InmovMat" id="celdaInmovMat">Inmovilizaciones Materiales</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BienCesTemp" id="celdaBienCesTemp">Bienes en Régimen de Cesión Temporal</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BienAdscrip" id="celdaBienAdscrip">Bienes en Régimen de Adscripción</a></td>
											</tr>											
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BienEfectAGarant" id="celdaBienEfectAGarant">Bienes Afectos a Garantías</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InvGest" id="celdaInvGest">Inversiones Gestionadas</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#PatrPublSuel" id="celdaPatrPublSuel">Patrimonio Público del Suelo</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InvFin" id="celdaInvFin">Inversiones Financieras</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#PrestSingSig" id="celdaPrestSingSig">Préstamos Singulares Significativos</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#Exist" id="celdaExist">Existencias</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#Tes" id="celdaTes">Tesorería</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#EstConcBanc" id="celdaEstConcBanc">Estado de Conciliación Bancaria</a></td>
											</tr>											
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#FondProp" id="celdaFondProp">Fondos Propios</a></td>
											</tr>
											<tr onclick="verMenu('InfEnd')">
												<td style="CURSOR: hand;color:Gold" class="celdaMenu">Información sobre el Endeudamiento<img src="./triright.gif" id="InfEndFL"></img>
													<div onclick="verMenu('InfEnd')" id="InfEnd">
													<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
															<tr onclick="verMenu('PasFinLCP')">
															<td style="CURSOR: hand;color:Gold" class="celdaMenu">Pasivos financieros a largo y corto plazo<img src="./triright.gif" id="PasFinLCPFL">
															</img>
																<div id="PasFinLCP" onclick="verMenu('InfEnd');verMenu('Mem')">
																	<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																		<tr onclick="verMenu('EstDeudCap');verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');">
																				<td style="CURSOR: hand;color:Gold" class="celdaMenu">Estado de la deuda. Capitales
																					<img src="./triright.gif" id="EstDeudCapFL"></img>
																					<div onclick="verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');" id="EstDeudCap">
																						<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaCapNac" id="celdaEstDeudaCapNac">Deudas en moneda nacional</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaCapDistEur" id="celdaEstDeudaCapDistEur">Deudas en moneda distinta del euro</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																			<tr onclick="verMenu('EstDeudIntExp');verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');">
																				<td style="CURSOR: hand;color:Gold" class="celdaMenu">Estado de la deuda. Intereses explícitos
																					<img src="./triright.gif" id="EstDeudIntExpFL"></img>
																					<div onclick="verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');" id="EstDeudIntExp">
																						<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntExpNac" id="celdaEstDeudaIntExpNac">Deudas en moneda nacional</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntExpDistEur" id="celdaEstDeudaIntExpDistEur">Deudas en moneda distinta del euro</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																			<tr onclick="verMenu('EstDeudIntImp');verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');">
																				<td style="CURSOR: hand;color:Gold" class="celdaMenu">Estado de la deuda. Intereses implícitos
																					<img src="./triright.gif" id="EstDeudIntImpFL"></img>
																					<div onclick="verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');" id="EstDeudIntImp">
																						<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntImpNac" id="celdaEstDeudaIntImpNac">Deudas en moneda nacional</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntImpDistEur" id="celdaEstDeudaIntImpDistEur">Deudas en moneda distinta del euro</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																	</table>
																</div>
															</td>
															</tr>
															<tr onclick="verMenu('OperIntFin')">
																<td style="CURSOR: hand;color:Gold" class="celdaMenu">Operaciones de Intercambio Financiero<img src="./triright.gif" id="OperIntFinFL">
																</img>
																	<div id="OperIntFin"  onclick="verMenu('InfEnd');verMenu('Mem')">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr>
																				<td class="celdaMenu"><a href="#ResOperIntFinDiv" id="celdaResOperIntFinDiv">Resultado de las Operaciones de Intercambio Financiero de Divisas</a></td>
																			</tr>
																			<tr>
																				<td class="celdaMenu"><a href="#ResOperIntFinInter" id="celdaResOperIntFinInter">Resultado de las Operaciones de Intercambio Financiero de Intereses</a></td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
															<tr>
																<td onclick="verMenu('InfEnd');verMenu('Mem')" class="celdaMenu"><a href="#AvConc" id="celdaAvConc">Avales Concedidos</a></td>
															</tr>
															<tr>
																<td onclick="verMenu('InfEnd');verMenu('Mem')" class="celdaMenu"><a href="#AvRein" id="celdaAvRein">Avales Reintegrados</a></td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr onclick="verMenu('InfOperOtrEntPubl')">
												<td style="CURSOR: hand;color:Gold" class="celdaMenu">Información de las operaciones por administración de recursos por cuenta de otros entes públicos<img src="./triright.gif" id="InfOperOtrEntPublFL"></img>
												<div onclick="verMenu('Mem');" id="InfOperOtrEntPubl">
												<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
													<tr>
												<td class="celdaMenu"><a href="#DesProcGestRecAdmin" id="celdaDesProcGestRecAdmin">Desarrollo del Proceso de Gestión de los Recursos Administrados</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#DesDevRecOtrEntPubl" id="celdaDesDevRecOtrEntPubl">Desarrollo de las Devoluciones de Recursos de Otros Entes Públicos</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#OblDerGest" id="celdaOblDerGest">Obligaciones Derivadas de la Gestión</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#CtaCorrOtrEntPubl" id="celdaCtaCorrOtrEntPubl">Cuentas Corrientes con Otros Entes Públicos</a></td>
											</tr>
												</table>
											</div>
												</td>
											</tr>
											<tr onclick="verMenu('OperNoPresTes')">
												<td style="CURSOR: hand;color:Gold" class="celdaMenu">Operaciones No Presupuestarias de Tesorería<img src="./triright.gif" id="OperNoPresTesFL">
												</img>
													<div onclick="verMenu('Mem')" id="OperNoPresTes" >
														<table cellpadding="4" cellspacing="0" class="tablaMenu" width="400px">
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesDeud" id="celdaOperNoPresTesDeud">Deudores</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesAcr" id="celdaOperNoPresTesAcr">Acreedores</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesPartPendAppCobr" id="celdaOperNoPresTesPartPendAppCobr">Partidas Pendientes de Aplicación. Cobros</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesPartPendAppPag" id="celdaOperNoPresTesPartPendAppPag">Partidas Pendientes de Aplicación. Pagos</a></td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#SubRecPendJust" id="celdaSubRecPendJust">Subvenciones Recibidas Pendientes de Justificar</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#TransYSubConcSig" id="celdaTransYSubConcSig">Transferencias y Subvenciones Concedidas Significativas</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#EstValRecDepList" id="celdaEstValRecDepList">Estado de Valores Recibidos en Depósito</a></td>
											</tr>
											<tr onclick="verMenu('CuadFin')">
												<td style="CURSOR: hand;color:Gold" class="celdaMenu">Cuadro de Financiación<img src="./triright.gif" id="CuadFinFL">
												</img>
													<div onclick="verMenu('Mem')" id="CuadFin" >
														<table cellpadding="4" cellspacing="0" class="tablaMenu" width="420px">
															<tr>
																<td class="celdaMenu"><a href="#CuadFinFondApl" id="celdaCuadFinFondApl">Fondos aplicados</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#CuadFinFondObt" id="celdaCuadFinFondObt">Fondos obtenidos</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#CuadFinVarCap" id="celdaCuadFinVarCap">Variación del capital circulante</a></td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr onclick="verMenu('InfPres')">
												<td style="CURSOR: hand;color:Gold" class="celdaMenu">Información presupuestaria<img src="./triright.gif" id="InfPresFL"></img>
													<div onclick="verMenu('InfPres')" id="InfPres">
													<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
															<tr onclick="verMenu('EjCorr')">
															<td style="CURSOR: hand;color:Gold" class="celdaMenu">Ejercicio corriente<img src="./triright.gif" id="EjCorrFL">
															</img>
																<div id="EjCorr" onclick="verMenu('InfPres');verMenu('Mem')">
																	<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																		<tr onclick="verMenu('PresGast');verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');">
																				<td style="CURSOR: hand;color:Gold" class="celdaMenu">Presupuesto de gastos
																					<img src="./triright.gif" id="PresGastFL"></img>
																					<div 
																							onclick="verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');" id="PresGast">
																						<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#ModCred" id="celdaModCred">Modificaciones de Crédito</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#RemCred" id="celdaRemCred">Remanentes de Crédito</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#ProGast" id="celdaProGast">Proyectos de Gasto</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#AcrOpsPendAplPres" id="celdaAcrOpsPendAplPres">Acreedores por Operaciones Pendientes de Aplicar a Presupuesto</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																			<tr onclick="verMenu('PresIng');verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');">
																				<td style="CURSOR: hand;color:Gold" class="celdaMenu">Presupuesto de ingresos<img src="./triright.gif" id="PresIngFL">
																					</img>
																						<div id="PresIng" onclick="verMenu('InfPres');verMenu('Mem')">
																							<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr onclick="verMenu('ProcGest');verMenu('PresIng');verMenu('InfPres');verMenu('Mem');">
																										<td style="CURSOR: hand;color:Gold" class="celdaMenu">Proceso de gestión
																											<img src="./triright.gif" id="ProcGestFL"></img>
																											<div onclick="verMenu('PresIng');verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');" id="ProcGest">
																												<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																													<tr>
																														<td class="celdaMenu"><a href="#DerAnul" id="celdaDerAnul">Derechos Anulados</a></td>
																													</tr>
																													<tr>
																														<td class="celdaMenu"><a href="#DerCanc" id="celdaDerCanc">Derechos Cancelados</a></td>
																													</tr>
																													<tr>
																														<td class="celdaMenu"><a href="#RecNet" id="celdaRecNet">Recaudación Neta</a></td>
																													</tr>
																												</table>
																											</div>
																										</td>
																								</tr>
																								<tr onclick="verMenu('EjCorr');">
																									<td class="celdaMenu"><a href="#DevIng" id="celdaDevIng">Devoluciones de Ingresos</a></td>
																								</tr>
																								<tr onclick="verMenu('EjCorr');">
																									<td class="celdaMenu"><a href="#ComprIng" id="celdaComprIng">Compromisos de Ingreso</a></td>
																								</tr>
																							</table>
																						</div>
																					</td>
																				</tr>
																			</table>
																</div>
															</td>
															</tr>
															<tr onclick="verMenu('EjCerr')">
															<td style="CURSOR: hand;color:Gold" class="celdaMenu">Ejercicios cerrados<img src="./triright.gif" id="EjCerrFL">
															</img>
																<div id="EjCerr" onclick="verMenu('InfPres');verMenu('Mem')">
																	<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																		<tr>
																			<td class="celdaMenu"><a href="#OblPresCerr" id="celdaOblPresCerr">Obligaciones de Presupuestos Cerrados</a></td>
																		</tr>
																		<tr onclick="verMenu('DerPresCerr');verMenu('EjCerr');verMenu('InfPres');verMenu('Mem');">
																			<td style="CURSOR: hand;color:Gold" class="celdaMenu">Derechos a Cobrar de Presupuestos Cerrados<img src="./triright.gif" id="DerPresCerrFL">
																			</img>
																				<div id="DerPresCerr"  onclick="verMenu('EjCerr');verMenu('InfPres');verMenu('Mem')">
																					<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																						<tr>
																							<td class="celdaMenu"><a href="#DerPresCerrAnul" id="celdaDerPresCerrAnul">Derechos Anulados</a></td>
																						</tr>
																						<tr>
																							<td class="celdaMenu"><a href="#DerPresCerrCanc" id="celdaDerPresCerrCanc">Derechos Extinguidos</a></td>
																						</tr>
																					</table>
																				</div>
																			</td>
																		</tr>
																		<tr>
																			<td class="celdaMenu"><a href="#VarResPresEjAnt" id="celdaVarResPresEjAnt">Variación de Resultados Presupuestarios de Ejercicios Anteriores</a></td>
																		</tr>
																		</table>
																</div>
															</td>
															</tr>
															<tr onclick="verMenu('EjPost')">
															<td style="CURSOR: hand;color:Gold" class="celdaMenu">Ejercicios posteriores<img src="./triright.gif" id="EjPostFL">
															</img>
																<div id="EjPost"  onclick="verMenu('EjPost');verMenu('InfPres');verMenu('Mem')">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr onclick="verMenu('EjPost');">
																				<td class="celdaMenu"><a href="#ComprGastEjPost" id="celdaComprGastEjPost">Compromisos de gasto con cargo a presupuestos de ejercicios posteriores</a></td>
																			</tr>
																			<tr onclick="verMenu('EjPost');">
																				<td class="celdaMenu"><a href="#ComprIngEjPost" id="celdaComprIngEjPost">Compromisos de ingreso con cargo a presupuestos de ejercicios posteriores</a></td>
																			</tr>
																		</table>
																	</div>
															</td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr onclick="verMenu('GastFinAfect')">
												<td style="CURSOR: hand;color:Gold" class="celdaMenu">Gastos con financiación afectada<img src="./triright.gif" id="GastFinAfectFL"></img>
												<div onclick="verMenu('GastFinAfect')" id="GastFinAfect">
													<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
														<tr onclick="verMenu('GastFinAfect');verMenu('Mem')">
															<td class="celdaMenu"><a href="#DesvFin" id="celdaDesvFin">Desviaciones de financiación</a></td>
														</tr>
														<tr onclick="verMenu('InfUniGast');">
															<td style="CURSOR: hand;color:Gold" class="celdaMenu">Información por unidad de gasto<img src="./triright.gif" id="InfUniGastFL"></img>
																<div onclick="verMenu('InfUniGast')" id="InfUniGast">
																	<table cellpadding="4" cellspacing="0" class="tablaMenu" width="450px">
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DatGenIdent" id="celdaDatGenIdent">A) Datos generales indentificativos</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DatGenIdentAppPres" id="celdaDatGenIdentAppPres">A) Datos generales indentificativos (aplicaciones presupuestarias)</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestGast" id="celdaGestGast">B) Gestión del gasto</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestGastTot" id="celdaGestGastTot">B) Gestión del gasto (totales)</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestIngAfect" id="celdaGestIngAfect">C) Gestión de los ingresos afectados</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestIngAfectTot" id="celdaGestIngAfectTot">C) Gestión de los ingresos afectados (totales)</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DesvFinAgent" id="celdaDesvFinAgent">D) Desviaciones de financiación por agentes</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DesvFinAgentTot" id="celdaDesvFinAgentTot">D) Desviaciones de financiación por agentes (totales)</a></td>
																		</tr>
																	</table>
																</div>
															</td>
														</tr>
													</table>
												</div>
												</td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#RemTes" id="celdaRemTes">Remanente de tesorería</a></td>
											</tr>
											<tr onclick="verMenu('Ind')">
												<td style="CURSOR: hand;color:Gold" class="celdaMenu">Indicadores<img src="./triright.gif" id="IndFL"></img>
													<div onclick="verMenu('Ind')" id="Ind">
														<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
															<tr onclick="verMenu('IndFin');">
																<td style="CURSOR: hand;color:Gold" class="celdaMenu">Indicadores financieros y patrimoniales<img src="./triright.gif" id="IndFinFL">
																</img>
																	<div onclick="verMenu('IndFin')" id="IndFin">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr onclick="verMenu('Ind');verMenu('IndFin');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#LiqInm" id="celdaLiqInm">Liquidez inmediata</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndFin');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#SolvCortPlaz" id="celdaSolvCortPlaz">Solvencia a corto plazo</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndFin');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#EndHab" id="celdaEndHab">Endeudamiento por habitante</a></td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
															<tr onclick="verMenu('IndPres');">
																<td style="CURSOR: hand;color:Gold" class="celdaMenu">Indicadores presupuestarios<img src="./triright.gif" id="IndPresFL">
																</img>
																	<div onclick="verMenu('IndPres')" id="IndPres">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr onclick="verMenu('IndPresCorr');">
																				<td style="CURSOR: hand;color:Gold" class="celdaMenu">Del presupuesto corriente<img src="./triright.gif" id="IndPresCorrFL">
																					</img>
																						<div onclick="verMenu('IndPres');verMenu('Ind');verMenu('Mem');" id="IndPresCorr">
																							<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																								<tr>
																									<td class="celdaMenu"><a href="#EjecPresGast" id="celdaEjecPresGast">Ejecución del presupuesto de gastos</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#RealPag" id="celdaRealPag">Realización de pagos</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#GastHab" id="celdaGastHab">Gasto por habitante</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#InvHab" id="celdaInvHab">Inversión por habitante</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#EsfInv" id="celdaEsfInv">Esfuerzo inversor</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#PerMedPag" id="celdaPerMedPag">Periodo medio de pago</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#EjecPresIng" id="celdaEjecPresIng">Ejecución del presupuesto de ingresos</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#RealCobr" id="celdaRealCobr">Realización de cobros</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#Aut" id="celdaAut">Autonomía</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#AutFisc" id="celdaAutFisc">Autonomía fiscal</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#PerMedCobr" id="celdaPerMedCobr">Periodo medio de cobro</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#SupDefHab" id="celdaSupDefHab">Superávit (o déficit) por habitante</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#ContrPresRemTes" id="celdaContrPresRemTes">Contribución del presupuesto al remanente de tesorería</a></td>
																								</tr>
																							</table>
																						</div>
																					</td>
																			</tr>
																			<tr onclick="verMenu('IndPresCerr');">
																				<td style="CURSOR: hand;color:Gold" class="celdaMenu">De presupuestos cerrados<img src="./triright.gif" id="IndPresCerrFL">
																					</img>
																						<div onclick="verMenu('IndPres');verMenu('Ind');verMenu('Mem');" id="IndPresCerr">
																							<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																								<tr>
																									<td class="celdaMenu"><a href="#RealPagCerr" id="celdaRealPagCerr">Realización de pagos</a></td>
																								</tr>																								
																								<tr>
																									<td class="celdaMenu"><a href="#RealCobrCerr" id="celdaRealCobrCerr">Realización de cobros</a></td>
																								</tr>
																								
																							</table>
																						</div>
																					</td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
															<tr onclick="verMenu('IndGest');">
																<td style="CURSOR: hand;color:Gold" class="celdaMenu">Indicadores de gestión<img src="./triright.gif" id="IndGestFL">
																</img>
																	<div onclick="verMenu('IndGest')" id="IndGest">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#CostServXNumHab" id="celdaCostServXNumHab">Coste del servicio por habitante</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#RendServXCostServ" id="celdaRendServXCostServ">Rendimiento del servicio por coste del servicio</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#CostServXNumPrest" id="celdaCostServXNumPrest">Coste del servicio por número de prestaciones</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#CostServXCostEstServ" id="celdaCostServXCostEstServ">Coste del servicio por coste estimado del servicio</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#NumEmpServXNumHab" id="celdaNumEmpServXNumHab">Número de empleados del servicio por número de habitantes</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#NumPrestRealXNumPrestPrev" id="celdaNumPrestRealXNumPrestPrev">Número de prestaciones realizadas por número de prestaciones previstas</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#NumPrestRealXNumHab" id="celdaNumPrestRealXNumHab">Número de prestaciones realizadas por número de habitantes</a></td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>															
														</table>
													</div>
												</td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BalComp" id="celdaBalComp">Balance de comprobación</a></td>
											</tr>											
										</table>
									</div>
								</td>
								<td width="500px"></td>
							</tr>
						</table>
					</td>
					<td height="30" width="70px">
						<table ID="Table1">
							<tr onmousedown="verMenu('Bal')">
								<td class="Menu"><b>Balance</b><img src='./tridownAm.gif' id="BalF" align="absmiddle"/></td>
							</tr>
							<tr>
								<td>
									<div style="VISIBILITY:hidden; POSITION:absolute;BACKGROUND-COLOR:darkblue" onclick="verMenu('Bal')" id="Bal">
										<table cellpadding="4" cellspacing="0" style="FONT-SIZE: 10pt; COLOR: gold; FONT-FAMILY: Verdana, Arial;" width="100px">
											<tr>
												<td class="celdaMenu"><a href="#BalAct"  id="celdaBalAct">Activo</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#BalPas" id="celdaBalPas">Pasivo</a></td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>	
					<td height="30" width="70px">
						<table ID="Table1">
							<tr onmousedown="verMenu('Cta')">
								<td class="Menu"><b>Cuenta</b><img src='./tridownAm.gif' id="CtaF" align="absmiddle"/></td>
							</tr>
							<tr>
								<td>
									<div onclick="verMenu('Cta')" id="Cta">
										<table cellpadding="4" cellspacing="0" class="tablaMenu" width="150px">
											<tr>
												<td class="celdaMenu"><a href="#CtaDeb" id="celdaCtaDeb">Debe. Gastos</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#CtaHab" id="celdaCtaHab">Haber. Ingresos</a></td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>	
					<td height="30" width="230px" nowrap="nowrap">
						<table ID="Table1">
							<tr onmousedown="verMenu('LiqPpto')">
								<td class="Menu"><b>Liquidación del Presupuesto</b><img src='./tridownAm.gif' id="LiqPptoF" align="absmiddle"/></td>
							</tr>
							<tr>
								<td>
									<div onclick="verMenu('LiqPpto')" id="LiqPpto" width="220px">
										<table cellpadding="4" cellspacing="0" class="tablaMenu">
											<tr>
												<td class="celdaMenu"><a href="#LiqPptoGast" id="celdaLiqPptoGast">Liquidación del presupuesto de gastos</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#LiqPptoIng" id="celdaLiqPptoIng">Liquidación del presupuesto de ingresos</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#Res" id="celdaRes">Resultado presupuestario</a></td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>	
					<td height="30" width="230px" nowrap="nowrap"/>
				</tr>
				<tr bgcolor="darkblue">
					<td colspan="8"><img src='./null.gif' height="10"/>
					</td>
				</tr>
					<tr width="100%" bgcolor="#ffffff">
						<td colspan="8" width="900">
							<br></br>
							<font color="darkblue">
								<h2 style="MARGIN-LEFT: 8px;font-size:18px">Cuenta Modelo Normal</h2>
							</font>
							<hr/>
							<!-- Cabecera -->
							<xsl:apply-templates select="//*[@tipo='I']"/>
							<!-- Listados -->
							<xsl:apply-templates select="//*[@tipo='L']"/>					
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<!-- Plantilla Cabecera -->
	<xsl:template name="cabecera" match="//*[@tipo='I']">
		<table cellpadding="4" width="100%" style="border-collapse:collapse">
			<tbody>
				<tr>
					<td>
						<h2 style="BACKGROUND-COLOR: darkblue;font-size:18px">
							<font color="gold">
								<xsl:value-of select="@des"/>
								<!---Esto es el titulo del listado-->
							</font>
						</h2>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<table cellspacing="0" cellpadding="4" style="border-collapse:collapse">
			<tbody>
				<xsl:for-each select=".//*[@tipo='D']">
					<tr style="font size:8pt">
						<td/>
						<td style="border: solid; border-width:1; border-color=black" bgcolor="LightSteelBlue">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<xsl:value-of select="."/>
						</td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>
	<!-- Plantilla Listados -->
	<xsl:template name="listado" match="//*[@tipo='L']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<table cellpadding="4" width="100%">
			<tbody>
				<tr>
					<td>
						<h2 style="BACKGROUND-COLOR: darkblue;font-size:18px">
							<font color="gold">
								<a>
								<xsl:attribute name="name">
									<xsl:value-of select="local-name()"/>
								</xsl:attribute>
								<xsl:value-of select="@des"/>
								</a>
								<a href='javascript:VolverAlPrincipio()'><img src='./ArrowUp.gif' align='absmiddle' alt='Volver al Principio'/></a>
								<!---Esto es el titulo del listado-->
							</font>
						</h2>
					</td>
				</tr>
			</tbody>
		</table>
		<br/>
		<table cellspacing="0" cellpadding="4" width="900px" style="border-collapse:collapse">
			<tbody>
				<font face="verdana">
					<tr style="font size:8pt" align="center">
						<td/>
						<td/>
						<xsl:for-each select=".//*[@tipo='C' and @des!='']">
							<!---Aqui se crean las cabeceras de las columnas-->
							<td style="border: solid; border-width:1; border-color=black" bgcolor="LightSteelBlue">
								<strong>
									<xsl:value-of select="translate(@des, $small, $CAPS)"/>
								</strong>
							</td>
						</xsl:for-each>
					</tr>
					<xsl:apply-templates select=".//*[@tipo='D']"/>
					<xsl:call-template name="totales"/>
					<tr>
						<th/>
					</tr>
				</font>
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>
	<!-- Plantilla Detalles listados -->
	<xsl:template name="detalle" match="//*[@tipo='D']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<tr style="font size:8pt">
			<td/>
			<xsl:choose>
				<xsl:when test="@des!=''">
					<td style="border: solid; border-width:1; border-color:black">
					<!---Columnas con descripcion que no son cabeceras ni datos-->
						<strong>
							<xsl:value-of select="@des"/>
						</strong>
					</td>
				</xsl:when>
				<xsl:otherwise>
				<td width="0"></td>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select=".//*[@tipo='C']">
				<!---Aqui se crean las columnas con datos-->
				<xsl:choose>
					<xsl:when test=".=0">
						<td style="border: solid; border-width:1;border-color=black" align="right">0,00</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')='NaN' or (format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')='')">
						<td style="border: solid; border-width:1;border-color=black" align="left">
							<xsl:value-of select="."/>							
						</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')!=''">
						<td style="border: solid; border-width:1;border-color=black" align="right">
							<xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
						</td>
					</xsl:when>
					<xsl:when test=".=''">
					<td style="border: solid; border-width:0;border-color=black" align="right">a</td>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>
	<!-- Plantilla totales -->
	<xsl:template name="totales">
		<tr style="font size:8pt" align="right">
		<td/>
			<xsl:for-each select=".//*[@tipo='D' and position()=1]">
				<xsl:choose>
					<!--Balance Activo-->
					<xsl:when test="local-name()='BalActInm'">
						<td style="border: solid; border-width:1; border-color:black" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:variable name="suma" select="parent::*/*/cgel-04-n:ActEjAct[.!='']"/>
								<xsl:value-of select="format-number(sum($suma),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:variable name="sumaAnt" select="parent::*/*/cgel-04-n:ActEjAnt[.!='']"/>
								<xsl:value-of select="format-number(sum($sumaAnt),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Balance Pasivo-->
					<xsl:when test="local-name()='BalPasFondProp'">
						<td style="border: solid; border-width:1; border-color:black" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:variable name="suma" select="parent::*/*/cgel-04-n:PasEjAct[.!='']"/>
								<xsl:value-of select="format-number(sum($suma),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:variable name="sumaAnt" select="parent::*/*/cgel-04-n:PasEjAnt[.!='']"/>
								<xsl:value-of select="format-number(sum($sumaAnt),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Liquidacion del Presupuesto de Gastos-->
					<xsl:when test="local-name()='LiqPptoGastApp'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="6" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CredIni), '###.##0,00', 'european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModCred), '###.##0,00', 'european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CredDef), '###.##0,00', 'european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastCompr), '###.##0,00', 'european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Oblig), '###.##0,00', 'european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pag),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ObligPendPag),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RemCred),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Liquidacion del Presupuesto de Ingresos-->
					<xsl:when test="local-name()='LiqPptoIngApp'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PrevIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModPrev),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PrevDef),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerRec),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerAnul),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCanc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerRecNet),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Ing),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerPendCobr),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GradoRealizacion),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Inversiones destinadas al uso general-->
					<xsl:when test="local-name()='InvDestUsoGenDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Patrimonio entregado al uso general-->
					<xsl:when test="local-name()='PatEntUsoGenDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ValorBien),'###.##0,00','european')"/>
								</strong>
							</td>
						</xsl:when>
					<!--Inmovilizaciones inmateriales-->
					<xsl:when test="local-name()='InmovInmatDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Inmovilizaciones materiales-->
					<xsl:when test="local-name()='InmovMatDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Bienes en Régimen de Cesión Temporal-->
					<xsl:when test="local-name()='BienCesTempDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="4" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ValorBien),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Bienes en Régimen de Adscripción-->
					<xsl:when test="local-name()='BienAdscripDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ValorBien),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>					
					<!--Bienes Afectos a Garantías-->
					<xsl:when test="local-name()='BienEfectAGarantDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpGarant),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ValorBien),'###.##0,00','european')"/>
								</strong>
							</td>							
					</xsl:when>
					<!--Inversiones Gestionadas-->
					<xsl:when test="local-name()='InvGestDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Patrimonio Público del Suelo-->
					<xsl:when test="local-name()='PatrPublSuelDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Inversiones Financieras-->
					<xsl:when test="local-name()='InvFinDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Préstamos singulares significativos-->
					<xsl:when test="local-name()='PrestSingSigDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Imp),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Existencias-->
					<xsl:when test="local-name()='ExistDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PrecAdqCostProd),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpProvDepr),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Tesorería-->
					<xsl:when test="local-name()='TesDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Cobr),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pag),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Estado de conciliación bancaria-->
					<xsl:when test="local-name()='EstConcBancDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SaldSegEntBanc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrContEntYNoBanc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagContEntYNoBanc),'###.##0,00','european')"/>
								</strong>
							</td>							
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrContBancYNoEnt),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagContBancYNoEnt),'###.##0,00','european')"/>
								</strong>
							</td>							
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SaldConc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SaldSegEnt),'###.##0,00','european')"/>
								</strong>
							</td>			
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifSald),'###.##0,00','european')"/>
								</strong>
							</td>											
					</xsl:when>					
					<!--Fondos Propios-->
					<xsl:when test="local-name()='FondPropDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Capitales. Deudas en moneda nacional-->
					<xsl:when test="local-name()='EstDeudaCapNacDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>														
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneTot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Creac),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AmortDism),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicTot),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Capitales. Deudas en moneda distinta del euro-->
					<xsl:when test="local-name()='EstDeudaCapDistEurDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>														
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneTot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Creac),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifCamb),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AmortDism),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicTot),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Intereses Explicitos. Deudas en moneda nacional-->
					<xsl:when test="local-name()='EstDeudaIntExpNacDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev1EneLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev1EneCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:VencEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RectTrasp),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev31DicLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev31DicCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Intereses Explicitos. Deudas en moneda distinta del euro-->
					<xsl:when test="local-name()='EstDeudaIntExpDistEurDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev1EneLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev1EneCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:VencEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RectTrasp),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifCamb),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev31DicLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev31DicCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Intereses Implicitos. Deudas en moneda nacional-->
					<xsl:when test="local-name()='EstDeudaIntImpNacDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpEmision),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black"/>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpReembolso),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotIntImp),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:BajYRect),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEjAnt),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendDev31Dic),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Intereses Implicitos. Deudas en moneda distinta del euro-->
					<xsl:when test="local-name()='EstDeudaIntImpDistEurDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpEmision),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black"/>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpReembolso),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotIntImp),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:BajYRect),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEjAnt),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendDev31Dic),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Resultado de las Operaciones de Intercambio Financiero de Divisas-->
					<xsl:when test="local-name()='ResOperIntFinDivDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastForm),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IntDevDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IntDevAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifCamb),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ResCancAnt),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ResAcum),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Resultado de las Operaciones de Intercambio Financiero de Intereses-->
					<xsl:when test="local-name()='ResOperIntFinInterDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastForm),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IntDevDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IntDevAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifCamb),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ResCancAnt),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ResAcum),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Avales concedidos-->
					<xsl:when test="local-name()='AvConcDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="5" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Av1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AvConcEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AvCancEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Av31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Avales reintegrados-->
					<xsl:when test="local-name()='AvReinDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpRein),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black"/>
						<td style="border: solid; border-width:1; border-color=black"/>
					</xsl:when>
					<!--Desarrollo del Proceso de Gestión de los Recursos Administrados-->
					<xsl:when test="local-name()='DesProcGestRecAdminDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIniDerPendCobr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerRecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecBrut),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecDev),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecLiq),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCanc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerPendCobr),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Desarrollo de las Devoluciones de Recursos de Otros Entes Públicos-->
					<xsl:when test="local-name()='DesDevRecOtrEntPublDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevRecSalIniPendPag),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevRecModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevRecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevRecTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Obligaciones Derivadas de la Gestión-->
					<xsl:when test="local-name()='OblDerGestDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagRecLiq),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagReint),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagRealiz),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagPend31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Cuentas Corrientes con Otros Entes Públicos-->
					<xsl:when test="local-name()='CtaCorrOtrEntPublDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargSalIniDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargPag),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DatSalIniAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DatIng),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DatTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal31DicDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal31DicAcr),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Deudores-->
					<xsl:when test="local-name()='OperNoPresTesDeudDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AbRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DeudPendCobr31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Acreedores-->
					<xsl:when test="local-name()='OperNoPresTesAcrDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AbRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AcrPendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Partidas Pendientes de Aplicación. Cobros-->
					<xsl:when test="local-name()='OperNoPresTesPartPendAppCobrDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrPendApp1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotCobrPendApp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrAplicEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrPendApp31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Partidas Pendientes de Aplicación. Pagos-->
					<xsl:when test="local-name()='OperNoPresTesPartPendAppPagDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagPendApp1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotPagPendApp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagAplicEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagPendApp31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Subvenciones Recibidas Pendientes de Justificar-->
					<xsl:when test="local-name()='SubRecPendJustDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpRec),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpPendJust),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Transferencias y Subvenciones Concedidas Significativas-->
					<xsl:when test="local-name()='TransYSubConcSigDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" align="left" colspan="2">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1; border-color=black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Imp),'###.##0,00','european')"/>
								</strong>
							</td>
					</xsl:when>
					<!--Estado de Valores Recibidos en Depósito-->
					<xsl:when test="local-name()='EstValRecDepDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DepRecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDepRec),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DepCanc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DepPendDev31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Modificaciones de Crédito-->
					<xsl:when test="local-name()='ModCredDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="6" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CredExtra),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SuplCred),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AmplCred),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TransfCredPos),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TransfCredNeg),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IncRemCred),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CredGenIng),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:BajAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AjustProrrog),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotMod),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Remanentes de Crédito-->
					<xsl:when test="local-name()='RemCredDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="6" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RemCompIncorp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RemCompNoIncorp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RemNoCompIncorp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RemNoCompNoIncorp),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Proyectos de Gasto-->
					<xsl:when test="local-name()='ProGastDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="4" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastPrev),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastComp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblRec1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblRecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblRecTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastPendRealiz),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Acreedores por Operaciones Pendientes de Aplicar a Presupuesto-->
					<xsl:when test="local-name()='AcrOpsPendAplPresDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="7" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Importe),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pagado),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Proceso de Gestión: Derechos Anulados-->
					<xsl:when test="local-name()='DerAnulDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AnulLiq),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AplazYFracc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevIng),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDerAnul),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Proceso de Gestión: Derechos Cancelados-->
					<xsl:when test="local-name()='DerCancDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrEsp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Insolv),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OtrCausas),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDerCanc),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Proceso de Gestión: Recaudación Neta-->
					<xsl:when test="local-name()='RecNetDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevIng),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecNet),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Devoluciones de Ingresos-->
					<xsl:when test="local-name()='DevIngDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPag1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIniYAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDevRec),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Prescrip),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Compromisos de Ingreso-->
					<xsl:when test="local-name()='ComprIngDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprConcIncPresCerr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprConcEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprConcTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprRealiz),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendReal31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Obligaciones de Presupuestos Cerrados-->
					<xsl:when test="local-name()='OblPresCerrDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" align="left" colspan="7">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblPendPag1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIniYAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotObl),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Prescrip),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagRealiz),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblPendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Derechos a Cobrar de Presupuestos Cerrados. Derechos Anulados-->
					<xsl:when test="local-name()='DerPresCerrAnulDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" align="left" colspan="3">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendCobr1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerAnulLiq),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerAnulAplazYFracc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDerAnul),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Derechos a Cobrar de Presupuestos Cerrados. Derechos Extinguidos-->
					<xsl:when test="local-name()='DerPresCerrCancDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" align="left" colspan="3">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCancCobrEsp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCancInsolv),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCancPrescrip),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCancOtrCausas),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDerCanc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Rec),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendCobr31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Compromisos de Gasto con Cargo a Presupuestos de Ejercicios Posteriores-->
					<xsl:when test="local-name()='ComprGastEjPostsApp'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="7" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprGast),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Compromisos de Ingreso con Cargo a Presupuestos de Ejercicios Posteriores-->
					<xsl:when test="local-name()='ComprIngEjPostsApp'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprIng),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
					<!--Gastos con Financiación Afectada. Desviaciones de Financiación-->
					<xsl:when test="local-name()='DesvFinDet'">
						<td/>
						<td style="border: solid; border-width:1; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DesvEjPos),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DesvEjNeg),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DesvAcumPos),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1; border-color=black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DesvAcumNeg),'###.##0,00','european')"/>
							</strong>
						</td>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>
</xsl:stylesheet>
