<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cgel-04-b-2008="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-04-b-2008_2008-12-31" xmlns:str="http://exslt.org/strings" exclude-result-prefixes="str">
	<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.'/>
	<xsl:template match="/">
		<html>
			<head>
				<script language="Javascript" type="text/javascript" src="funciones.js"/>
				<link rel="stylesheet" type="text/css" href="estiloHTML.css"/>
				<title>Modelo Básico - Ejecución presupuestaria</title>
			</head>
			<body>
				<table height="50px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#FFD700" border="0">
					<tr>
						<td width="15px"><img height="50px" src="cab_lat01.gif" width="15" alt="izqda"/></td>
						<td><img height="50px" alt="Ministerio de Economía y Hacienda" src="logo_meh.gif" width="129px"/>
						</td><td style="font-size:30px; vertical-align:bottom; font-weight:bold; color:#FFEB80" align="center">Cuenta General XML Modelo Básico</td>
						<td><img height="50px" alt="Intervención General de la Administración del Estado" src="logo_igae.gif" width="115px" align="right"/></td>
						<td width="15px"><img height="50px" src="cab_lat02.gif" width="15px" alt="dcha"/></td>
					</tr>
				</table>
				<table cellspacing="0" cellpadding="0" width="100%" border="0">
					<tr>
						<td><img height="5px" src="null.gif" width="5px" alt="null"/></td>
					</tr>
				</table>
				<table height="20px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#A5BEE7" border="0">
					<tr style="font-size:8pt">
						<td width="15px">
							<img height="22px" src="b_estado_lat01.gif" width="15px"/>
						</td>
						<xsl:apply-templates select="//*[@tipo='I']"/>
						<td width="15px">
							<img height="22px" src="b_estado_lat02.gif" width="15px"/>
						</td>
					</tr>
				</table>
				<table id="Principal" bgcolor="#ffffff" cellspacing="0" style="left:0px; position:relative; top:5px" border="0">
				<tr bgcolor="darkblue">
				<td id="Td2">
							<table bgcolor="darkblue" id="Table2">
								<tr onmousedown="verMenu('InfEjePres')">
									<td>
										<a href="#">
											<b>Ejecución Presupuestaria</b>
										</a>
										<img src="tridownAm.gif" id="InfEjePresF" align="absmiddle"/>
									</td>
								</tr>
								<tr>
									<td>
										<div onclick="verMenu('InfEjePres')" id="InfEjePres">
											<table cellpadding="4px" cellspacing="0px" class="tablaMenu">
												<tr>
													<td class="celdaMenu">
														<a href="#DevIng">Devoluciones de Ingresos</a>
													</td>
												</tr>
												<tr>
													<td class="celdaMenu">
														<a href="#ObligPptosCerr">Obligaciones de Presupuestos Cerrado</a>
													</td>
												</tr>
												<tr>
													<td class="celdaMenu">
														<a href="#DerACobPptosCerr">Derechos a Cobrar de Presupuestos Cerrados</a>
													</td>
												</tr>
												<tr>
													<td class="celdaMenu">
														<a href="#CompPptosPosts">Compromisos de Gasto con Cargo a Presupuestos de Ejercicios Posteriores</a>
													</td>
												</tr>
												<tr>
													<td class="celdaMenu">
														<a href="#RecAfect">Recursos Afectados</a>
													</td>
												</tr>
												<tr>
													<td class="celdaMenu">
														<a href="#RemTes">Remanente de Tesorería</a>
													</td>
												</tr>
											</table>
										</div>
									</td>
								</tr>
							</table>
						</td>
						</tr>
					<tr bgcolor="#ffffff">
						<td colspan="8" width="900px">
							<!-- Listados -->
							<br />
							<hr />
							<xsl:apply-templates select="//cgel-04-b-2008:EjePpto/*[@tipo='L']"/>
						</td>
					</tr>
				</table>
			</body>
		</html>
	</xsl:template>
	<!--Plantilla Frame Datos Entidad-->
	<xsl:template name="frame_datos" match="//*[@tipo='I']">
		<xsl:for-each select=".//*[@tipo='D']">
			<xsl:if test="@des='Nombre Entidad'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des"/>:
					</strong>
					<xsl:value-of select="."/>
				</td>
			</xsl:if>
			<xsl:if test="@des='Código MAP'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des"/>:
					</strong>
					<xsl:value-of select="."/>
				</td>
			</xsl:if>
			<xsl:if test="@des='CIF'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des"/>:
					</strong>
					<xsl:value-of select="."/>
				</td>
			</xsl:if>
			<xsl:if test="@des='Ejercicio'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des"/>:
					</strong>
					<xsl:value-of select="."/>
				</td>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<!-- Plantilla Listados -->
	<xsl:template name="listado" match="//cgel-04-b-2008:EjePpto/*[@tipo='L']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<h2 style="background-color: darkblue">
			<font color="gold">
				<a>
					<xsl:attribute name="name"><xsl:value-of select="local-name()"/></xsl:attribute>
					<xsl:value-of select="@des"/>
				</a>
				<a href='javascript:VolverAlPrincipio()'><img src='ArrowUp.gif' align='absmiddle' alt='Volver al Principio'/></a>
				<!---Esto es el titulo del listado-->
			</font>
		</h2>
		<br/>
		<table cellspacing="0" cellpadding="4" width="900px" style="border-collapse:collapse">
			<tbody>
				<tr style="font-size:8pt" align="center">
					<td/>
					<td/>
					<xsl:for-each select=".//*[@tipo='C' and @des!='']">
						<!---Aqui se crean las cabeceras de las columnas-->
						<th style="border:solid; border-width:1px; border-color:black" bgcolor="LightSteelBlue">
							<xsl:value-of select="translate(@des, $small, $CAPS)"/>
						</th>
					</xsl:for-each>
				</tr>
				<!-- Aplicar plantilla de detalle -->
				<xsl:apply-templates select=".//*[@tipo='D']"/>
				<!-- Aplicar plantilla de totales -->
				<xsl:call-template name="totales"/>
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>
	<!-- Plantilla Detalles listados -->
	<xsl:template name="detalle" match="//*[@tipo='D']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<tr style="font-size:8pt">
			<td/>
			<xsl:choose>
				<xsl:when test="@des!=''">
					<td style="border:solid; border-width:1px; border-color:black">
						<!---Columnas con descripcion que no son cabeceras ni datos-->
						<strong>
							<xsl:value-of select="@des"/>
						</strong>
					</td>
				</xsl:when>
				<xsl:otherwise>
					<td width="0px"/>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select=".//*[@tipo='C']">
				<!---Aqui se crean las columnas con datos-->
				<xsl:choose>
					<xsl:when test=".=0">
						<td style="border:solid; border-width:1px;border-color:black" align="right">0,00</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')='NaN' or (format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')='')">
						<td style="border:solid; border-width:1px;border-color:black" align="left">
							<xsl:value-of select="concat(substring(translate(., $small, $CAPS),1,1),substring(translate(., $CAPS, $small),2))"/>
						</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')!=''">
						<td style="border:solid; border-width:1px;border-color:black" align="right">
							<xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
						</td>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>
	<!-- Plantilla totales -->
	<xsl:template name="totales">
		<xsl:for-each select=".//*[@tipo='T']">
			<tr style="font-size:8pt" align="right">
				<td/>
				<xsl:choose>
					<!--Devoluciones de Ingresos-->
					<xsl:when test="local-name()='TotDevIngApp'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:PendPag1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:RectYBaj,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:RecEje,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:TotRec,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:PagEje,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:PendPag31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Obligaciones de Presupuestos Cerrados-->
					<xsl:when test="local-name()='TotObligPptosCerrAnio'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:PendPag1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:RectYBaj,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:TotOblig,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:PagReal,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:PendPag31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Derechos a Cobrar de Presupuestos Cerrados-->
					<xsl:when test="local-name()='TotDerACobPptosCerrAnio'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:PendCob1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:RectYBaj,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:TotDerACob,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:Rec,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:PendCob31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Compromisos de Gasto con Cargo a Presupuestos de Ejercicios Posteriores-->
					<xsl:when test="local-name()='TotCompPptosPostsApp'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="5" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<xsl:value-of select="format-number(./cgel-04-b-2008:CompGast,'###.##0,00','european')"/>
						</td>
					</xsl:when>
				</xsl:choose>
			</tr>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
