﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-norm_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:output method="xml" indent="yes" encoding="UTF-8" omit-xml-declaration="yes" />
   <xsl:variable name="xmlMenu" select="document('../html/menu.xml')" />

   <xsl:template name="Cabecera" match="/">
      <div style="width: auto; height: auto;">
         <div class="divCabIndice">
            <div style="float: left; height: 50px; with: 160px; margin-left:10px;">
               <img alt="Ministerio de Economía y Hacienda" src="logo_meh.gif" width="129px" height="50px" />
            </div>
            <div style="float: right; width: 130px; height: 50px;">
               <img alt="Intervención General de la Administración del Estado" src="logo_igae.gif" width="115px" height="50px" />
            </div>
            <div class="textoCabecera">
               Cuenta General XML Modelo Normal 2015
            </div>
         </div>
         <xsl:call-template name="entidad" />
         <div style="margin:0; clear:left;">
            <xsl:call-template name="menu" />
         </div>
      </div>
   </xsl:template>

   <xsl:template name="menu">

      <div style="width: 100%;">
         <xsl:call-template name="menuElement">
            <xsl:with-param name="nodo" select="$xmlMenu/*"/>
            <xsl:with-param name="nivel" select="'1'"/>
         </xsl:call-template>
         <xsl:text>&#10;</xsl:text>
         <xsl:element name="script">
            <xsl:attribute name="type">text/javascript</xsl:attribute>
            <xsl:text disable-output-escaping="yes">
                     function goLink(url) {
                     window.open(url,"_self");
                     }
                  </xsl:text>
         </xsl:element>
      </div>
   </xsl:template>

   <xsl:template name="menuElement">
      <xsl:param name="nodo" />
      <xsl:param name="nivel" />

      <ul class="level{$nivel}">
         <xsl:for-each select="$nodo/*">
            <li>
               <xsl:choose>
                  <xsl:when test="count(./*) &gt; 0">
                     <a>
                        <xsl:choose>
                           <xsl:when test="$nivel=1">
                              <img src="tridown.gif" alt="flecha" />
                           </xsl:when>
                           <xsl:otherwise>
                              <img src="trileftNe.gif" alt="flecha" />
                           </xsl:otherwise>
                        </xsl:choose>
                        <xsl:value-of select="@name"/>
                     </a>
                     <xsl:call-template name="menuElement">
                        <xsl:with-param name="nodo" select="." />
                        <xsl:with-param name="nivel" select="$nivel + 1"/>
                     </xsl:call-template>
                  </xsl:when>
                  <xsl:otherwise>
                     <a href="javascript:goLink('{@url}')">
                        <img src="null.gif" alt="null"/>
                        <xsl:value-of select="@name"/>
                     </a>
                  </xsl:otherwise>
               </xsl:choose>
            </li>
         </xsl:for-each>
      </ul>

   </xsl:template>

   <xsl:template name="entidad">
      <table class="tablaEntidad" cellpadding="4px" cellspacing="0px">
         <tr>
            <td>
               <span class="labelCampo">Entidad: </span>
               <span class="valorCampo">
                  <xsl:value-of select="n1:Cuenta-Norm/n1:Entidad/n1:NomEnt" />
               </span>
            </td>
            <td>
               <span class="labelCampo">Código MAP: </span>
               <span class="valorCampo">
                  <xsl:value-of select="n1:Cuenta-Norm/n1:Entidad/n1:CodEnt" />
               </span>
            </td>
            <td>
               <span class="labelCampo">NIF: </span>
               <span class="valorCampo">
                  <xsl:value-of select="n1:Cuenta-Norm/n1:Entidad/n1:CIF" />
               </span>
            </td>
            <td>
               <span class="labelCampo">Ejercicio: </span>
               <span class="valorCampo">
                  <xsl:value-of select="n1:Cuenta-Norm/n1:Entidad/n1:Ejercicio" />
               </span>
            </td>
         </tr>
      </table>
   </xsl:template>

</xsl:stylesheet>