<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-norm_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2015.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InverInmob']//xs:element[@name='ModeloRevalorizacion']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="3" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera" style="vertical-align: top;">PARTIDA<br/>BALANCE</td>
                  <td class="cabecera" style="vertical-align: top;">SALDO INICIAL</td>
                  <td class="cabecera" style="vertical-align: top;">ENTRADAS<br/><br/><br/></td>
                  <td class="cabecera" style="vertical-align: top;">AUMENTOS POR<br />TRASPASOS DE<br />OTRAS PARTIDAS<br/></td>
                  <td class="cabecera" style="vertical-align: top;">SALIDAS<br/><br/><br/></td>
                  <td class="cabecera" style="vertical-align: top;">DISMINUCIONES<br />POR TRASPASOS A<br />OTRAS PARTIDAS<br/></td>
                  <td class="cabecera" style="vertical-align: top;">CORRECCIONES<br />VALORATIVAS NETAS<br />POR DETERIORO<br />DEL EJERCICIO</td>
                  <td class="cabecera" style="vertical-align: top;">AMORTIZACIÓN<br />DEL EJERCICIO<br/><br/></td>
                  <td class="cabecera" style="vertical-align: top;">REVALORIZACIONES<br /><br/><br/></td> 
                  <td class="cabecera" style="vertical-align: top;">SALDO FINAL</td>               
               </tr>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:InverInmob/n1:ModeloRevalorizacion" />
               </xsl:call-template>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/n1:Partida">
         <!-- Por cada hijo -->
            <tr>
               <td class="celdadatosizq">
                  <span><xsl:value-of select="n1:PartBal" /></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:SaldoIni, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Entradas, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AumTraspOtrasPart, '###.##0,00', 'format1')"/></span>
               </td>               
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Salidas, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:DismiTrasOtrasPart, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:CorrValNetasPorDetEje, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AmortEje, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Revalorizaciones, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:SaldoFinal, '###.##0,00', 'format1')"/></span>
               </td>                  
            </tr>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>   

</xsl:stylesheet>
