﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-norm_2015-01-01">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2015.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='InfCosteActiv']//xs:element[@name='ResCostElemAct']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="3" />
            </xsl:call-template>

            <table border="1" cellspacing="0" cellpadding="4">
               <tbody>
                  <tr>
                     <td class="cabecera">Actividad</td>
                     <td class="cabecera">
                        ELEMENTOS
                     </td>
                     <td style="width: 10%;" class="cabecera">
                        <span>COSTE<br/>DIRECTO</span>
                     </td>
                     <td style="width: 10%;" class="cabecera">
                        <span>COSTE<br/>INDIRECTO</span>
                     </td>
                     <td style="width: 10%;" class="cabecera">
                        <span>TOTAL</span>
                     </td>                     
                     <td style="width: 10%;" class="cabecera">
                        <span>%</span>
                     </td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:InfCosteActiv//n1:ResCostElemAct" />
                     <xsl:with-param name="nombre" select="'ResCostElemAct'" />
                     <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='InfCosteActiv']//xs:element[@name='ResCostElemAct']"/>
                  </xsl:call-template>
               </tbody>
            </table>
         </body>
      </html>
   </xsl:template>

    <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoSchema"></xsl:param>
      <xsl:param name="nombre"></xsl:param>

       <xsl:for-each select="$nodoPadre/n1:Actividad">
          <tr>
             <td rowspan="10" class="celdadatoscentro">
                <xsl:value-of select="n1:Nombre" />
             </td>
          </tr>
          <xsl:variable name="schemaDatos"  select="$nodoSchema//xs:element[@name='Actividad']" />

          <xsl:for-each select="n1:Datos/*">

             <xsl:variable name="nombreNodAct" select="name(.)" />
             <xsl:variable name="titulo" select="$schemaDatos//xs:element[@name=$nombreNodAct]//xs:documentation"></xsl:variable>
             <tr>
                <!-- nodo de datos -->
                <td class="celdadatosizq">
                   <span style="font-weight: bold;">
                      <xsl:value-of select="$titulo" />
                   </span>
                </td>
                <td class="celdadatosder">
                   <xsl:value-of select="format-number(n1:CosteDirecto, '###.##0,00', 'format1')"/>
                </td>
                <td class="celdadatosder">
                   <xsl:value-of select="format-number(n1:CosteIndirecto, '###.##0,00', 'format1')"/>
                </td>
                <td class="celdadatosder">
                   <xsl:value-of select="format-number(n1:Total, '###.##0,00', 'format1')"/>
                </td>
                <td class="celdadatosder">
                   <xsl:value-of select="format-number(n1:Porcentaje, '###.##0,00', 'format1')"/>%
                </td>
             </tr>

          </xsl:for-each>

       </xsl:for-each>

    </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
</xsl:stylesheet>
