﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-simp_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2015.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='ActFin']//xs:element[@name='InfBalance']//xs:element[@name='CorrecDeterValor']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />
            

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>
            
            <table border="1" cellspacing="0" cellpadding="4">
               <tr>
                  <td class="cabecera">CLASES DE ACTIVOS FINANCIEROS</td>
                  <td class="cabecera">SALDO INICIAL</td>
                  <td class="cabecera">
                     DISMINUCIONES<br/>
                     DE VALOR POR<br/>
                     DETERIORO<br/>
                     CREDITICIO<br/>
                     DEL EJERCICIO
                  </td>
                  <td class="cabecera">
                     REVERSIÓN DEL<br/>
                     DETERIORO<br/>
                     CREDITICIO<br/>
                     EN EL EJERCICIO
                  </td>
                  <td class="cabecera">SALDO FINAL</td>
               </tr>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:ActFin/n1:InfBalance/n1:CorrecDeterValor" />
                  <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='ActFin']//xs:element[@name='InfBalance']//xs:element[@name='CorrecDeterValor']"/>
                  <xsl:with-param name="esPrincipal" select="1"/>
               </xsl:call-template>
            </table>
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoSchema"></xsl:param>
      <xsl:param name="esPrincipal"></xsl:param>
      <xsl:param name="nombre"></xsl:param>

      <xsl:variable name="titulo" select="$nodoSchema[@name=$nombre]//xs:documentation"></xsl:variable>
      <!-- Por cada hijo -->
      <xsl:if test="count($nodoPadre/n1:SaldoInicial) = 1">
         <tr>
            <!-- nodo de datos -->
            <xsl:call-template name="titulo">
               <xsl:with-param name="texto" select="$titulo" />
            </xsl:call-template>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:SaldoInicial, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:DismValDetCredEjer, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:RevDeterCredEjer, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:SaldoFinal, '###.##0,00', 'format1')"/>
            </td>
         </tr>
      </xsl:if>

      <xsl:if test="count($nodoPadre/n1:SaldoInicial) = 0">
         <xsl:if test="$esPrincipal=0">
            <!-- nodo padre -->
            <tr>
               <xsl:call-template name="titulo">
                  <xsl:with-param name="texto" select="$titulo" />
               </xsl:call-template>
               <td class="celdadatosder" colspan="4">&#160;</td>
            </tr>
         </xsl:if>
         <xsl:for-each select="$nodoPadre/*[not(name()='Aplicable')]">
            <xsl:call-template name="filas">

               <xsl:with-param name="nodoPadre" select="." />
               <xsl:with-param name="nodoSchema" select="$nodoSchema//xs:element[position()]"/>
               <xsl:with-param name="esPrincipal" select="0" />
               <xsl:with-param name="nombre" select="name(.)" />
            </xsl:call-template>
         </xsl:for-each>
      </xsl:if>

   </xsl:template>

   <xsl:template name="titulo">
      <xsl:param name="texto"></xsl:param>

      <td class="celdadatosizq">

         <xsl:choose>
            <xsl:when test="starts-with($texto, 'Activos')">
               <span style="font-weight: bold;">
                  <xsl:value-of select="$texto" />
               </span>
            </xsl:when>
            <xsl:otherwise>
               <span>
                  <xsl:value-of select="$texto" />
               </span>
            </xsl:otherwise>
         </xsl:choose>

      </td>
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>
