﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-simp_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2015.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfPresupuestaria']//xs:element[@name='EjercicioCorriente']//xs:element[@name='ModifCredito']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />
      
      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="5" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera" rowspan="2"><span>APLICACIÓN<br/>PRESUPUESTARIA</span></td>
                  <td class="cabecera" rowspan="2"><span>DESCRIPCIÓN</span></td>
                  <td class="cabecera" rowspan="2"><span>CRÉDITOS<br/>EXTRAORDINARIOS</span></td>
                  <td class="cabecera" rowspan="2"><span>SUPLEMENTOS<br/>DE CRÉDITO</span></td>
                  <td class="cabecera" rowspan="2"><span>AMPLIACIONES<br/>DE CRÉDITO</span></td>
                  <td class="cabecera" colspan="2">TRANSFERENCIAS<br/>DE CRÉDITO</td>
                  <td class="cabecera" rowspan="2"><span>INCORPORACIONES<br/>DE REMANENTES<br/>DE CRÉDITO</span></td>
                  <td class="cabecera" rowspan="2"><span>CRÉDITOS<br/>GENERADOS<br/>POR INGRESOS</span></td>
                  <td class="cabecera" rowspan="2"><span>BAJAS POR<br/>ANULACIÓN</span></td>
                  <td class="cabecera" rowspan="2"><span>AJUSTES POR<br/>PRÓRROGA</span></td>
                  <td class="cabecera" rowspan="2"><span>TOTAL<br/>MODIFICACIONES</span></td>
               </tr>
               <tr>
                  <td class="cabecera"><span>POSITIVAS</span></td>
                  <td class="cabecera"><span>NEGATIVAS</span></td>
               </tr>
               <xsl:variable name="padre" select="//n1:Memoria/n1:InfPresupuestaria/n1:EjercicioCorriente/n1:PptoGastos/n1:ModifCredito" />
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="$padre" />
               </xsl:call-template>
               <!-- TOTAL -->
               <tr>
                  <td class="celdadatosder" colspan="2">
                     <span style="font-weight: bold;">TOTAL</span>
                  </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:CredExtra, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:SuplemCred, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:AmpliCred, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:TransfCredPos, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:TransfCredNeg, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:IncorRemanCred, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:CredGenPorIngr, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:BajasPorAnul, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:AjusPorProrr, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number($padre/n1:Total/n1:TotModif, '###.##0,00', 'format1')"/></span>
               </td>                   
               </tr>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <!-- Por cada hijo -->
         <xsl:if test="count(./n1:Datos) = 1">
            <tr>
               <td class="celdadatosizq">
                  <span style="font-weight: bold;">
                     <xsl:value-of select="n1:Datos/n1:CodOrg" />.<xsl:value-of select="n1:Datos/n1:CodProg" />.<xsl:value-of select="n1:Datos/n1:CodEcoG" />
                  </span>
               </td>
               <td class="celdadatosizq">
                  <span>
                     <xsl:value-of select="n1:Datos/n1:DesOrg" /><br/>
                     <xsl:value-of select="n1:Datos/n1:DesProg" /><br/>
                     <xsl:value-of select="n1:Datos/n1:DesEcoG" />
                  </span>
               </td>       
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:CredExtra, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:SuplemCred, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AmpliCred, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:TransfCredPos, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:TransfCredNeg, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:IncorRemanCred, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:CredGenPorIngr, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:BajasPorAnul, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AjusPorProrr, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:TotModif, '###.##0,00', 'format1')"/></span>
               </td>      
            </tr>
         </xsl:if>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>
