﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-simp_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2015.xsd')" />
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>

   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='IndFinPatriYPprios']//xs:element[@name='IndFinYPatri']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="3" />
            </xsl:call-template>

            <xsl:for-each select="//n1:IndFinPatriYPprios/n1:IndFinYPatri/*">
               <xsl:variable name="nombre" select="name(.)" />
               <xsl:choose>
                  <xsl:when test="count(child::*/*) &gt; 0">
                     <xsl:variable name="tituloPadre" select="$schema//xs:element[@name=$nombre]//xs:documentation"/>
                     <h6>
                        <xsl:value-of select="$tituloPadre" />
                     </h6>
                     <xsl:for-each select="*">
                        <xsl:variable name="nombreHijo" select="name(.)" />
                        <xsl:call-template name="indicador">
                           <xsl:with-param name="nombreNodo" select="$nombreHijo" />
                           <xsl:with-param name="nodoPadre" select="."/>
                           <xsl:with-param name="tab" select="'&#160;&#160;&#160;'" />
                        </xsl:call-template>
                     </xsl:for-each>
                  </xsl:when>
                  <xsl:otherwise>
                     <xsl:call-template name="indicador">
                        <xsl:with-param name="nombreNodo" select="$nombre" />
                        <xsl:with-param name="nodoPadre" select="."/>
                     </xsl:call-template>                     
                  </xsl:otherwise>
               </xsl:choose>
            </xsl:for-each>
        </body>
      </html>
   </xsl:template>

   <xsl:template name="indicador">
      <xsl:param name="nombreNodo"  />
      <xsl:param name="nodoPadre" />
      <xsl:param name="tab" />
      <xsl:variable name="titulo" select="$schema//xs:element[@name=$nombreNodo]//xs:documentation"/>
      <h6>
         <xsl:value-of select="$tab" /><xsl:value-of select="$titulo" />
      </h6>

      <div style="margin-left: 30px;">
         <table style="width:60%;">
            <tr>
               <xsl:for-each select="$schema//xs:element[@name=$nombreNodo]//xs:element">
                  <th class="cabecera mayusculas" style="width:20%;">
                     <xsl:value-of select="xs:annotation/xs:documentation" />
                  </th>
               </xsl:for-each>
            </tr>
            <tr>
               <xsl:for-each select="$nodoPadre/*">
                  <td class="celdadatosder">
                     <xsl:variable name="nombreElemento" select="name(.)"  />
                     <xsl:variable name="tipoDato" select="$schema//xs:element[@name=$nombreElemento]/@type"/>
                     <xsl:choose>
                        <xsl:when test="$tipoDato='Importe'">
                           <xsl:value-of select="format-number(., '###.##0,00', 'format1')"/>
                        </xsl:when>
                        <xsl:otherwise>
                           <xsl:value-of select="format-number(., '###.##0', 'format1')"/>
                        </xsl:otherwise>
                     </xsl:choose>
                  </td>
               </xsl:for-each>
            </tr>
         </table>
      </div>
   </xsl:template>
   
   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>   
</xsl:stylesheet>
