﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-simp_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2015.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='PasFin']//xs:element[@name='InfAvales']//xs:element[@name='AvalesConcedidos']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera" rowspan="2">
                     <span>
                        IDENTIFICACIÓN<br />
                        AVAL
                     </span>
                  </td>
                  <td class="cabecera" colspan="2">ENTIDAD AVALADA</td>
                  <td class="cabecera" rowspan="2">
                     FECHA<br />
                     CONCESIÓN<br />
                     AVAL
                  </td>
                  <td class="cabecera" rowspan="2">
                     FECHA<br />
                     VENCIMIENTO<br />
                     AVAL
                  </td>
                  <td class="cabecera" rowspan="2">
                     FINALIDAD<br />
                     AVAL
                  </td>
                  <td class="cabecera" rowspan="2">
                     AVALES<br />
                     PENDIENTES<br />
                     A 1 DE ENERO
                  </td>
                  <td class="cabecera" rowspan="2">
                     AVALES<br />
                     CONCEDIDOS<br />
                     EN EL<br />
                     EJERCICIO
                  </td>
                  <td class="cabecera" colspan="3">
                     AVALES CANCELADOS EN EL
                     <br />
                     EJERCICIO
                  </td>
                  <td class="cabecera" rowspan="2">
                     AVALES<br />
                     PENDIENTES<br />
                     A 31 DE
                     <br />
                     DICIEMBRE
                  </td>
                  <td class="cabecera" colspan="2">PROVISIONES</td>
               </tr>
               <tr>
                  <td class="cabecera">NIF</td>
                  <td class="cabecera">
                     <span>DENOMINACIÓN</span>
                  </td>
                  <td class="cabecera">
                     POR<br />
                     EJECUCIÓN
                  </td>
                  <td class="cabecera">
                     POR
                     <br />
                     OTRAS
                     <br />
                     CAUSAS
                  </td>
                  <td class="cabecera">
                     <span>TOTAL</span>
                  </td>
                  <td class="cabecera">EJERCICIO</td>
                  <td class="cabecera">ACUMULADA</td>
               </tr>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:EntMultiGrupYAsoc" />
                  <xsl:with-param name="subTotal" select="'SUBTOTAL ENTIDADES DEL GRUPO, MULTIGRUPO Y ASOCIADAS'" />
               </xsl:call-template>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:OtrasEntidades" />
                  <xsl:with-param name="subTotal" select="'SUBTOTAL OTRAS ENTIDADES'" />
               </xsl:call-template>
               <tr>
                  <td class="cabecera" colspan="6" style="text-align: right;">
                     <span>TOTAL</span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:Total/n1:AvalPend1Ene, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:Total/n1:AvalConcEnEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:Total/n1:AvalCancEjePorEjec, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:Total/n1:AvalCancEjePorOtrasCausas, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:Total/n1:AvalCancEjeTotal, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:Total/n1:AvalPend31Dic, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:Total/n1:ProvisionesEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesConcedidos/n1:Total/n1:ProviAcumulada, '###.##0,00', 'format1')"/></span>
                  </td>
               </tr>               
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="subTotal"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <!-- Por cada hijo -->
         <xsl:if test="count(./n1:IdAval) = 1">
            <tr>
               <td class="celdadatosizq">
                  <span><xsl:value-of select="n1:IdAval" /></span>
               </td>
               <td class="celdadatosizq">
                  <span><xsl:value-of select="n1:EntAvalNif" /></span>
               </td>
               <td class="celdadatosizq">
                  <span><xsl:value-of select="n1:EntAvalNombre" /></span>
               </td>
               <td class="celdadatosizq">
                  <span><xsl:value-of select="n1:FechaConcAval" /></span>
               </td>
               <td class="celdadatosizq">
                  <span><xsl:value-of select="n1:FechaVencAval" /></span>
               </td>
               <td class="celdadatosizq">
                  <span><xsl:value-of select="n1:FinalidadAval" /></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AvalPend1Ene, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AvalConcEnEje, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AvalCancEjePorEjec, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AvalCancEjePorOtrasCausas, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AvalCancEjeTotal, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:AvalPend31Dic, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:ProvisionesEje, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:ProviAcumulada, '###.##0,00', 'format1')"/></span>
               </td>
            </tr>
         </xsl:if>
      </xsl:for-each>
      <tr>
         <td class="cabecera" colspan="6" style="text-align: right;">
            <span><xsl:value-of select="$subTotal"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:SubTotal/n1:AvalPend1Ene, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:SubTotal/n1:AvalConcEnEje, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:SubTotal/n1:AvalCancEjePorEjec, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:SubTotal/n1:AvalCancEjePorOtrasCausas, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:SubTotal/n1:AvalCancEjeTotal, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:SubTotal/n1:AvalPend31Dic, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:SubTotal/n1:ProvisionesEje, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:SubTotal/n1:ProviAcumulada, '###.##0,00', 'format1')"/></span>
         </td>
      </tr>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
</xsl:stylesheet>
