﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/BASICAL_Cuenta-Norm-2019"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2019.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='LiqPpto']//xs:element[@name='LiqPptoIng']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>
            
            <table border="1" cellspacing="0" cellpadding="4" style="width:100%">
               <tbody>
                  <tr>
                     <td rowspan="2" class="cabecera">
                        APLICACIÓN
                     </td>
                     <td rowspan="2" style="width: 30%;" class="cabecera">
                        DESCRIPCIÓN
                     </td>
                     <td colspan="3" class="cabecera">
                        PREVISIONES PRESUPUESTARIAS
                     </td>
                     <td class="cabecera" rowspan="2">
                        DERECHOS<br />
                        RECONOCIDOS<br />(4)
                     </td>
                     <td class="cabecera" rowspan="2">
                        DERECHOS<br />
                        ANULADOS<br />
                        (5)
                     </td>
                     <td class="cabecera" rowspan="2">
                        DERECHOS<br />
                        CANCELADOS<br/>
                        (6)
                     </td>
                     <td class="cabecera" rowspan="2">
                        DERECHOS<br />
                        RECONOCIDOS<br />
                        NETOS<br />
                        (7=4-5-6)
                     </td>
                     <td class="cabecera" rowspan="2">
                        RECAUDACIÓN<br />
                        NETA<br />
                        (8)
                     </td>
                     <td class="cabecera" rowspan="2">
                        DERECHOS<br />
                        PENDIENTE<br />
                        DE COBRO<br />
                        A 31 DE<br />
                        DICIEMBRE<br />
                        (9=7-8)
                     </td>
                     <td class="cabecera" rowspan="2">
                        EXCESO/<br />
                        DEFECTO<br />
                        PREVISIÓN<br />
                        (10=7-3)
                     </td>
                  </tr>
                  <tr>
                     <td class="cabecera">
                        INICIALES<br />(1)
                     </td>
                     <td class="cabecera">
                        MODIFIC.<br />(2)
                     </td>
                     <td class="cabecera">
                        DEFINITIVAS<br />(3=1+2)
                     </td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:LiqPpto/n1:LiqPptoIng" />
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
            <!-- Por cada hijo -->
            <tr>
               <xsl:choose>
                  <xsl:when test="name(.) = 'TotLiqPptoIngApp'">
                     <td  class="celdadatosder" colspan="2">
                        <span style="font-weight: bold;">
                           TOTAL
                        </span>
                     </td>                  
                  </xsl:when>
                  <xsl:when  test="name(.)='LiqPptoIngApp'">
                     <td  class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:ApliPpria/n1:CodOrg" />.<xsl:value-of select="n1:ApliPpria/n1:CodEcoI" />
                        </span>
                     </td>
                     <td  class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:ApliPpria/n1:DesOrg" /><br/>
                           <xsl:value-of select="n1:ApliPpria/n1:DesEcoI" />
                        </span>
                     </td>
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PrevIni, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ModPrev, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PrevDef, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:DerRec, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:DerAnul, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:DerCanc, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:DerRecNet, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:Ing, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:DerPendCobr, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:GradoRealizacion, '###.##0,00', 'format1')"/></td>
            </tr>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>   
   
</xsl:stylesheet>
