<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/BASICAL_Cuenta-Norm-2019"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2019.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfPresupuestaria']//xs:element[@name='DesviFinanPorAgentFinan']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera" rowspan="3"><span>CÓDIGO DE<br/>GASTO IGUAL<br/>CÓDIGO<br/>PROYECTO</span></td>
                  <td class="cabecera" rowspan="3"><span>DESCRIPCIÓN</span></td>
                  <td class="cabecera" colspan="6"><span>AGENTE FINANCIADOR</span></td>
                  <td class="cabecera" rowspan="3"><span>COEFICIENTE DE<br/>FINANCIACIÓN</span></td>
                  <td class="cabecera" colspan="2"><span>DESVIACIONES DEL EJERCICIO</span></td>
                  <td class="cabecera" colspan="2"><span>DESVIACIONES ACUMULADAS</span></td>
               </tr>
               <tr>
                  <td class="cabecera" rowspan="2"><span>NIF<br/>TERCERO</span></td>
                  <td class="cabecera" rowspan="2"><span>DESCRIPCIÓN<br/>TERCERO</span></td>
                  <td class="cabecera" colspan="4"><span>APLICACIÓN PRESUPUESTARIA</span></td>
                  <td class="cabecera" rowspan="2"><span>POSITIVAS</span></td>
                  <td class="cabecera" rowspan="2"><span>NEGATIVAS</span></td>
                  <td class="cabecera" rowspan="2"><span>POSITIVAS</span></td>
                  <td class="cabecera" rowspan="2"><span>NEGATIVAS</span></td>
               </tr>
               <tr>
                  <td class="cabecera"><span>CÓDIGO<br/>ORGÁNICO</span></td>
                  <td class="cabecera"><span>DESCRIPCIÓN<br/>ORGÁNICO</span></td>
                  <td class="cabecera"><span>CÓDIGO<br/>ECONÓMICO</span></td>
                  <td class="cabecera"><span>DESCRIPCIÓN<br/>ECONÓMICA</span></td>                  
               </tr>
               <xsl:variable name="padre" select="//n1:Memoria/n1:InfPresupuestaria/n1:GastoConFinAfect/n1:DesviFinanPorAgentFinan" />
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="$padre" />
               </xsl:call-template>
               <!-- TOTAL -->
               <tr>
                  <td class="celdadatosder" colspan="9">
                     <span style="font-weight: bold;">TOTAL</span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:DesviEjercicio/n1:Positivas, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:DesviEjercicio/n1:Negativas, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:DesviAcumuladas/n1:Positivas, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:DesviAcumuladas/n1:Negativas, '###.##0,00', 'format1')"/></span>
                  </td>
               </tr>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/n1:Gasto">
         <tr>
            <td class="celdadatosizq">
               <span style="font-weight: bold;"><xsl:value-of select="n1:CodGasto" /></span>
            </td>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:Descripción" /></span>
            </td>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:AgenteFinan/n1:NIFTercero" /></span>
            </td>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:AgenteFinan/n1:DesTercero" /></span>
            </td>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:AgenteFinan/n1:ApliPpria/n1:CodOrg" /></span>
            </td>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:AgenteFinan/n1:ApliPpria/n1:DesOrg" /></span>
            </td>
            <td class="celdadatosizq">
               <xsl:value-of select="n1:AgenteFinan/n1:ApliPpria/n1:CodEcoI" />
            </td>
            <td class="celdadatosizq">
               <xsl:value-of select="n1:AgenteFinan/n1:ApliPpria/n1:DesEcoI" />
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:CoefiFinan, '###.##0,00', 'format1')"/>%</span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:DesviEjercicio/n1:Positivas, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:DesviEjercicio/n1:Negativas, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:DesviAcumuladas/n1:Positivas, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:DesviAcumuladas/n1:Negativas, '###.##0,00', 'format1')"/></span>
            </td> 
         </tr>
      </xsl:for-each>
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
