﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="xs xsl msxsl">

   <xsl:output method="xml" indent="yes" encoding="UTF-8" omit-xml-declaration="yes" />   
   <xsl:template match="/">
      <div style="width: 100%;">
         <xsl:call-template name="menu">
            <xsl:with-param name="nodo" select="/*"/>
            <xsl:with-param name="nivel" select="'1'"/>
         </xsl:call-template>
         <xsl:text>&#10;</xsl:text>
         <xsl:element name="script">
            <xsl:attribute name="type">text/javascript</xsl:attribute>
            <xsl:text disable-output-escaping="yes">
               function goLink(url) {
                  window.open(url,"_self");
               }
            </xsl:text>
         </xsl:element>
      </div>
   </xsl:template>

   <xsl:template name="menu">
      <xsl:param name="nivel" />
      <xsl:param name="nodo" />

      <ul class="level{$nivel}">
         <xsl:for-each select="$nodo/*">
            <li>
               <xsl:choose>
                  <xsl:when test="count(./*) &gt; 0">
                     <a>
                        <xsl:choose>
                           <xsl:when test="$nivel=1">
                              <img src="tridown.gif" alt="flecha" />
                           </xsl:when>
                           <xsl:otherwise>
                              <img src="trileftNe.gif" alt="flecha" />
                           </xsl:otherwise>
                        </xsl:choose>
                        <xsl:value-of select="@name"/></a>
                     <xsl:call-template name="menu">
                        <xsl:with-param name="nodo" select="." />
                        <xsl:with-param name="nivel" select="$nivel + 1"/>
                     </xsl:call-template>                    
                  </xsl:when>
                  <xsl:otherwise>
                     <a href="javascript:goLink('{@url}')">
                        <img src="null.gif" alt="null"/>
                        <xsl:value-of select="@name"/>
                     </a>
                  </xsl:otherwise>
               </xsl:choose>
            </li>
         </xsl:for-each>
      </ul>

   </xsl:template>
   
</xsl:stylesheet>
