<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='EntDependientes']//xs:element[@name='DependExcluidas']" />
      <xsl:variable name="nodoEnumTipoEnte" select="$schema//xs:simpleType[@name='TipoEnte']//xs:restriction" />
      <xsl:variable name="nodoEnumSector" select="$schema//xs:simpleType[@name='Sector']//xs:restriction" />
      <xsl:variable name="nodoEnumCausasExcl" select="$schema//xs:simpleType[@name='CausasExcl']//xs:restriction" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>

            <h3>Identificación de las entidades excluidas</h3> 

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='CONS'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera"> ARTÍCULO 8a) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas1">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

              <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='FUN'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas2">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='OA'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas3">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='EPE'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas4">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='SM'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas5">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='CONS'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera"> ARTÍCULO 8b) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas6">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='FUN'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas7">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='OA'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas8">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='EPE'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas9">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='SM'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas10">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='CONS'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera"> ARTÍCULO 8c) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas11">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='FUN'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas12">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='OA'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas13">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='EPE'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas14">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='SM'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas15">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <h3>Porcentaje de participación en las entidades del grupo excluidas</h3> 

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='CONS'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas16">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='FUN'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas17">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='OA'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas18">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='EPE'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas19">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='SM'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas20">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='CONS'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas21">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='FUN'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas22">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>
            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='OA'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas23">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>
            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='EPE'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas24">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='SM'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas25">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

               <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='CONS'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas26">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='FUN'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas27">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>
            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='OA'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas28">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>
            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='EPE'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas29">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='SM'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td rowspan="3" class="cabecera">NIF</td>
                        <td rowspan="3" class="cabecera">NOMBRE ENTIDAD</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                        <td colspan="3" class="cabecera" >PARTICIPACIÓN INDIRECTA</td>
                        <td rowspan="3" class="cabecera" >PARTICIPACIÓN <br/>TOTAL<br/>(%)</td>
                     </tr>
                     <tr>
                        <td rowspan="2" class="cabecera" >%</td>
                        <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                     </tr>
                     <tr>
                        <td  class="cabecera" >NIF</td>
                        <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                     </tr>
                     <xsl:call-template name="filas30">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if> 

             <h3>Patrimonio neto del último ejercicio</h3> 

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='CONS'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PATRIMONIO NETO DEL ÚLTIMO EJERCICIO</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     
                     <xsl:call-template name="filas31">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='FUN'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas32">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='OA'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas33">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='EPE'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas34">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8a' and n1:TipoEnte='SM'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas35">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='CONS'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas36">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='FUN'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - FUNDACIÓN</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas37">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>
            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='OA'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas38">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>
            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='EPE'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas39">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8b' and n1:TipoEnte='SM'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas40">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

               <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='CONS'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas41">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='FUN'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - FUNDACIÓN</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas42">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>
            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='OA'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas43">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>
            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='EPE'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas44">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientes/n1:DependExcluidas/n1:DependE[n1:CausasExclusion='8c' and n1:TipoEnte='SM'])">
               <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
                  <tbody>
                     <tr>
                        <td colspan="6" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES DEL GRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="7" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                      <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                        <td class="cabecera">CAPITAL O PATRIMONIO</td>
                        <td class="cabecera">RESERVAS Y<br/>RESULTADOS DE<br/>EJERCICIOS ANTERIORES</td>
                        <td class="cabecera">RESULTADOS DEL<br/>EJERCICIO</td>
                        <td class="cabecera">OTRO<br/> PATRIMONIO <br/>NETO</td>
                        <td class="cabecera">PATRIMONIO<br/> NETO TOTAL</td>
                     </tr>
                     <xsl:call-template name="filas45">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if> 
            
         </body>
      </html>
   </xsl:template>

   <xsl:template name="filas1">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

    <xsl:template name="filas2">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas3">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas4">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas5">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas6">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 
   
   <xsl:template name="filas7">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas8">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas9">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 
   
   <xsl:template name="filas10">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="filas11">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>  
   
   <xsl:template name="filas12">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>  
   
   <xsl:template name="filas13">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>  
   
   <xsl:template name="filas14">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>  

   <xsl:template name="filas15">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>  

   <xsl:template name="filas16">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 
   
   <xsl:template name="filas17">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 
   
   <xsl:template name="filas18">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="filas19">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="filas20">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="filas21">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas22">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas23">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas24">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas25">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas26">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
        
   <xsl:template name="filas27">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
        
   <xsl:template name="filas28">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
        
   <xsl:template name="filas29">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
        
   <xsl:template name="filas30">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>

   <xsl:template name="filas31">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 
   
   <xsl:template name="filas32">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>   
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 
   
   <xsl:template name="filas33">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>   
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="filas34">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>   
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="filas35">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td> 
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="filas36">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>   
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas37">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td> 
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas38">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>    
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas39">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas40">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>  
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
     
   <xsl:template name="filas41">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td> 
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
        
   <xsl:template name="filas42">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td> 
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
        
   <xsl:template name="filas43">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>  
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
        
   <xsl:template name="filas44">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td> 
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
        
   <xsl:template name="filas45">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />   
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependE'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerCapital, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerReservResEjerAnt, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerResEjer, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerOtroPatriNeto, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:PatriNetoUltEjerPatriNetoTotal, '###.##0,00', 'format1')"/></td>     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>

  
   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
