<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022">
   
   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:variable name="ejercicio" select="//n1:Entidad/n1:Ejercicio" />
   
   <xsl:template match="/">
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='EstadoCambiosPatriNeto']//xs:element[@name='EstadoTotalCambiosPatriNeto']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />
      
      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />
            
            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>

            <table border="1" cellspacing="0" cellpadding="4">
               <tbody>
                  <tr>
                     <td style="border-width: 0px; font-weight: bold; width: 34%;" class="total">
                     </td>
                     <td style="width: 10%;" class="cabecera">
                        <span>NOTAS<br />MEMORIA</span>
                     </td>
                     <td style="width: 11%;" class="cabecera">
                        <span>I. Patrimonio</span>
                     </td>
                     <td style="width: 11%;" class="cabecera">
                        <span>II. Patrimonio<br />generado</span>
                     </td>
                     <td style="width: 11%;" class="cabecera">
                        <span>III. Ajustes por<br />cambios de valor</span>
                     </td>
                     <td style="width: 11%;" class="cabecera">
                        <span>IV. Subvenciones<br />recibidas</span>
                     </td>
                     <td style="width: 11%;" class="cabecera">
                        <span>V. Socios<br />externos</span>
                     </td>
                     <td style="width: 11%;" class="cabecera">
                        <span>TOTAL</span>
                     </td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:EstadoCambiosPatriNeto//n1:EstadoTotalCambiosPatriNeto" />
                     <xsl:with-param name="nombre" select="'EstadoTotalCambiosPatriNeto'" />
                     <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='EstadoTotalCambiosPatriNeto']"/>
                     <xsl:with-param name="esPrincipal" select="1"/>
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoSchema"></xsl:param>
      <xsl:param name="esPrincipal"></xsl:param>
      <xsl:param name="nombre"></xsl:param>

      <xsl:variable name="titulo" select="$nodoSchema[@name=$nombre]//xs:documentation"></xsl:variable>
      
      <!-- Por cada hijo -->
      <xsl:if test="count($nodoPadre/n1:NotMemoria) = 1">
         <tr>
            <!-- nodo de datos -->
            <xsl:call-template name="titulo">
               <xsl:with-param name="texto" select="$titulo" />
            </xsl:call-template>
            <td style="overflow: auto;" class="celdadatosizq">
               <xsl:value-of select="$nodoPadre/n1:NotMemoria"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:Patrimonio, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:PatrimonioGen, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:AjusCambVal, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:SubvRecibidas, '###.##0,00', 'format1')"/>
            </td>
			<td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:SociosExt, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:Total, '###.##0,00', 'format1')"/>
            </td>
         </tr>  
      </xsl:if>

      <xsl:if test="count($nodoPadre/n1:NotMemoria) = 0 or count($nodoPadre/n1:Datos) &gt; 0">

         <xsl:for-each select="$nodoPadre/*">
            <xsl:variable name="nombreNodAct" select="name(.)" />
            <xsl:call-template name="filas">
               <xsl:with-param name="nodoPadre" select="." />
               <xsl:with-param name="esPrincipal" select="0" />
               <xsl:with-param name="nombre" select="name(.)" />
               <xsl:with-param name="nodoSchema" select="$nodoSchema//xs:element[@name=$nombreNodAct]"/>
            </xsl:call-template>
         </xsl:for-each>         
         
      </xsl:if>
   </xsl:template>

   <xsl:template name="titulo">
      <xsl:param name="texto" />

      <td class="celdadatosizq">
            <xsl:choose>
               <xsl:when test="number(substring($texto,1,1))=number(substring($texto,1,1))">
                  <span>&#160;&#160;&#160;
                     <xsl:call-template name="replace">
                        <xsl:with-param name="texto" select="$texto" />
                     </xsl:call-template>
                  </span>
               </xsl:when>               
               <xsl:otherwise>
                  <span style="font-weight: bold;">
                     <xsl:call-template name="replace">
                        <xsl:with-param name="texto" select="$texto" />
                     </xsl:call-template>
                  </span>
               </xsl:otherwise>
            </xsl:choose>
      </td>
   </xsl:template>

   <xsl:template name="replace">
      <xsl:param name="texto" />
      <xsl:choose>
         <xsl:when test="contains($texto,'EJERCICIO ACTUAL')">
            <xsl:value-of select="substring-before($texto,'EJERCICIO ACTUAL')" />
            EJERCICIO <xsl:value-of select="$ejercicio"/>
            <xsl:value-of select="substring-after($texto,'EJERCICIO ACTUAL')" />
         </xsl:when>
         <xsl:when test="contains($texto,'EJERCICIO ANTERIOR')">
            <xsl:value-of select="substring-before($texto,'EJERCICIO ANTERIOR')" />
            EJERCICIO <xsl:value-of select="$ejercicio - 1"/>
            <xsl:value-of select="substring-after($texto,'EJERCICIO ANTERIOR')" />
         </xsl:when>         
         <xsl:otherwise>
            <xsl:value-of select="$texto" />
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
