<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">
   
   <xsl:import href="Cabecera.xslt"/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>

   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='IndGestion']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <!-- titulo principal de la página -->
            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>

            <!-- Recorremos todos los hijos del nodo padre. -->
            <xsl:for-each select="//n1:IndGestion/*">

               <!-- nombre del nodo hijo actual -->
               <xsl:variable name="nombre" select="name(.)" />

               <!-- llamamos a la plantilla para que gestione -->
               <xsl:call-template name="indicador">

                  <!-- pasamos los parámetros -->
                  <xsl:with-param name="nombreNodo" select="$nombre" />
                  <xsl:with-param name="nodoPadre" select="//n1:IndGestion" />
                  <xsl:with-param name="schemaPadre" select="$schema" />
                  <xsl:with-param name="schemaHijo" select="$schema//xs:element[@name=$nombre]" />


               </xsl:call-template>

            </xsl:for-each>

         </body>
      </html>
   </xsl:template>

   <xsl:template name="indicador">
      <!-- Parámetros -->
      <xsl:param name="nombreNodo" />
      <xsl:param name="nodoPadre" />
      <xsl:param name="schemaPadre" />
      <xsl:param name="schemaHijo" />


      <!-- nombre del nodo actual -->
      <xsl:variable name="nombre" select="name(.)" />

      <!-- si es actividad insertamos los datos -->
      <xsl:choose>
         <xsl:when  test="$nombre!='Actividad'">

            <h6>
               &#160;&#160;&#160;
               <xsl:value-of select="$schemaHijo//xs:documentation" />
            </h6>

            <xsl:for-each select="./*">

               <xsl:variable name="nombreHijo" select="name(.)" />

               <xsl:call-template name="indicador">
                  <xsl:with-param name="nombreNodo" select="$nombreHijo" />
                  <xsl:with-param name="nodoPadre" select=".." />
                  <xsl:with-param name="schemaHijo" select="$schemaHijo//xs:element[@name=$nombreHijo]" />
                  <xsl:with-param name="schemaPadre" select="$schemaHijo" />
               </xsl:call-template>

            </xsl:for-each>

         </xsl:when>
         <xsl:otherwise>
            <xsl:if test="position()=1">
               <!-- ponemos los datos de la tabla -->
               <xsl:call-template name="datos">

                  <xsl:with-param name="nombreNodo" select="$nombre" />
                  <xsl:with-param name="schemaPart" select="$schemaPadre" />

               </xsl:call-template>
            </xsl:if>
         </xsl:otherwise>
      </xsl:choose>

   </xsl:template>

   <xsl:template name="datos">

      <!-- parámetros -->
      <xsl:param name="nombreNodo"  />
      <xsl:param name="schemaPart" />

      <div style="margin-left: 30px;">
         <table style="width:60%;">
            <xsl:for-each select="../*">

               <xsl:variable name="pos" select="position()" />
               <!-- Cabecera de la tabla -->
               <xsl:if test="$pos=1">
                  <tr>
                     <xsl:for-each select="$schemaPart//xs:element[$pos]//xs:element">
                        <th class="cabecera mayusculas" >
                           <xsl:value-of select="xs:annotation/xs:documentation" />
                        </th>
                     </xsl:for-each>
                  </tr>
               </xsl:if>

               <!-- Datos de la tabla -->
               <tr>
                  <xsl:for-each select="./*">
                     <xsl:variable name="nombreElemento" select="name(.)"  />
                     <xsl:variable name="tipoDato" select="$schemaPart//xs:element//xs:element[@name=$nombreElemento]/@type"/>
                     <xsl:choose>
                        <xsl:when test="$tipoDato='Importe'">
                           <td class="celdadatosder">
                              <xsl:value-of select="format-number(., '###.##0,00', 'format1')"/>
                           </td>
                        </xsl:when>
                        <xsl:when test="starts-with($tipoDato,'Texto')">
                           <td class="celdadatosizd">
                              <xsl:value-of select="."/>
                           </td>
                        </xsl:when>
                        <xsl:when test="$tipoDato='Porcentaje'">
                           <td class="celdadatosder">
                              <xsl:value-of select="format-number(., '##,00', 'format1')"/>%
                           </td>
                        </xsl:when>
                        <xsl:otherwise>
                           <td class="celdadatosder">
                              <xsl:value-of select="format-number(., '###.##0', 'format1')"/>
                           </td>
                        </xsl:otherwise>
                     </xsl:choose>
                  </xsl:for-each>
               </tr>

            </xsl:for-each>
         </table>
      </div>
      
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>

