<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='OperNoPpriaTes']//xs:element[@name='EstadoPartPendApli']//xs:element[@name='PagosPendApli']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera" rowspan="2">CUENTA</td>
                  <td class="cabecera" colspan="2">CONCEPTO</td>
                  <td class="cabecera" rowspan="2">
                     <span>
                        PAGOS<br/>
                        PENDIENTES DE<br/>
                        APLICACIÓN A 1<br/>
                        DE ENERO<br/>
                     </span>
                  </td>
                  <td class="cabecera" rowspan="2">
                     MODIFICACIONES<br />
                     SALDO INICIAL
                  </td>
                  <td class="cabecera" rowspan="2">
                     PAGOS<br />
                     REALIZADOS EN<br />
                     EL EJERCICIO
                  </td>
                  <td class="cabecera" rowspan="2">
                     TOTAL PAGOS<br />
                     PENDIENTES<br/>
                     APLICACIÓN
                  </td>
                  <td class="cabecera" rowspan="2">
                     PAGOS APLICADOS<br />
                     EN EL EJERCICIO                     
                  </td>
                  <td class="cabecera" rowspan="2">
                     PAGOS<br />
                     PENDIENTES DE<br />
                     APLICACIÓN A 31<br />
                     DICIEMBRE
                  </td>
               </tr>
               <tr>
                  <td class="cabecera">
                     CÓDIGO
                  </td>
                  <td class="cabecera">
                     DESCRIPCIÓN
                  </td>
               </tr>
               <xsl:variable name="padre" select="//n1:Memoria/n1:OperNoPpriaTes/n1:EstadoPartPendApli/n1:PagosPendApli" />
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="$padre" />
               </xsl:call-template>
               <!-- TOTAL -->
               <tr>
                  <td class="celdadatosder" colspan="3">
                     <span style="font-weight: bold;">TOTAL</span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PagosPendApliA1Ene, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ModifSalIni, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PagosRealizEnEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:TotPagosPendApli, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PagosApliEnEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PagosPendApliA31Dic, '###.##0,00', 'format1')"/></span>
                  </td>
               </tr>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre" />
      <xsl:for-each select="$nodoPadre/*[not(name()='Aplicable')]">
         <!-- Por cada hijo -->
         <xsl:if test="count(./n1:NumCuenta) = 1">
            
            <xsl:variable name="cuenta" select="n1:NumCuenta" />
            <xsl:variable name="totFilas" select="count(./*[name(.)='Concepto'])" />
            
            <xsl:for-each select="./*[name(.)='Concepto']">
               <tr>
                  <xsl:if test="position() = 1">
                     <td class="celdadatosizq" rowspan="{$totFilas}">
                        <span><xsl:value-of select="$cuenta" /></span>
                     </td>
                  </xsl:if>
                  <td class="celdadatosizq">
                     <span><xsl:value-of select="n1:Codigo" /></span>
                  </td>
                  <td class="celdadatosizq">
                     <span><xsl:value-of select="n1:Descripcion" /></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:PagosPendApliA1Ene, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:ModifSalIni, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:PagosRealizEnEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:TotPagosPendApli, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:PagosApliEnEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:PagosPendApliA31Dic, '###.##0,00', 'format1')"/></span>
                  </td>
               </tr>
            </xsl:for-each>
            <tr>
               <!-- TOTAL CUENTA -->
               <td class="celdadatosder" colspan="3">
                  <span style="font-weight: bold;">TOTAL <xsl:value-of select="$cuenta"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:PagosPendApliA1Ene, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:ModifSalIni, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:PagosRealizEnEje, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:TotPagosPendApli, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:PagosApliEnEje, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:PagosPendApliA31Dic, '###.##0,00', 'format1')"/></span>
               </td>
            </tr>
         </xsl:if>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>
