<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cgel-04-s="http://www.igae.pap.meh.es/cgel-04-s" xmlns:str="http://exslt.org/strings" exclude-result-prefixes="str">
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
	<xsl:template match="/">
		<html>
		<head>
			<script language="Javascript" type="text/javascript" src="funciones.js"></script> 
			<link rel="stylesheet" type="text/css" href="estiloHTML.css"></link>
			<title>Modelo Simplificado - Liquidación</title>
		</head>
		<body>
			<table height="50px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#FFD700" border="0">
				<tr>
					<td width="15px"><img height="50px" src="cab_lat01.gif" width="15" alt="izqda" /></td>
					<td><img height="50px" alt="Ministerio de Economía y Hacienda" src="logo_meh.gif" width="129px" /></td>
					<td style="font-size:30px; vertical-align:bottom; font-weight:bold; color:#FFEB80" align="center">Cuenta General XML Modelo Simplificado</td>
					<td><img height="50px" alt="Intervención General de la Administración del Estado" src="logo_igae.gif" width="115px" align="right" /></td>
					<td width="15px"><img height="50px" src="cab_lat02.gif" width="15px" alt="dcha" /></td>
				</tr>
			</table>
			<table cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td><img height="5px" src="null.gif" width="5px" alt="null" /></td>
				</tr>
			</table>
			<table height="20px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#A5BEE7" border="0">
				<tr style="font-size:8pt">
					<td width="15px"><img height="22px" src="b_estado_lat01.gif" width="15px" alt="" /></td>
					<xsl:apply-templates select="//*[@tipo='I']"/>
					<td width="15px"><img height="22px" src="b_estado_lat02.gif" width="15px" /></td>
				</tr>
			</table>
			<table id="Principal" bgcolor="#ffffff" cellspacing="0" style="left:0px; position:relative; top:5px" border="0">
				<tr bgcolor="darkblue">
					<td height="30px" width="230px" nowrap="nowrap">
						<table id="Table1">
						<tr onmousedown="verMenu('LiqPpto')">
							<td class="Menu"><b>Liquidación del Presupuesto</b><img src='tridownAm.gif' id="LiqPptoF" align="absmiddle" /></td>
						</tr>
						<tr>
							<td>
								<div onclick="verMenu('LiqPpto')" id="LiqPpto" width="220px">
									<table cellpadding="4" cellspacing="0" class="tablaMenu">
										<tr>
											<td class="celdaMenu"><a href="#LiqPptoGast" id="celdaLiqPptoGast">Liquidación del presupuesto de gastos</a></td>
										</tr>
										<tr>
											<td class="celdaMenu"><a href="#LiqPptoIng" id="celdaLiqPptoIng">Liquidación del presupuesto de ingresos</a></td>
										</tr>
										<tr>
											<td class="celdaMenu"><a href="#Res" id="celdaRes">Resultado presupuestario</a></td>
										</tr>
									</table>
								</div>
							</td>
						</tr>
						</table>
					</td>			
				</tr>
				<tr bgcolor="#ffffff">
					<td colspan="8" width="900px">
						<br />
						<hr />
						<!-- Listados -->
						<xsl:apply-templates select="//cgel-04-s:LiqPpto/*[@tipo='L']"/>					
					</td>
				</tr>
			</table>
		</body>
		</html>
	</xsl:template>
	
	<!--Plantilla Frame Datos Entidad-->
	<xsl:template name="frame_datos" match="//*[@tipo='I']">
		<xsl:for-each select=".//*[@tipo='D']">
			<xsl:if test="@des='Nombre Entidad'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='Código MAP'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='CIF'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='Ejercicio'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<!-- Plantilla Listados -->
	<xsl:template name="listado" match="//cgel-04-s:LiqPpto/*[@tipo='L']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<h2 style="background-color: darkblue">
			<font color="gold">
				<a>
				<xsl:attribute name="name">
					<xsl:value-of select="local-name()"/>
				</xsl:attribute>
				<xsl:value-of select="@des"/>
				</a>
				<a href='javascript:VolverAlPrincipio()'><img src='ArrowUp.gif' align='absmiddle' alt='Volver al Principio'/></a>
				<!---Esto es el titulo del listado-->
			</font>
		</h2>
		<br />
		<table cellspacing="0" cellpadding="4" width="900px" style="border-collapse:collapse">
			<tbody>
				<tr style="font-size:8pt" align="center">
					<td />
					<td />
					<xsl:for-each select=".//*[@tipo='C' and @des!='']">
						<!---Aqui se crean las cabeceras de las columnas-->
						<th style="border:solid; border-width:1px; border-color:black" bgcolor="LightSteelBlue">
								<xsl:value-of select="translate(@des, $small, $CAPS)"/>
						</th>
					</xsl:for-each>
				</tr>
				<!-- Aplicar plantilla de detalle -->
				<xsl:apply-templates select=".//*[@tipo='D']" />
				<!-- Aplicar plantilla de totales -->
				<xsl:call-template name="totales" />
			</tbody>
		</table>
		<br />
		<br />
	</xsl:template>
	
<!-- Plantilla Detalles listados -->
	<xsl:template name="detalle" match="//*[@tipo='D']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<tr style="font-size:8pt">
			<td />
			<xsl:choose>
				<xsl:when test="@des!=''">
					<td style="border:solid; border-width:1; border-color:black">
					<!---Columnas con descripcion que no son cabeceras ni datos-->
						<strong>
							<xsl:value-of select="@des"/>
						</strong>
					</td>
				</xsl:when>
				<xsl:otherwise>
				<td width="0px"></td>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select=".//*[@tipo='C']">
				<!---Aqui se crean las columnas con datos-->
				<xsl:choose>
					<xsl:when test=".=0">
						<td style="border:solid; border-width:1;border-color:black" align="right">0,00</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')='NaN' or (format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')='')">
						<td style="border:solid; border-width:1;border-color:black" align="left">
							<xsl:value-of select="concat(substring(translate(., $small, $CAPS),1,1),substring(translate(., $CAPS, $small),2))"/>
						</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')!=''">
						<td style="border:solid; border-width:1;border-color:black" align="right">
							<xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
						</td>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>

	<!-- Plantilla totales -->
	<xsl:template name="totales">

		<xsl:for-each select=".//*[@tipo='D' and position()=1]">
			<xsl:choose>

				<!--Liquidacion del Presupuesto de Gastos-->
				<xsl:when test="local-name()='LiqPptoGastApp'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border:solid; border-width:1px; border-color:black" colspan="6" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:CredIni), '###.##0,00', 'european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:ModCred), '###.##0,00', 'european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:CredDef), '###.##0,00', 'european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:GastCompr), '###.##0,00', 'european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:Oblig), '###.##0,00', 'european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:Pag),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:ObligPendPag),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:RemCred),'###.##0,00','european')"/>
							</strong>
						</td>
					</tr>
				</xsl:when>
				<!--Liquidacion del Presupuesto de Ingresos-->
				<xsl:when test="local-name()='LiqPptoIngApp'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border:solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:PrevIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:ModPrev),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:PrevDef),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:DerRec),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:DerAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:DerCanc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:DerRecNet),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:Ing),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:DerPendCobr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-s:GradoRealizacion),'###.##0,00','european')"/>
							</strong>
						</td>
					</tr>
				</xsl:when>
			
			</xsl:choose>
		</xsl:for-each>

	</xsl:template>
</xsl:stylesheet>
