<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cgel-04-s-2008="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-04-s-2008_2008-12-31" xmlns:str="http://exslt.org/strings" exclude-result-prefixes="str">
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
<xsl:template match="/">
		<html>
			<head>
				<script language="Javascript" type="text/javascript" src="funciones.js"></script> 
				<link rel="stylesheet" type="text/css" href="estiloHTML.css"></link>
				<title>Modelo Simplificado - Balance</title>
			</head>
		<body>
			<table height="50px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#FFD700" border="0">
				<tr>
					<td width="15px"><img height="50px" src="cab_lat01.gif" width="15" alt="izqda" /></td>
					<td><img height="50px" alt="Ministerio de Economía y Hacienda" src="logo_meh.gif" width="129px" /></td>
					<td style="font-size:30px; vertical-align:bottom; font-weight:bold; color:#FFEB80" align="center">Cuenta General XML Modelo Simplificado</td>
					<td><img height="50px" alt="Intervención General de la Administración del Estado" src="logo_igae.gif" width="115px" align="right" /></td>
					<td width="15px"><img height="50px" src="cab_lat02.gif" width="15px" alt="dcha" /></td>
				</tr>
			</table>
			<table cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td><img height="5px" src="null.gif" width="5px" alt="null" /></td>
				</tr>
			</table>
			<table height="20px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#A5BEE7" border="0">
				<tr style="font-size:8pt">
					<td width="15px"><img height="22px" src="b_estado_lat01.gif" width="15px" /></td>
					<xsl:apply-templates select="//*[@tipo='I']"/>
					<td width="15px"><img height="22px" src="b_estado_lat02.gif" width="15px" /></td>
				</tr>
			</table>
			<table id="Principal" bgcolor="#ffffff" cellspacing="0" style="left:0px; position:relative; top:5px" border="0">
				<tr bgcolor="darkblue">
					<td height="30" width="70px">
						<table id="Table1">
							<tr onmousedown="verMenu('Bal')">
								<td class="Menu"><b>Balance</b><img src='tridownAm.gif' id="BalF" align="absmiddle" alt="" /></td>
							</tr>
							<tr>
								<td>
									<div onclick="verMenu('Bal')" id="Bal">
										<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="100px">
											<tr>
												<td class="celdaMenu"><a href="#BalAct"  id="celdaBalAct">Activo</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#BalPas" id="celdaBalPas">Pasivo</a></td>
											</tr>
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>					
				</tr>
				<tr bgcolor="#ffffff">
					<td colspan="8" width="900px">
						<br />
						<hr />
						<!-- Listados -->
						<xsl:apply-templates select="//cgel-04-s-2008:Bal/*[@tipo='L']"/>
					</td>
				</tr>
			</table>
		</body>
	</html>
	</xsl:template>
	
		<!--Plantilla Frame Datos Entidad-->
	<xsl:template name="frame_datos" match="//*[@tipo='I']">
		<xsl:for-each select=".//*[@tipo='D']">
			<xsl:if test="@des='Nombre Entidad'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='Código MAP'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='CIF'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='Ejercicio'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<!-- Plantilla Listados -->
	<xsl:template name="listado" match="//cgel-04-s-2008:Bal/*[@tipo='L']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<h2 style="background-color:darkblue">
			<font color="gold">
				<a>
				<xsl:attribute name="name">
					<xsl:value-of select="local-name()"/>
				</xsl:attribute>
				<xsl:value-of select="@des"/>
				</a>
				<a href='javascript:VolverAlPrincipio()'><img src='ArrowUp.gif' align='absmiddle' alt='Volver al Principio' /></a>
				<!---Esto es el titulo del listado-->
			</font>
		</h2>
		<br />
		<table cellspacing="0" cellpadding="4" width="900px" style="border-collapse:collapse">
			<tbody>
					<tr style="font-size:8pt" align="center">
						<td />
						<td />
						<xsl:for-each select=".//*[@tipo='C' and @des!='']">
							<!---Aqui se crean las cabeceras de las columnas-->
							<td style="border: solid; border-width:1; border-color:black" bgcolor="LightSteelBlue">
								<strong>
									<xsl:value-of select="translate(@des, $small, $CAPS)"/>
								</strong>
							</td>
						</xsl:for-each>
					</tr>
					<xsl:apply-templates select=".//*[@tipo='D']"/>
					<xsl:call-template name="totales"/>
			</tbody>
		</table>
		<br />
		<br />
	</xsl:template>
	
	<!-- Plantilla Detalles listados -->
	<xsl:template name="detalle" match="//*[@tipo='D']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<tr style="font-size:8pt">
			<td/>
			<xsl:choose>
				<xsl:when test="@des!=''">
					<td style="border: solid; border-width:1; border-color:black">
					<!---Columnas con descripcion que no son cabeceras ni datos-->
						<strong>
							<xsl:value-of select="@des"/>
						</strong>
					</td>
				</xsl:when>
				<xsl:otherwise>
				<td width="0px"></td>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select=".//*[@tipo='C']">
				<!---Aqui se crean las columnas con datos-->
<xsl:choose>
				<!-- Tipo de Bien (Modelo Simplificado)  -->
					<xsl:when test="local-name()='TipoBien' and .='TERR'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Terrenos y bienes naturales</td>					
					</xsl:when>				
					<xsl:when test="local-name()='TipoBien' and .='CONS'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Construcciones</td>					
					</xsl:when>	
					<xsl:when test="local-name()='TipoBien' and .='INST'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Instalaciones técnicas</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='MAQYUTI'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Maquinaria y utillaje</td>					
					</xsl:when>														
					<xsl:when test="local-name()='TipoBien' and .='MOB'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Mobiliario</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='EQUINF'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Equipos para procesos de información</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='TRANS'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Elementos de transporte</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='INMV'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Otro inmovilizado material</td>					
					</xsl:when>
					<!-- Otro tipos de bienes definidos para Patrimonio Entregado al Uso General -->
					<xsl:when test="local-name()='TipoBien' and .='INFR'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Infraestructuras y bienes destinados al uso general</td>					
					</xsl:when>
					<xsl:when test="local-name()='TipoBien' and .='BIEN'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Bienes comunales</td>					
					</xsl:when>
					<xsl:when test="local-name()='TipoBien' and .='PATR'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Bienes del Patrimonio histório, artístico y cultural</td>					
					</xsl:when>
				<!-- Tipos de deuda -->
					<xsl:when test="local-name()='TipDeud' and .='EMPR'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Empréstitos y otras emisiones análogas</td>					
					</xsl:when>		
					<xsl:when test="local-name()='TipDeud' and .='EMPRTES'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Empréstitos y otras emisiones análogas por operaciones de tesorería</td>					
					</xsl:when>	
					<xsl:when test="local-name()='TipDeud' and .='DEUD'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Deudas con entidades de crédito</td>					
					</xsl:when>							
					<xsl:when test="local-name()='TipDeud' and .='DEUDTES'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Deudas con entidades de crédito por Operaciones de Tesorería</td>					
					</xsl:when>							
					<xsl:when test="local-name()='TipDeud' and .='DEUDPUB'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Deudas con Entidades Públicas</td>					
					</xsl:when>		
					<xsl:when test="local-name()='TipDeud' and .='OTRDEUD'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Otras Deudas</td>					
					</xsl:when>
				<!-- Valor 0 => Poner decimales -->
					<xsl:when test=".=0">
						<td style="border:solid; border-width:1px;border-color:black" align="right">0,00</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')='NaN' or (format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')='')">
						<td style="border:solid; border-width:1px;border-color:black" align="left">
							<xsl:value-of select="concat(substring(translate(., $small, $CAPS),1,1),substring(translate(., $CAPS, $small),2))"/>
						</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')!=''">
						<td style="border:solid; border-width:1px;border-color:black" align="right">
							<xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
						</td>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>
	
	<!-- Plantilla totales -->
	<xsl:template name="totales">
		<xsl:for-each select=".//*[@tipo='T']">
		<tr style="font-size:8pt" align="right">
		<td/>
			<xsl:choose>
				<!--Balance Activo-->
					<xsl:when test="local-name()='TotBalAct'">
						<td style="border:solid; border-width:1px; border-color:black" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ActEjAct,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ActEjAnt,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Balance Pasivo-->
					<xsl:when test="local-name()='TotBalPas'">
						<td style="border:solid; border-width:1px; border-color:black" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PasEjAct,'###.##0,00','european')"/>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PasEjAnt,'###.##0,00','european')"/>
						</td>
					</xsl:when>
			</xsl:choose>
			</tr>
		</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
