<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-norm_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2015.xsd')" />
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>

   <xsl:variable name="principalSchema" select="$schema//xs:element[@name='AspDerTransNueNormCont']" />

   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$principalSchema" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />
            
            <!-- titulo principal de la página -->
            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>

            <!-- Recorremos todos los hijos del nodo padre. -->
            <xsl:for-each select="//n1:AspDerTransNueNormCont/*[position()>1]"> <!-- El primer elemento es "Aplicable" -->

               <!-- nombre del nodo hijo actual -->
               <xsl:variable name="nombre" select="name(.)" />

               <!-- llamamos a la plantilla para que gestione -->
               <xsl:call-template name="campo">

                  <!-- pasamos los parámetros -->
                  <xsl:with-param name="nombreNodo" select="$nombre" />
                  <xsl:with-param name="nodoPadre" select="//n1:AspDerTransNueNormCont/Informes" />
                  <xsl:with-param name="schemaHijo" select="$principalSchema//xs:element[@name=$nombre]" />

               </xsl:call-template>

            </xsl:for-each>

         </body>
      </html>
   </xsl:template>

   <xsl:template name="campo">

      <!-- Parámetros -->
      <xsl:param name="nombreNodo" />
      <xsl:param name="schemaHijo" />
      <xsl:param name="tab" />

      <!-- nombre del nodo actual -->
      <xsl:variable name="nombre" select="name(.)" />

      <xsl:choose>
         <xsl:when test="count(child::*) &gt; 0">

            <h6>
               <xsl:value-of select="$tab" />
               <xsl:value-of select="$schemaHijo/xs:annotation/xs:documentation" />
            </h6>

            <xsl:for-each select="*">

               <xsl:variable name="nombreHijo" select="name(.)" />

               <!-- llamamos a la plantilla para que gestione -->
               <xsl:call-template name="campo">

                  <!-- pasamos los parámetros -->
                  <xsl:with-param name="nombreNodo" select="$nombre" />
                  <xsl:with-param name="schemaHijo" select="$schemaHijo//xs:element[@name=$nombreHijo]" />
                  <xsl:with-param name="tab" select="'&#160;&#160;&#160;'" />

               </xsl:call-template>

            </xsl:for-each>

         </xsl:when>
         <xsl:otherwise>
            <!-- ponemos los datos de la tabla -->
            <xsl:call-template name="datos">

               <xsl:with-param name="nombreNodo" select="$nombre" />
               <xsl:with-param name="schemaPart" select="$schemaHijo" />
               <xsl:with-param name="tab" select="$tab" />

            </xsl:call-template>
         </xsl:otherwise>
      </xsl:choose>

   </xsl:template>

   <xsl:template name="datos">

      <!-- parámetros -->
      <xsl:param name="nombreNodo"  />
      <xsl:param name="schemaPart" />
      <xsl:param name="tab" />

      <h6>
         <xsl:value-of select="$tab" />
         <xsl:value-of select="$schemaPart/xs:annotation/xs:documentation" />
      </h6>
      <div style="margin-left: 30px; margin-bottom: 10px;">
         <table>
            <tr>
               <td class="cabecera" style="width: 150px;">
                  Documento:
               </td>
               <td class="celdadatosizq" style="width: 300px;">
                  <xsl:value-of select="."/>
               </td>
            </tr>
         </table>
      </div>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
