﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-simp_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2015.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='PasFin']//xs:element[@name='InfAvales']//xs:element[@name='AvalesReintegrados']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera" rowspan="2">
                     <span>AÑO DE EJECUCIÓN</span>
                  </td>
                  <td class="cabecera" rowspan="2">
                     IMPORTE<br />
                     REINTEGRADO<br />
                     EN EL EJERCICIO
                  </td>
                  <td class="cabecera" colspan="2">APLICACIÓN PRESUPUESTARIA</td>
				  <td class="cabecera" colspan="2">CONCEPTO NO PRESUPUESTARIO</td>
               </tr>
               <tr>
                  <td class="cabecera">CÓDIGO</td>
                  <td class="cabecera">DESCRIPCIÓN</td>
                  <td class="cabecera">CÓDIGO</td>
                  <td class="cabecera">DESCRIPCIÓN</td>				  
               </tr>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesReintegrados" />
               </xsl:call-template>
               <tr>
                  <td class="cabecera" style="text-align: right;">
                     <span>TOTAL</span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:PasFin/n1:InfAvales/n1:AvalesReintegrados/n1:TotalImpReintEnEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatoscentro" colspan="4">&#160;</td>
               </tr>               
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="subTotal"></xsl:param>
      <xsl:for-each select="$nodoPadre/*[not(name()='Aplicable')]">
         <!-- Por cada hijo -->
         <xsl:if test="count(./n1:AnioEjec) = 1">
            <tr>
               <td class="celdadatoscentro">
                  <span><xsl:value-of select="n1:AnioEjec" /></span>
               </td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ImpReintEnEje, '###.##0,00', 'format1')"/></td>
               <xsl:choose>
                  <xsl:when test="n1:ApliPpria">
                     <td  class="celdadatosizq">
                        <span>
                           <xsl:value-of select="n1:ApliPpria/n1:CodOrg" />.<xsl:value-of select="n1:ApliPpria/n1:CodEcoI" />
                        </span>
                     </td>
                     <td  class="celdadatosizq">
                        <span>
                           <xsl:value-of select="n1:ApliPpria/n1:DesOrg" />
                           <br/>
                           <xsl:value-of select="n1:ApliPpria/n1:DesEcoI" />
                        </span>
                     </td>
                     <td colspan="2">&#160;</td>				 
                  </xsl:when>
                  <xsl:otherwise>
                     <td colspan="2">&#160;</td>
				     <td class="celdadatosizq">
                        <span >
                           <xsl:value-of select="n1:ConcepNoPresup/n1:Concepto"/>
                        </span>
                     </td>
                     <td  class="celdadatosizq">
                        <span >
                           <xsl:value-of select="n1:ConcepNoPresup/n1:DesConcepto"/>
                        </span>
                     </td>
                  </xsl:otherwise>
               </xsl:choose>
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
</xsl:stylesheet>
