﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/BASICAL_Cuenta-Simp-2019"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2019.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='OperAdmRecurCtaOtrEntPub']//xs:element[@name='DesarrolloGestion']//xs:element[@name='DevolIngresos']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />
      
      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>
            
            <table style="width: 100%">
               <tr>
                  <td class="cabecera" colspan="2">CONCEPTO</td>
                  <td class="cabecera" rowspan="2"><span>PENDIENTES<br/>DE  PAGO A 1<br/>DE ENERO</span></td>
                  <td class="cabecera" rowspan="2"><span>MODIFICACIONES<br/>SALDO INICIAL Y<br/>ANULACIONES</span></td>
                  <td class="cabecera" rowspan="2"><span>RECONOCIDAS<br/>EN EL<br/>EJERCICIO</span></td>
                  <td class="cabecera" rowspan="2"><span>TOTAL<br/>DEVOLUCIONES<br/>RECONOCIDAS</span></td>
                  <td class="cabecera" rowspan="2"><span>PRESCRIPCIONES</span></td>
                  <td class="cabecera" rowspan="2"><span>PAGADAS EN EL<br/>EJERCICIO</span></td>
                  <td class="cabecera" rowspan="2"><span>PENDIENTES<br/>DE PAGO A 31<br/>DE DICIEMBRE</span></td>
               </tr>
               <tr>
                  <td class="cabecera"><span>CODIGO</span></td>
                  <td class="cabecera"><span>DESCRIPCIÓN</span></td>
               </tr>
               <xsl:variable name="padre" select="//n1:Memoria/n1:OperAdmRecurCtaOtrEntPub/n1:DesarrolloGestion/n1:DevolIngresos" />
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="$padre" />
               </xsl:call-template>
               <!-- TOTAL -->
               <tr>
                  <td class="celdadatosder" colspan="2">
                     <span style="font-weight: bold;">TOTAL</span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PendPagoA1Ene, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ModifSalIniYAnul, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ReconEnEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:TotDevolRecon, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:Prescripciones, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PagEnEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PendPagoA31Dic, '###.##0,00', 'format1')"/></span>
                  </td>                  
               </tr>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <!-- Por cada hijo -->
         <xsl:if test="count(./n1:Id) = 1">
            <tr>
               <td class="celdadatosizq">
                  <span><xsl:value-of select="n1:Id" /></span>
               </td>
               <td class="celdadatosizq">
                  <span><xsl:value-of select="n1:Descripcion" /></span>
               </td>        
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:PendPagoA1Ene, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:ModifSalIniYAnul, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:ReconEnEje, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:TotDevolRecon, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Prescripciones, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:PagEnEje, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:PendPagoA31Dic, '###.##0,00', 'format1')"/></span>
               </td>               
            </tr>
         </xsl:if>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>
