<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">
   
   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   
   <xsl:template match="/">
       <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='EntDependientes']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />
      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />
			
			 <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="1" />
            </xsl:call-template>
            <xsl:variable name="TipoEntidad" select="//n1:Entidad/n1:TipoEntidad" />
            <h2>1.1 Entidad dominante</h2> 
            <table border="1" cellpadding="4px" cellspacing="0px">			   
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>Nombre Entidad</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:NomEnt" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>NIF</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:NIF" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>Tipo de Entidad</span></td>
                  <td><xsl:value-of select="$schema//xs:simpleType[@name='TipoEntidad']/xs:restriction/xs:enumeration[@value=$TipoEntidad ]//xs:documentation" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>Ejercicio</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:Ejercicio" /></td>
               </tr>
               <!-- <tr>
                  <td class="cabecera" style="text-align:left;"><span>Entidad de la que depende</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:NomEntDep" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>NIF de la entidad de la que depende</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:NIFDep" /></td>
               </tr> -->

            </table>
         </body>
      </html>
   </xsl:template>
	<xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>
      
   </xsl:template>
</xsl:stylesheet>
