<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='ActConstOAdqOtrEntYOtrExistencias']" />
      <xsl:variable name="nodoActual" select="//n1:Memoria/n1:ActConstOAdqOtrEntYOtrExistencias" />
      <xsl:variable name="tituloPag" select="$nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:variable name="ejercicio" select="//n1:Entidad/n1:Ejercicio" />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera" rowspan="2">PARTIDA BALANCE</td>
                  <td class="cabecera" rowspan="2">IMPORTE DE LAS <br/>CORRECCIONES<br/>VALORATIVAS</td>
                  <td class="cabecera" rowspan="2">IMPORTE<br/>REVERSIÓN</td>
                  <td class="cabecera" rowspan="2">IMPORTE COSTES<br/>CAPITALIZADOS</td>
                  <td class="cabecera" colspan="4">LIMITACIÓN DISPONIBILIDAD OBRAS Y OTRAS EXISTENCIAS</td>
               </tr>
               <tr>
                  <td class="cabecera">GARANTÍAS</td>
                  <td class="cabecera">PIGNORACIONES</td>
                  <td class="cabecera">FIANZAS</td>
                  <td class="cabecera">OTROS</td>                  
               </tr>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="$nodoActual" />
               </xsl:call-template>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/n1:Partida">
         <!-- Por cada hijo -->
         <tr>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:PartBal" /></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ImpCorrValorativas, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ImpReversion, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ImpCostesCapitalizados, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:LimitDispObrasYOtrExistencias/n1:Garantias, '###.##0,00', 'format1')"/></span>			
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:LimitDispObrasYOtrExistencias/n1:Pignoraciones, '###.##0,00', 'format1')"/></span>			
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:LimitDispObrasYOtrExistencias/n1:Fianzas, '###.##0,00', 'format1')"/></span>			
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:LimitDispObrasYOtrExistencias/n1:Otros, '###.##0,00', 'format1')"/></span>			
            </td>
         </tr>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>   

</xsl:stylesheet>
