<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='LiqPpto']//xs:element[@name='LiqPptoGastE']" />
      <!-- <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" /> -->

      <xsl:variable name="tituloPag" select="$schema//xs:element[@name='Memoria']//xs:element[@name='AjustYElim']//xs:documentation" />
      <xsl:variable name="tituloPag2" select="$schema//xs:element[@name='Memoria']//xs:element[@name='AjustYElim']//xs:element[@name='AjustYElimReconEntGrp']//xs:documentation" />
      <xsl:variable name="tituloPag3" select="$schema//xs:element[@name='Memoria']//xs:element[@name='AjustYElim']//xs:element[@name='AjustYElimReconEntGrp']//xs:element[@name='AjustElimLiqPpto']//xs:documentation" />
       <xsl:variable name="tituloPag4" select="$schema//xs:element[@name='Memoria']//xs:element[@name='AjustYElim']//xs:element[@name='AjustYElimReconEntGrp']//xs:element[@name='AjustElimLiqPpto']//xs:element[@name='AjustLiqPptoGastE']//xs:documentation" />
      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

           <h1>
               <xsl:value-of select="$tituloPag" />
            </h1>            
            <h2>
               <xsl:value-of select="$tituloPag2" />              
            </h2>
             <h2>
               <xsl:value-of select="$tituloPag3" />              
            </h2>
             <h3>
               <xsl:value-of select="$tituloPag4" />              
            </h3>
            
            <table border="1" cellspacing="0" cellpadding="4" style="width:75%;">
               <tbody>
                  <tr>
                     <td colspan="2"   style="width: 30%;" class="cabecera">
                        CAPÍTULOS
    				      </td>
                     <td rowspan="2"  style="width: 15%;" class="cabecera">
                        OBLIGACIONES <br/> RECONOCIDAS <br/> NETAS AGREGADAS
                     </td>
                     <td colspan="2"  style="width: 20%;" class="cabecera">
                        AJUSTES POR <br/> ELIMINACIONES
                     </td>
                     <td  class="cabecera"  style="width: 15%;" rowspan="2">
                        OBLIGACIONES <br/> RECONOCIDAS <br/> NETAS CONSOLIDADAS
                     </td>                     
                  </tr>
                  <tr>
                     <td class="cabecera"> CÓDIGO</td>
                     <td class="cabecera"  style="width: 42%;">DESCRIPCIÓN</td>
                     <td class="cabecera">EN <br/>AUMENTO</td>
                     <td class="cabecera">EN<br/>DISMINUCIÓN</td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:LiqPpto/n1:LiqPptoGastE" />
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
            <!-- Por cada hijo -->
            <tr>
               <xsl:choose>
                  <xsl:when test="name(.) = 'TotLiqPptoGastClasifEcon'">
                     <td class="celdadatosder" colspan="2">
                        <span style="font-weight: bold;">
                           TOTAL
                        </span>
                     </td>                  
                  </xsl:when>
                  <xsl:when  test="name(.)='ClasifEcon'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:ApliPpria/n1:CodEcoG"/>
                        </span>
                     </td>
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:ApliPpria/n1:DesEcoG" />
                        </span>
                     </td>
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ObligAgregadas, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:AjustAumento, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:AjustDismin, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:Oblig, '###.##0,00', 'format1')"/></td>
            </tr>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
