﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfPresupuestaria']//xs:element[@name='EjerciciosCerrados']//xs:element[@name='ObliPptoCerrado']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="5" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera"><span>AÑO<br/>PRESUPUESTO</span></td>
                  <td class="cabecera"><span>APLICACIÓN<br/>PRESUPUESTARIA</span></td>
                  <td class="cabecera"><span>DESCRIPCIÓN</span></td>
                  <td class="cabecera"><span>OBLIGACIONES<br/>PENDIENTES DE<br/>PAGO A 1 DE<br/>ENERO</span></td>
                  <td class="cabecera"><span>MODIFICACIONES<br/>SALDO INICIAL Y<br/>ANULACIONES</span></td>
                  <td class="cabecera"><span>TOTAL<br/>OBLIGACIONES</span></td>
                  <td class="cabecera"><span>PRESCRIPCIONES</span></td>
                  <td class="cabecera"><span>PAGOS<br/>REALIZADOS</span></td>
                  <td class="cabecera"><span>OBLIGACIONES<br/>PENDIENTES DE PAGO<br/>A 31 DE DICIEMBRE</span></td>               
               </tr>
               <xsl:variable name="padre" select="//n1:Memoria/n1:InfPresupuestaria/n1:EjerciciosCerrados/n1:PptoGastos/n1:ObliPptoCerrado" />
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="$padre" />
               </xsl:call-template>
               <!-- TOTAL -->
               <tr>
                  <td class="celdadatosder" colspan="3">
                     <span style="font-weight: bold;">TOTAL</span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ObliPendPagoA1Ene, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ModifSaldoIniYAnul, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:TotObligaciones, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:Prescripciones, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PagosRealizados, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ObliPendPagoA31Dic, '###.##0,00', 'format1')"/></span>
                  </td>                   
               </tr>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*[not(name()='Aplicable')]">
         <xsl:variable name="anio" select="n1:Valor" />
         <xsl:variable name="countApli" select="count(./n1:ApliPpria)" />
         <!-- Por cada aplicación Ppria-->
         <xsl:for-each select="./n1:ApliPpria">
            <tr>
               <xsl:if test="position()=1">
                  <td rowspan="{$countApli}" class="celdadatoscentro">
                     <xsl:value-of select="$anio" />
                  </td>
               </xsl:if>
               <td class="celdadatosizq">
                  <span style="font-weight: bold;">
                     <xsl:value-of select="n1:Datos/n1:CodOrg" />.<xsl:value-of select="n1:Datos/n1:CodProg" />.<xsl:value-of select="n1:Datos/n1:CodEcoG" />
                  </span>
               </td>
               <td class="celdadatosizq">
                  <span>
                     <xsl:value-of select="n1:Datos/n1:DesOrg" />
                     <br/>
                     <xsl:value-of select="n1:Datos/n1:DesProg" />
                     <br/>
                     <xsl:value-of select="n1:Datos/n1:DesEcoG" />
                  </span>
               </td>
               <td class="celdadatosder">
                  <span>
                     <xsl:value-of select="format-number(n1:ObliPendPagoA1Ene, '###.##0,00', 'format1')"/>
                  </span>
               </td>
               <td class="celdadatosder">
                  <span>
                     <xsl:value-of select="format-number(n1:ModifSaldoIniYAnul, '###.##0,00', 'format1')"/>
                  </span>
               </td>
               <td class="celdadatosder">
                  <span>
                     <xsl:value-of select="format-number(n1:TotObligaciones, '###.##0,00', 'format1')"/>
                  </span>
               </td>
               <td class="celdadatosder">
                  <span>
                     <xsl:value-of select="format-number(n1:Prescripciones, '###.##0,00', 'format1')"/>
                  </span>
               </td>
               <td class="celdadatosder">
                  <span>
                     <xsl:value-of select="format-number(n1:PagosRealizados, '###.##0,00', 'format1')"/>
                  </span>
               </td>
               <td class="celdadatosder">
                  <span>
                     <xsl:value-of select="format-number(n1:ObliPendPagoA31Dic, '###.##0,00', 'format1')"/>
                  </span>
               </td>
            </tr>
         </xsl:for-each>
      </xsl:for-each>
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>   

</xsl:stylesheet>
