<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">
      <xsl:variable name="nodoEnumTipoEnte" select="$schema//xs:simpleType[@name='TipoEnte']//xs:restriction" />
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfPresupConso']//xs:element[@name='LiqEstPrevGastIngEntSinPresupLimit']" />
      <xsl:variable name="nodoActual" select="//n1:Memoria/n1:InfPresupConso/n1:LiqEstPrevGastIngEntSinPresupLimit" />
      <xsl:variable name="tituloPag" select="$nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:variable name="ejercicio" select="//n1:Entidad/n1:Ejercicio" />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>

            <table style="width: 70%">
               <tr>
                  <td class="cabecera" rowspan="1">TIPO ENTE</td>
                  <td class="cabecera" rowspan="1">NOMBRE ENTIDAD</td>
                  <td class="cabecera" rowspan="1">EJERCICIO</td>
                  <td class="cabecera" rowspan="1">IMPORTE<br/>PRESUPUESTADO</td>
                  <td class="cabecera" rowspan="1">IMPORTE <br/>REALIZADO</td>
                  <td class="cabecera" rowspan="1">DESVIACIÓN <br/>IMPORTE</td>
               </tr>
               
               <xsl:call-template name="filas">
               <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
               <xsl:with-param name="nodoPadre" select="$nodoActual" />
               </xsl:call-template>
										
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" />
         <!-- Por cada hijo -->
         <tr>
            <td class="celdadatosizq">
               <span><xsl:value-of select="$nodoEnumTipoEnte/xs:enumeration[@value=$TipoEnte]//xs:documentation"/></span>
            </td>
             <td class="celdadatosizq">
               <span><xsl:value-of select="n1:NomEntidad" /></span>
            </td>
             <td class="celdadatosder">
               <span><xsl:value-of select="n1:Ejercicio" /></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ImpPpto, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ImpRealizado, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:DesviacionImp, '###.##0,00', 'format1')"/></span>
            </td>
         </tr>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>   

</xsl:stylesheet>
