<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='ModifPorcentPartEnt']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>
            
            <table border="1" cellspacing="0" cellpadding="4" style="width:70%;">
               <tbody>
                  <tr>
                     <td colspan="4" class="cabecera">RESUMEN DE LAS VARIACIONES DE LA PARTICIPACIÓN</td>
                  </tr>
                  <tr>
                     <td colspan="2" class="cabecera">ENTIDADES PARTICIPADAS</td>
                     <td colspan="5" class="cabecera">PORCENTAJE DE LA PARTICIPACIÓN EN ENTIDADES DEL GRUPO (%)</td>
                   
                  </tr>
                  <tr>
                     <td rowspan="2" class="cabecera">NIF</td>
                     <td rowspan="2" class="cabecera">NOMBRE DE LA ENTIDAD</td>
                     <td rowspan="2" class="cabecera">INICIAL<br/>(1)</td>
                     <td colspan="3" class="cabecera">VARIACIONES DE LA PARTICIPACIÓN</td>
                     <td rowspan="2" class="cabecera">FINAL<br/>(5)=(1)+(4)</td>        
                  </tr> 
                  <tr>
                     <td class="cabecera">DIRECTA<br/>(2)</td>
                     <td class="cabecera">INDIRECTA<br/>(3)</td>
                     <td class="cabecera">TOTAL<br/>(4)=(2)+(3)</td>
                  </tr> 
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependIntegradas" />
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>
  <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">          
            <!-- <tr> -->
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependI'">
                     <xsl:if test="n1:IndExtVarPartEnt = '1' ">

                     <tr>
                        <td class="celdadatosizq"><span style="font-weight: bold;"><xsl:value-of select="n1:NIF" /></span></td>
                        <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
                        <td class="celdadatosder"><xsl:value-of select="format-number((n1:VarPartDirEntDom/n1:PorcPartIniDir + n1:TotPartIndir/n1:PorcPartIniIndir), '###.##0,00', 'format1')"/></td>
                        <td class="celdadatosder"><xsl:value-of select="format-number(n1:VarPartDirEntDom/n1:VarPorcPartIniDir, '###.##0,00', 'format1')"/></td>
                        <td class="celdadatosder"><xsl:value-of select="format-number(n1:TotPartIndir/n1:VarPorcPartIniIndir, '###.##0,00', 'format1')"/></td>
                        <td class="celdadatosder"><xsl:value-of select="format-number((n1:VarPartDirEntDom/n1:VarPorcPartIniDir + n1:TotPartIndir/n1:VarPorcPartIniIndir), '###.##0,00', 'format1')"/></td>
                        <td class="celdadatosder"><xsl:value-of select="format-number((n1:VarPartDirEntDom/n1:PorcPartIniDir + n1:TotPartIndir/n1:PorcPartIniIndir)+ (n1:VarPartDirEntDom/n1:VarPorcPartIniDir + n1:TotPartIndir/n1:VarPorcPartIniIndir), '###.##0,00', 'format1')"/></td>
                        </tr>
                   </xsl:if>
                  </xsl:when>
               </xsl:choose>
              
            <!-- </tr> -->
      </xsl:for-each>

   </xsl:template> 

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
