<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">

  <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='EntDependientesMA']//xs:element[@name='MultigIntegradas']" />
      <xsl:variable name="nodoEnumTipoEnte" select="$schema//xs:simpleType[@name='TipoEnte']//xs:restriction" />
      <xsl:variable name="nodoEnumMetConsoIdent" select="$schema//xs:simpleType[@name='MetConsoIdent']//xs:restriction" />
      <xsl:variable name="nodoEnumOpInfAudit" select="$schema//xs:simpleType[@name='OpInfAudit']//xs:restriction" />
      <xsl:variable name="nodoEnumSitCuentInteg" select="$schema//xs:simpleType[@name='SitCuentInteg']//xs:restriction" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />


      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>
            <xsl:with-param name="nodoEnumMetConsoIdent" select="$nodoEnumMetConsoIdent"></xsl:with-param>
            <xsl:variable name="MetConsoIdent" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigIntegradas/n1:MetConsoIdent" />
            
            <h3>Método de consolidación aplicado a las entidades multigrupo</h3>
            <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
               <tbody>
                  <tr>
                     <td colspan="2" class="cabecera">MÉTODO DE CONSOLIDACIÓN APLICADO - ENTIDADES MULTIGRUPO</td>
                  </tr>
                  <tr>
                     <td class="cabecera" style="text-align:left; width:50%;"><span>Identificación del método de consolidación</span></td>
                    <td ><xsl:value-of select="$nodoEnumMetConsoIdent/xs:enumeration[@value=$MetConsoIdent]//xs:documentation"/></td>
                  </tr>
                  <tr>
                     <td class="cabecera" style="text-align:left;"><span>Justificación del uso del método de consolidación</span></td>
                     <td ><xsl:value-of select="//n1:Memoria/n1:EntDependientesMA/n1:MultigIntegradas/n1:MetConsoJustif"/></td>
                  </tr>       
                </tbody>
            </table> 
            <br/><br/>
            <h3>Identificación de las entidades multigrupo integradas</h3>
            <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
               <tbody>
                   <tr>
                     <td colspan="2" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO INTEGRADAS</td>
                  </tr>
                  <tr>
                     <td class="cabecera" style="width:10%;">NIF</td>
                     <td  class="cabecera" style="width:20%;">NOMBRE ENTIDAD</td>                    
                     <td class="cabecera" style="width:20%;" >TIPO ENTE</td>                    
                  </tr>
                  
                  <xsl:call-template name="filas1">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigIntegradas" />
                     <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>                    
                  </xsl:call-template>
                </tbody>
            </table> 
            <br/><br/>
             <h3>Porcentaje de participación en las entidades multigrupo integradas</h3>
            <table border="1" cellspacing="0" cellpadding="4" style="width:70%;">
               <tbody>
                <tr>
                     <td colspan="3" style="width:38%;" class="cabecera">PORCENTAJE DE PARTICIPACIÓN EN LAS ENTIDADES MULTIGRUPO INTEGRADAS</td>
                  </tr>
                  <tr>
                     <td rowspan="3" class="cabecera">NIF</td>
                     <td rowspan="3" style="width:15%;" class="cabecera">NOMBRE ENTIDAD</td>
                     <td rowspan="3" class="cabecera">PARTICIPACIÓN <br/>DIRECTA<br/>(%)</td>
                     <td class="cabecera" colspan="3">PARTICIPACIÓN INDIRECTA</td>
                     <td rowspan="3" class="cabecera">PARTICIPACIÓN <br/>TOTAL</td>
                  </tr>
                  <tr>
                     <td rowspan="2" class="cabecera" >%</td>
                     <td colspan="2" class="cabecera">TITULAR DE LA <br/> PARTICIPACIÓN</td>                    
                  </tr>
                   <tr>
                     <td  class="cabecera" >NIF</td>
                     <td  class="cabecera">NOMBRE DE LA <br/> ENTIDAD</td>                    
                  </tr>
                  <xsl:call-template name="filas2">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigIntegradas" />
                  </xsl:call-template>
                </tbody>
            </table> 
            <br/><br/>
            <h3>Ejercicio económico y fecha de cierre del ejercicio (solo para el caso de una fecha o un ejercicio que difiera de los aplicados en la consolidación)</h3>
            <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
               <tbody>
                <tr>
                     <td colspan="2" class="cabecera">EJERCICIO ECONÓMICO Y FECHA DE CIERRE DEL EJERCICIO - E. MULTIGRUPO</td>
                  </tr>
                  <tr>
                     <td  class="cabecera">NIF</td>
                     <td class="cabecera">NOMBRE DE LA ENTIDAD</td>
                     <td class="cabecera" >EJERCICIO <br /> ECONÓMICO</td>
                     <td class="cabecera" >FECHA DE CIERRE DEL <br /> EJERCICIO</td>
                  </tr>
                  <xsl:call-template name="filas3">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigIntegradas" />
                  </xsl:call-template>
                </tbody>
            </table> 
            <br/><br/>
            <h3>Opinión de Auditoría y situación de las cuentas integradas de entidades multigrupo</h3>
             <table border="1" cellspacing="0" cellpadding="4" style="width:50%;">
               <tbody>
                  <tr>
                     <td colspan="2" class="cabecera">OPINIÓN DE AUDITORÍA Y SITUACIÓN DE LAS CUENTAS INTEGRADAS - E. MULTIGRUPO</td>
                  </tr>
                  <tr>
                     <td class="cabecera">NIF</td>
                     <td class="cabecera">NOMBRE ENTIDAD</td>
                     <td class="cabecera">OPINIÓN INFORME<br />AUDITORIA</td>
                     <td class="cabecera" >SITUACIÓN DE LAS<br />CUENTAS INTEGRADAS</td>
                  </tr>
                 
                  <xsl:call-template name="filas4">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigIntegradas" />
                     <xsl:with-param name="nodoEnumOpInfAudit" select="$nodoEnumOpInfAudit"></xsl:with-param>
                     <xsl:with-param name="nodoEnumSitCuentInteg" select="$nodoEnumSitCuentInteg"></xsl:with-param>
                  </xsl:call-template>
                </tbody>
            </table> 
             <br/><br/>
            <h3>Entidades multigrupo mantenidas para la venta</h3>
            <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
               <tbody>
                <tr>
                     <td colspan="2" class="cabecera">ENTIDADES MULTIGRUPO MANTENIDAS PARA LA VENTA</td>
                  </tr>
                  <tr>
                     <td class="cabecera">NIF</td>
                     <td class="cabecera">NOMBRE ENTIDAD</td>
                     
                  </tr>
                  <xsl:call-template name="filas5">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigIntegradas" />
                  </xsl:call-template>
                </tbody>
            </table> 
             <br/><br/> 
         </body>
      </html>
   </xsl:template>  

   <xsl:template name="filas1">
       <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
            <xsl:variable name="TipoEnte" select="n1:TipoEnte" />    
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependIM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>
                     <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
                     <td class="celdadatosizq" ><xsl:value-of select="$nodoEnumTipoEnte/xs:enumeration[@value=$TipoEnte]//xs:documentation"/></td>
                  </xsl:when>
               </xsl:choose>          
               
            </tr>
      </xsl:for-each>

   </xsl:template> 

<xsl:template name="filas2">
       <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">     
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependIM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>
                     <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
                     <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticDirect, '###.##0,00', 'format1')"/></td>
                     <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
                     <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
                     <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
                     <td class="celdadatosder"><xsl:value-of select="format-number(n1:PorcentParticTotal, '###.##0,00', 'format1')"/></td>
              
                  </xsl:when>
               </xsl:choose>              
              
            </tr>
      </xsl:for-each>

   </xsl:template> 

   <xsl:template name="filas3">
       <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">      
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependIM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>
                     <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
                     <td class="celdadatosder"><xsl:value-of select="n1:Ejercicio"/></td>
                     <td class="celdadatosder"><xsl:value-of select="n1:FechaCierre"/></td>                     
                  </xsl:when>
               </xsl:choose>
               
            </tr>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas4">
       <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumOpInfAudit"></xsl:param>
      <xsl:param name="nodoEnumSitCuentInteg"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
            <xsl:variable name="OpInfAudit" select="n1:OpInforAuditoria" />
            <xsl:variable name="SitCuentInteg" select="n1:SituaCuentInteg" />      
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependIM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>
                     <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
                     <td class="celdadatosizq" ><xsl:value-of select="$nodoEnumOpInfAudit/xs:enumeration[@value=$OpInfAudit]//xs:documentation"/></td>
                     <td class="celdadatosizq" ><xsl:value-of select="$nodoEnumSitCuentInteg/xs:enumeration[@value=$SitCuentInteg]//xs:documentation"/></td>
              
                  </xsl:when>
               </xsl:choose>             
               
            </tr>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas5">
       <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
            <xsl:variable name="TipoEnte" select="n1:TipoEnte" />     
            <tr>
              
            <xsl:if test="n1:EntMantVenta='1' or n1:EntMantVenta='true'">
               <xsl:choose>	
               <xsl:when  test="name(.)='DependIM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>
                     <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
                  </xsl:when>
               </xsl:choose>  
               
            </xsl:if>     
            </tr>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
