<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='EntDependientesMA']//xs:element[@name='PartIndirectaMA']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>
            
            <table border="1" cellspacing="0" cellpadding="4" style="width:50%;" >
               <tbody>
                  <tr>
                     <td class="cabecera" style="width:5%;">NIF</td>
                     <td class="cabecera" style="width:10%;">NOMBRE ENTIDAD</td>
                     <td class="cabecera" style="width:5%;">PARTICIPACIÓN<br/>INDIRECTA<br/>(%)</td>
                     <td class="cabecera" style="width:10%;">NIF ENTIDAD<br/>DEPENDIENTE</td>
                     <td class="cabecera" style="width:10%;">NOMBRE ENTIDAD<br/>DEPENDIENTE</td>
                  </tr>            
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:PartIndirectaMA" />
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>
  <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
  
            <tr>
                <xsl:choose>	
                  <xsl:when  test="name(.)='PartIMA'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>
                     
                  </xsl:when>
               </xsl:choose> 
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEnt"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ParticipIndirecta, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NifEntDepend"/></td>
               <td class="celdadatosizq"><xsl:value-of select="n1:NomEntDepend"/></td>
               
            </tr>
      </xsl:for-each>

   </xsl:template> 

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
