<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cgel-04-n="http://www.igae.pap.meh.es/cgel-04-n" xmlns:str="http://exslt.org/strings" exclude-result-prefixes="str">
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
	<xsl:template match="/">
		<html>
		<head>
			<script language="Javascript" type="text/javascript" src="funciones.js"></script> 
			<link rel="stylesheet" type="text/css" href="estiloHTML.css"></link>
			<title>Modelo Normal - Memoria</title>
		</head>
		<body>
			<table height="50px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#FFD700" border="0">
				<tr>
					<td width="15px"><img height="50px" src="cab_lat01.gif" width="15" alt="izqda" /></td>
					<td><img height="50px" alt="Ministerio de Economía y Hacienda" src="logo_meh.gif" width="129px" /></td>
					<td style="font-size:30px; vertical-align:bottom; font-weight:bold; color:#FFEB80" align="center">Cuenta General XML Modelo Normal</td>
					<td><img height="50px" alt="Intervención General de la Administración del Estado" src="logo_igae.gif" width="115px" align="right" /></td>
					<td width="15px"><img height="50px" src="cab_lat02.gif" width="15px" alt="dcha" /></td>
				</tr>
			</table>
			<table cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td><img height="5px" src="null.gif" width="5px" alt="null" /></td>
				</tr>
			</table>
			<table height="20px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#A5BEE7" border="0">
				<tr style="font-size:8pt">
					<td width="15px"><img height="22px" src="b_estado_lat01.gif" width="15px" alt="" /></td>
					<xsl:apply-templates select="//*[@tipo='I']"/>
					<td width="15px"><img height="22px" src="b_estado_lat02.gif" width="15px" alt="" /></td>
				</tr>
			</table>
			<table id="Principal" bgcolor="#ffffff" cellspacing="0" style="left:0px; position:relative; top:5px" border="0">
				<tr bgcolor="darkblue">
					<td id="Td7" width="140px">
						<table bgcolor="darkblue" id="Table5">
							<tr onmousedown="verMenu('Mem')">
								<td class="Menu"><b>Memoria</b><img src='tridownAm.gif' id="MemF" align="absmiddle" alt="" /></td>
							</tr>
							<tr>
								<td>
									<div id="Mem">
										<table cellpadding="4" cellspacing="0" class="tablaMenu" width="450px">
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InvDestUsoGen" id="celdaInvDestUsoGen">Inversiones Destinadas al Uso General</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#PatEntUsoGen" id="celdaPatEntUsoGen">Patrimonio Entregado al Uso General</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InmovInmat" id="celdaInmovInmat">Inmovilizaciones Inmateriales</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InmovMat" id="celdaInmovMat">Inmovilizaciones Materiales</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BienCesTemp" id="celdaBienCesTemp">Bienes en Régimen de Cesión Temporal</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BienAdscrip" id="celdaBienAdscrip">Bienes en Régimen de Adscripción</a></td>
											</tr>											
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BienEfectAGarant" id="celdaBienEfectAGarant">Bienes Afectos a Garantías</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InvGest" id="celdaInvGest">Inversiones Gestionadas</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#PatrPublSuel" id="celdaPatrPublSuel">Patrimonio Público del Suelo</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InvFin" id="celdaInvFin">Inversiones Financieras</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#PrestSingSig" id="celdaPrestSingSig">Préstamos Singulares Significativos</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#Exist" id="celdaExist">Existencias</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#Tes" id="celdaTes">Tesorería</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#EstConcBanc" id="celdaEstConcBanc">Estado de Conciliación Bancaria</a></td>
											</tr>											
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#FondProp" id="celdaFondProp">Fondos Propios</a></td>
											</tr>
											<tr onclick="verMenu('InfEnd')">
												<td style="cursor:pointer; color:gold" class="celdaMenu">Información sobre el Endeudamiento<img src="triright.gif" id="InfEndFL" alt="" />
													<div onclick="verMenu('InfEnd')" id="InfEnd">
													<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
															<tr onclick="verMenu('PasFinLCP')">
															<td style="cursor: pointer;color:gold" class="celdaMenu">Pasivos financieros a largo y corto plazo<img src="triright.gif" id="PasFinLCPFL" alt="" />
																<div id="PasFinLCP" onclick="verMenu('InfEnd');verMenu('Mem')">
																	<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																		<tr onclick="verMenu('EstDeudCap');verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');">
																				<td style="cursor: pointer;color:gold" class="celdaMenu">Estado de la deuda. Capitales
																					<img src="triright.gif" id="EstDeudCapFL" alt="" />
																					<div onclick="verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');" id="EstDeudCap">
																						<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaCapNac" id="celdaEstDeudaCapNac">Deudas en moneda nacional</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaCapDistEur" id="celdaEstDeudaCapDistEur">Deudas en moneda distinta del euro</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																			<tr onclick="verMenu('EstDeudIntExp');verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');">
																				<td style="cursor: pointer;color:gold" class="celdaMenu">Estado de la deuda. Intereses explícitos
																					<img src="triright.gif" id="EstDeudIntExpFL" alt="" />
																					<div onclick="verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');" id="EstDeudIntExp">
																						<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntExpNac" id="celdaEstDeudaIntExpNac">Deudas en moneda nacional</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntExpDistEur" id="celdaEstDeudaIntExpDistEur">Deudas en moneda distinta del euro</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																			<tr onclick="verMenu('EstDeudIntImp');verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');">
																				<td style="cursor: pointer;color:gold" class="celdaMenu">Estado de la deuda. Intereses implícitos
																					<img src="triright.gif" id="EstDeudIntImpFL" />
																					<div onclick="verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');" id="EstDeudIntImp">
																						<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntImpNac" id="celdaEstDeudaIntImpNac">Deudas en moneda nacional</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntImpDistEur" id="celdaEstDeudaIntImpDistEur">Deudas en moneda distinta del euro</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																	</table>
																</div>
															</td>
															</tr>
															<tr onclick="verMenu('OperIntFin')">
																<td style="cursor: pointer;color:gold" class="celdaMenu">Operaciones de Intercambio Financiero<img src="triright.gif" id="OperIntFinFL" />
																	<div id="OperIntFin"  onclick="verMenu('InfEnd');verMenu('Mem')">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr>
																				<td class="celdaMenu"><a href="#ResOperIntFinDiv" id="celdaResOperIntFinDiv">Resultado de las Operaciones de Intercambio Financiero de Divisas</a></td>
																			</tr>
																			<tr>
																				<td class="celdaMenu"><a href="#ResOperIntFinInter" id="celdaResOperIntFinInter">Resultado de las Operaciones de Intercambio Financiero de Intereses</a></td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
															<tr>
																<td onclick="verMenu('InfEnd');verMenu('Mem')" class="celdaMenu"><a href="#AvConc" id="celdaAvConc">Avales Concedidos</a></td>
															</tr>
															<tr>
																<td onclick="verMenu('InfEnd');verMenu('Mem')" class="celdaMenu"><a href="#AvRein" id="celdaAvRein">Avales Reintegrados</a></td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr onclick="verMenu('InfOperOtrEntPubl')">
												<td style="cursor:pointer; color:gold" class="celdaMenu">Información de las operaciones por administración de recursos por cuenta de otros entes públicos<img src="triright.gif" id="InfOperOtrEntPublFL" alt="" />
												<div onclick="verMenu('Mem');" id="InfOperOtrEntPubl">
												<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
													<tr>
												<td class="celdaMenu"><a href="#DesProcGestRecAdmin" id="celdaDesProcGestRecAdmin">Desarrollo del Proceso de Gestión de los Recursos Administrados</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#DesDevRecOtrEntPubl" id="celdaDesDevRecOtrEntPubl">Desarrollo de las Devoluciones de Recursos de Otros Entes Públicos</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#OblDerGest" id="celdaOblDerGest">Obligaciones Derivadas de la Gestión</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#CtaCorrOtrEntPubl" id="celdaCtaCorrOtrEntPubl">Cuentas Corrientes con Otros Entes Públicos</a></td>
											</tr>
												</table>
											</div>
												</td>
											</tr>
											<tr onclick="verMenu('OperNoPresTes')">
												<td style="cursor: pointer;color:gold" class="celdaMenu">Operaciones No Presupuestarias de Tesorería<img src="triright.gif" id="OperNoPresTesFL" alt="" />
													<div onclick="verMenu('Mem')" id="OperNoPresTes">
														<table cellpadding="4" cellspacing="0" class="tablaMenu" width="400px">
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesDeud" id="celdaOperNoPresTesDeud">Deudores</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesAcr" id="celdaOperNoPresTesAcr">Acreedores</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesPartPendAppCobr" id="celdaOperNoPresTesPartPendAppCobr">Partidas Pendientes de Aplicación. Cobros</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesPartPendAppPag" id="celdaOperNoPresTesPartPendAppPag">Partidas Pendientes de Aplicación. Pagos</a></td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#SubRecPendJust" id="celdaSubRecPendJust">Subvenciones Recibidas Pendientes de Justificar</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#TransYSubConcSig" id="celdaTransYSubConcSig">Transferencias y Subvenciones Concedidas Significativas</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#EstValRecDepList" id="celdaEstValRecDepList">Estado de Valores Recibidos en Depósito</a></td>
											</tr>
											<tr onclick="verMenu('CuadFin')">
												<td style="cursor:pointer; color:gold" class="celdaMenu">Cuadro de Financiación<img src="triright.gif" id="CuadFinFL" alt="" />
													<div onclick="verMenu('Mem')" id="CuadFin">
														<table cellpadding="4" cellspacing="0" class="tablaMenu" width="420px">
															<tr>
																<td class="celdaMenu"><a href="#CuadFinFondApl" id="celdaCuadFinFondApl">Fondos aplicados</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#CuadFinFondObt" id="celdaCuadFinFondObt">Fondos obtenidos</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#CuadFinVarCap" id="celdaCuadFinVarCap">Variación del capital circulante</a></td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr onclick="verMenu('InfPres')">
												<td style="cursor:pointer; color:gold" class="celdaMenu">Información presupuestaria<img src="triright.gif" id="InfPresFL" alt="" />
													<div onclick="verMenu('InfPres')" id="InfPres">
													<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
															<tr onclick="verMenu('EjCorr')">
															<td style="cursor:pointer; color:gold" class="celdaMenu">Ejercicio corriente<img src="triright.gif" id="EjCorrFL" alt="" />
																<div id="EjCorr" onclick="verMenu('InfPres');verMenu('Mem')">
																	<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																		<tr onclick="verMenu('PresGast');verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');">
																				<td style="cursor:pointer; color:gold" class="celdaMenu">Presupuesto de gastos
																					<img src="triright.gif" id="PresGastFL" alt="" />
																					<div 
																							onclick="verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');" id="PresGast">
																						<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#ModCred" id="celdaModCred">Modificaciones de Crédito</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#RemCred" id="celdaRemCred">Remanentes de Crédito</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#ProGast" id="celdaProGast">Proyectos de Gasto</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#AcrOpsPendAplPres" id="celdaAcrOpsPendAplPres">Acreedores por Operaciones Pendientes de Aplicar a Presupuesto</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																			<tr onclick="verMenu('PresIng');verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');">
																				<td style="cursor: pointer;color:gold" class="celdaMenu">Presupuesto de ingresos<img src="triright.gif" id="PresIngFL" alt="" />
																						<div id="PresIng" onclick="verMenu('InfPres');verMenu('Mem')">
																							<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr onclick="verMenu('ProcGest');verMenu('PresIng');verMenu('InfPres');verMenu('Mem');">
																										<td style="cursor: pointer;color:gold" class="celdaMenu">Proceso de gestión
																											<img src="triright.gif" id="ProcGestFL" alt="" />
																											<div onclick="verMenu('PresIng');verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');" id="ProcGest">
																												<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																													<tr>
																														<td class="celdaMenu"><a href="#DerAnul" id="celdaDerAnul">Derechos Anulados</a></td>
																													</tr>
																													<tr>
																														<td class="celdaMenu"><a href="#DerCanc" id="celdaDerCanc">Derechos Cancelados</a></td>
																													</tr>
																													<tr>
																														<td class="celdaMenu"><a href="#RecNet" id="celdaRecNet">Recaudación Neta</a></td>
																													</tr>
																												</table>
																											</div>
																										</td>
																								</tr>
																								<tr onclick="verMenu('EjCorr')">
																									<td class="celdaMenu"><a href="#DevIng" id="celdaDevIng">Devoluciones de Ingresos</a></td>
																								</tr>
																								<tr onclick="verMenu('EjCorr')">
																									<td class="celdaMenu"><a href="#ComprIng" id="celdaComprIng">Compromisos de Ingreso</a></td>
																								</tr>
																							</table>
																						</div>
																					</td>
																				</tr>
																			</table>
																</div>
															</td>
															</tr>
															<tr onclick="verMenu('EjCerr')">
															<td style="cursor: pointer;color:gold" class="celdaMenu">Ejercicios cerrados<img src="triright.gif" id="EjCerrFL" alt="" />
																<div id="EjCerr" onclick="verMenu('InfPres');verMenu('Mem')">
																	<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																		<tr>
																			<td class="celdaMenu"><a href="#OblPresCerr" id="celdaOblPresCerr">Obligaciones de Presupuestos Cerrados</a></td>
																		</tr>
																		<tr onclick="verMenu('DerPresCerr');verMenu('EjCerr');verMenu('InfPres');verMenu('Mem');">
																			<td style="cursor:pointer; color:gold" class="celdaMenu">Derechos a Cobrar de Presupuestos Cerrados<img src="triright.gif" id="DerPresCerrFL" alt="" />
																				<div id="DerPresCerr"  onclick="verMenu('EjCerr');verMenu('InfPres');verMenu('Mem')">
																					<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																						<tr>
																							<td class="celdaMenu"><a href="#DerPresCerrAnul" id="celdaDerPresCerrAnul">Derechos Anulados</a></td>
																						</tr>
																						<tr>
																							<td class="celdaMenu"><a href="#DerPresCerrCanc" id="celdaDerPresCerrCanc">Derechos Extinguidos</a></td>
																						</tr>
																					</table>
																				</div>
																			</td>
																		</tr>
																		<tr>
																			<td class="celdaMenu"><a href="#VarResPresEjAnt" id="celdaVarResPresEjAnt">Variación de Resultados Presupuestarios de Ejercicios Anteriores</a></td>
																		</tr>
																		</table>
																</div>
															</td>
															</tr>
															<tr onclick="verMenu('EjPost')">
															<td style="cursor:pointer; color:gold" class="celdaMenu">Ejercicios posteriores<img src="triright.gif" id="EjPostFL" alt="" />
																<div id="EjPost"  onclick="verMenu('EjPost');verMenu('InfPres');verMenu('Mem')">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr onclick="verMenu('EjPost');">
																				<td class="celdaMenu"><a href="#ComprGastEjPost" id="celdaComprGastEjPost">Compromisos de gasto con cargo a presupuestos de ejercicios posteriores</a></td>
																			</tr>
																			<tr onclick="verMenu('EjPost');">
																				<td class="celdaMenu"><a href="#ComprIngEjPost" id="celdaComprIngEjPost">Compromisos de ingreso con cargo a presupuestos de ejercicios posteriores</a></td>
																			</tr>
																		</table>
																	</div>
															</td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr onclick="verMenu('GastFinAfect')">
												<td style="cursor: pointer;color:gold" class="celdaMenu">Gastos con financiación afectada<img src="triright.gif" id="GastFinAfectFL" alt="" />
												<div onclick="verMenu('GastFinAfect')" id="GastFinAfect">
													<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
														<tr onclick="verMenu('GastFinAfect');verMenu('Mem')">
															<td class="celdaMenu"><a href="#DesvFin" id="celdaDesvFin">Desviaciones de financiación</a></td>
														</tr>
														<tr onclick="verMenu('InfUniGast');">
															<td style="cursor: pointer;color:gold" class="celdaMenu">Información por unidad de gasto<img src="triright.gif" id="InfUniGastFL" alt="" />
																<div onclick="verMenu('InfUniGast')" id="InfUniGast">
																	<table cellpadding="4" cellspacing="0" class="tablaMenu" width="450px">
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DatGenIdent" id="celdaDatGenIdent">A) Datos generales indentificativos</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DatGenIdentAppPres" id="celdaDatGenIdentAppPres">A) Datos generales indentificativos (aplicaciones presupuestarias)</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestGast" id="celdaGestGast">B) Gestión del gasto</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestGastTot" id="celdaGestGastTot">B) Gestión del gasto (totales)</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestIngAfect" id="celdaGestIngAfect">C) Gestión de los ingresos afectados</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestIngAfectTot" id="celdaGestIngAfectTot">C) Gestión de los ingresos afectados (totales)</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DesvFinAgent" id="celdaDesvFinAgent">D) Desviaciones de financiación por agentes</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DesvFinAgentTot" id="celdaDesvFinAgentTot">D) Desviaciones de financiación por agentes (totales)</a></td>
																		</tr>
																	</table>
																</div>
															</td>
														</tr>
													</table>
												</div>
												</td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#RemTes" id="celdaRemTes">Remanente de tesorería</a></td>
											</tr>
											<tr onclick="verMenu('Ind')">
												<td style="cursor: pointer;color:gold" class="celdaMenu">Indicadores<img src="triright.gif" id="IndFL" alt=""/>
													<div onclick="verMenu('Ind')" id="Ind">
														<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
															<tr onclick="verMenu('IndFin');">
																<td style="cursor: pointer;color:gold" class="celdaMenu">Indicadores financieros y patrimoniales<img src="triright.gif" id="IndFinFL" />
																	<div onclick="verMenu('IndFin')" id="IndFin">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr onclick="verMenu('Ind');verMenu('IndFin');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#LiqInm" id="celdaLiqInm">Liquidez inmediata</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndFin');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#SolvCortPlaz" id="celdaSolvCortPlaz">Solvencia a corto plazo</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndFin');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#EndHab" id="celdaEndHab">Endeudamiento por habitante</a></td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
															<tr onclick="verMenu('IndPres');">
																<td style="cursor: pointer;color:gold" class="celdaMenu">Indicadores presupuestarios<img src="triright.gif" id="IndPresFL" alt="" />
																	<div onclick="verMenu('IndPres')" id="IndPres">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr onclick="verMenu('IndPresCorr');">
																				<td style="cursor:pointer; color:gold" class="celdaMenu">Del presupuesto corriente<img src="triright.gif" id="IndPresCorrFL" alt="" />
																						<div onclick="verMenu('IndPres');verMenu('Ind');verMenu('Mem');" id="IndPresCorr">
																							<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																								<tr>
																									<td class="celdaMenu"><a href="#EjecPresGast" id="celdaEjecPresGast">Ejecución del presupuesto de gastos</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#RealPag" id="celdaRealPag">Realización de pagos</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#GastHab" id="celdaGastHab">Gasto por habitante</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#InvHab" id="celdaInvHab">Inversión por habitante</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#EsfInv" id="celdaEsfInv">Esfuerzo inversor</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#PerMedPag" id="celdaPerMedPag">Periodo medio de pago</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#EjecPresIng" id="celdaEjecPresIng">Ejecución del presupuesto de ingresos</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#RealCobr" id="celdaRealCobr">Realización de cobros</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#Aut" id="celdaAut">Autonomía</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#AutFisc" id="celdaAutFisc">Autonomía fiscal</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#PerMedCobr" id="celdaPerMedCobr">Periodo medio de cobro</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#SupDefHab" id="celdaSupDefHab">Superávit (o déficit) por habitante</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#ContrPresRemTes" id="celdaContrPresRemTes">Contribución del presupuesto al remanente de tesorería</a></td>
																								</tr>
																							</table>
																						</div>
																					</td>
																			</tr>
																			<tr onclick="verMenu('IndPresCerr');">
																				<td style="cursor:pointer; color:gold" class="celdaMenu">De presupuestos cerrados<img src="triright.gif" id="IndPresCerrFL" alt="" />
																					<div onclick="verMenu('IndPres');verMenu('Ind');verMenu('Mem');" id="IndPresCerr">
																						<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#RealPagCerr" id="celdaRealPagCerr">Realización de pagos</a></td>
																							</tr>																								
																							<tr>
																								<td class="celdaMenu"><a href="#RealCobrCerr" id="celdaRealCobrCerr">Realización de cobros</a></td>
																							</tr>
																							
																						</table>
																					</div>
																				</td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
															<tr onclick="verMenu('IndGest');">
																<td style="cursor: pointer;color:gold" class="celdaMenu">Indicadores de gestión<img src="triright.gif" id="IndGestFL" alt="" />
																	<div onclick="verMenu('IndGest')" id="IndGest">
																		<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#CostServXNumHab" id="celdaCostServXNumHab">Coste del servicio por habitante</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#RendServXCostServ" id="celdaRendServXCostServ">Rendimiento del servicio por coste del servicio</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#CostServXNumPrest" id="celdaCostServXNumPrest">Coste del servicio por número de prestaciones</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#CostServXCostEstServ" id="celdaCostServXCostEstServ">Coste del servicio por coste estimado del servicio</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#NumEmpServXNumHab" id="celdaNumEmpServXNumHab">Número de empleados del servicio por número de habitantes</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#NumPrestRealXNumPrestPrev" id="celdaNumPrestRealXNumPrestPrev">Número de prestaciones realizadas por número de prestaciones previstas</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndGest');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#NumPrestRealXNumHab" id="celdaNumPrestRealXNumHab">Número de prestaciones realizadas por número de habitantes</a></td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>															
														</table>
													</div>
												</td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BalComp" id="celdaBalComp">Balance de comprobación</a></td>
											</tr>											
										</table>
									</div>
								</td>
								<td width="500px"></td>
							</tr>
						</table>
					</td>
				</tr>
				<tr bgcolor="#ffffff">
					<td colspan="8" width="900px">
						<br/>
						<hr/>
						<!-- Listados -->
						<xsl:apply-templates select="//cgel-04-n:Mem//*[@tipo='L']"/>					
					</td>
				</tr>
			</table>
		</body>
		</html>
	</xsl:template>
	
	<!--Plantilla Frame Datos Entidad-->
	<xsl:template name="frame_datos" match="//*[@tipo='I']">
		<xsl:for-each select=".//*[@tipo='D']">
			<xsl:if test="@des='Nombre Entidad'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='Código MAP'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='CIF'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='Ejercicio'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	
	<!-- Plantilla Listados -->
	<xsl:template name="listado" match="//cgel-04-n:Mem//*[@tipo='L']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		
		<h2 style="background-color:darkblue">
			<font color="gold">
				<a>
				<xsl:attribute name="name">
					<xsl:value-of select="local-name()"/>
				</xsl:attribute>
				<xsl:value-of select="@des"/>
				</a>
				<a href='javascript:VolverAlPrincipio()'><img src='ArrowUp.gif' align='absmiddle' alt='Volver al Principio'/></a>
				<!---Esto es el titulo del listado-->
			</font>
		</h2>

		<br/>
		<table cellspacing="0" cellpadding="4" width="900px" style="border-collapse:collapse">
			<tbody>
				<font face="verdana">
					<tr style="font-size:8pt" align="center">
						<td />
						<td />
						<xsl:for-each select=".//*[@tipo='C' and @des!='']">
							<!---Aqui se crean las cabeceras de las columnas-->
							<th style="border: solid; border-width:1px; border-color:black" bgcolor="LightSteelBlue">
									<xsl:value-of select="translate(@des, $small, $CAPS)"/>
							</th>
						</xsl:for-each>
					</tr>
					<!-- Aplicar plantilla de detalle -->
					<xsl:apply-templates select=".//*[@tipo='D']"/>
					<!-- Aplicar plantilla de totales -->
					<xsl:call-template name="totales"/>
				</font>
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>
	
	<!-- Plantilla Detalles listados -->
	<xsl:template name="detalle" match="//*[@tipo='D']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<tr style="font-size:8pt">
			<td />
			<xsl:choose>
				<xsl:when test="@des!=''">
					<td style="border:solid; border-width:1px; border-color:black">
					<!---Columnas con descripcion que no son cabeceras ni datos-->
						<strong>
							<xsl:value-of select="@des" />
						</strong>
					</td>
				</xsl:when>
				<xsl:otherwise>
				<td width="0px" />
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select=".//*[@tipo='C']">
				<!---Aqui se crean las columnas con datos-->
				<xsl:choose>
					<!-- Tipo de Bien (Modelo Normal)  -->
					<xsl:when test="local-name()='TipoBien' and .='TERR'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Terrenos y bienes naturales</td>					
					</xsl:when>				
					<xsl:when test="local-name()='TipoBien' and .='CONS'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Construcciones</td>					
					</xsl:when>	
					<xsl:when test="local-name()='TipoBien' and .='INST'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Instalaciones técnicas</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='MAQ'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Maquinaria</td>					
					</xsl:when>										
					<xsl:when test="local-name()='TipoBien' and .='UTILL'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Utillaje</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='MOB'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Mobiliario</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='EQUINF'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Equipos para procesos de información</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='TRANS'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Elementos de transporte</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='INMV'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Otro inmovilizado material</td>					
					</xsl:when>						
					<!-- Otro tipos de bienes definidos para Patrimonio Entregado al Uso General -->
					<xsl:when test="local-name()='TipoBien' and .='INFR'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Infraestructuras y bienes destinados al uso general</td>					
					</xsl:when>
					<xsl:when test="local-name()='TipoBien' and .='BIEN'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Bienes comunales</td>					
					</xsl:when>
					<xsl:when test="local-name()='TipoBien' and .='PATR'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Bienes del Patrimonio histório, artístico y cultural</td>					
					</xsl:when>	
					<!-- Tipos de deuda -->
					<xsl:when test="local-name()='TipDeud' and .='EMPR'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Empréstitos y otras emisiones análogas</td>					
					</xsl:when>		
					<xsl:when test="local-name()='TipDeud' and .='EMPRTES'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Empréstitos y otras emisiones análogas por operaciones de tesorería</td>					
					</xsl:when>	
					<xsl:when test="local-name()='TipDeud' and .='DEUD'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Deudas con entidades de crédito</td>					
					</xsl:when>							
					<xsl:when test="local-name()='TipDeud' and .='DEUDTES'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Deudas con entidades de crédito por Operaciones de Tesorería</td>					
					</xsl:when>							
					<xsl:when test="local-name()='TipDeud' and .='DEUDPUB'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Deudas con Entidades Públicas</td>					
					</xsl:when>		
					<xsl:when test="local-name()='TipDeud' and .='OTRDEUD'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Otras Deudas</td>					
					</xsl:when>
					<!-- Valor 0 => Poner decimales -->
					<xsl:when test=".=0">
						<td style="border: solid; border-width:1px;border-color:black" align="right">0,00</td>
					</xsl:when>

					<xsl:when test="format-number(., '###.##0,00', 'european')='NaN' or (format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')='')">
						<td style="border: solid; border-width:1px;border-color:black" align="left">
							<xsl:value-of select="concat(substring(translate(., $small, $CAPS),1,1),substring(translate(., $CAPS, $small),2))"/>
						</td>
					</xsl:when>

					<!-- Formato importe -->
					<xsl:when test="format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')!=''">
						<td style="border:solid; border-width:1px;border-color:black" align="right">
							<xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
						</td>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>	

	<!-- Plantilla totales -->
	<xsl:template name="totales">
			<xsl:for-each select=".//*[@tipo='D' and position()=1]">
				<xsl:choose>
					<!--Inversiones destinadas al uso general-->
					<xsl:when test="local-name()='InvDestUsoGenDet'">
						<tr style="font-size:8pt" align="right">
							<td />
							<td />
							<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
						</tr>
					</xsl:when>
					<!--Patrimonio entregado al uso general-->
					<xsl:when test="local-name()='PatEntUsoGenDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ValorBien),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Inmovilizaciones inmateriales-->
					<xsl:when test="local-name()='InmovInmatDet'">
						<tr style="font-size:8pt" align="right">
							<td />
							<td />
							<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
									<strong>
										TOTAL
									</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
						</tr>
					</xsl:when>
					<!--Inmovilizaciones materiales-->
					<xsl:when test="local-name()='InmovMatDet'">
						<tr style="font-size:8pt" align="right">
							<td />
							<td />
							<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
						</tr>
					</xsl:when>
					<!--Bienes en Régimen de Cesión Temporal-->
					<xsl:when test="local-name()='BienCesTempDet'">
						<tr style="font-size:8pt" align="right">
							<td />
							<td />
							<td style="border: solid; border-width:1px; border-color:black" colspan="4" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ValorBien),'###.##0,00','european')"/>
								</strong>
							</td>
						</tr>
					</xsl:when>
					<!--Bienes en Régimen de Adscripción-->
					<xsl:when test="local-name()='BienAdscripDet'">
						<tr style="font-size:8pt" align="right">
							<td />
							<td />
							<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ValorBien),'###.##0,00','european')"/>
								</strong>
							</td>
						</tr>
					</xsl:when>					
					<!--Bienes Afectos a Garantías-->
					<xsl:when test="local-name()='BienEfectAGarantDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpGarant),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ValorBien),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>					
					</xsl:when>
					<!--Inversiones Gestionadas-->
					<xsl:when test="local-name()='InvGestDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Patrimonio Público del Suelo-->
					<xsl:when test="local-name()='PatrPublSuelDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Inversiones Financieras-->
					<xsl:when test="local-name()='InvFinDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Préstamos singulares significativos-->
					<xsl:when test="local-name()='PrestSingSigDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Imp),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Existencias-->
					<xsl:when test="local-name()='ExistDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PrecAdqCostProd),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpProvDepr),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Tesorería-->
					<xsl:when test="local-name()='TesDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Cobr),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pag),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Estado de conciliación bancaria-->
					<xsl:when test="local-name()='EstConcBancDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SaldSegEntBanc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrContEntYNoBanc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagContEntYNoBanc),'###.##0,00','european')"/>
								</strong>
							</td>							
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrContBancYNoEnt),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagContBancYNoEnt),'###.##0,00','european')"/>
								</strong>
							</td>							
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SaldConc),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SaldSegEnt),'###.##0,00','european')"/>
								</strong>
							</td>			
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifSald),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>						
					</xsl:when>			
					<!--Fondos Propios-->
					<xsl:when test="local-name()='FondPropDet'">
						<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIni),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:EntODot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AumTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalBajRed),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DismTransfOTraspCuenta),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalFin),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Capitales. Deudas en moneda nacional-->
					<xsl:when test="local-name()='EstDeudaCapNacDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>														
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneTot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Creac),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AmortDism),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicTot),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Capitales. Deudas en moneda distinta del euro-->
					<xsl:when test="local-name()='EstDeudaCapDistEurDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>														
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend1EneTot),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Creac),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifCamb),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AmortDism),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pend31DicTot),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Intereses Explicitos. Deudas en moneda nacional-->
					<xsl:when test="local-name()='EstDeudaIntExpNacDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev1EneLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev1EneCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:VencEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RectTrasp),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev31DicLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev31DicCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Intereses Explicitos. Deudas en moneda distinta del euro-->
					<xsl:when test="local-name()='EstDeudaIntExpDistEurDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev1EneLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev1EneCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:VencEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RectTrasp),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifCamb),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev31DicLargPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Dev31DicCortPlaz),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Intereses Implicitos. Deudas en moneda nacional-->
					<xsl:when test="local-name()='EstDeudaIntImpNacDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpEmision),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black"/>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpReembolso),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotIntImp),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:BajYRect),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEjAnt),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendDev31Dic),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Intereses Implicitos. Deudas en moneda distinta del euro-->
					<xsl:when test="local-name()='EstDeudaIntImpDistEurDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpEmision),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black"/>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpReembolso),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotIntImp),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:BajYRect),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEjAnt),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevEj),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendDev31Dic),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Resultado de las Operaciones de Intercambio Financiero de Divisas-->
					<xsl:when test="local-name()='ResOperIntFinDivDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastForm),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IntDevDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IntDevAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifCamb),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ResCancAnt),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ResAcum),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Resultado de las Operaciones de Intercambio Financiero de Intereses-->
					<xsl:when test="local-name()='ResOperIntFinInterDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastForm),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IntDevDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IntDevAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DifCamb),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ResCancAnt),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ResAcum),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Avales concedidos-->
					<xsl:when test="local-name()='AvConcDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="5" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Av1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AvConcEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AvCancEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Av31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Avales reintegrados-->
					<xsl:when test="local-name()='AvReinDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpRein),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black"/>
						<td style="border: solid; border-width:1px; border-color:black"/>
						</tr>
					</xsl:when>
					<!--Desarrollo del Proceso de Gestión de los Recursos Administrados-->
					<xsl:when test="local-name()='DesProcGestRecAdminDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SalIniDerPendCobr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerRecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecBrut),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecDev),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecLiq),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCanc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerPendCobr),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Desarrollo de las Devoluciones de Recursos de Otros Entes Públicos-->
					<xsl:when test="local-name()='DesDevRecOtrEntPublDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevRecSalIniPendPag),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevRecModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevRecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevRecTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Obligaciones Derivadas de la Gestión-->
					<xsl:when test="local-name()='OblDerGestDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagRecLiq),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagReint),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPagTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagRealiz),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagPend31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Cuentas Corrientes con Otros Entes Públicos-->
					<xsl:when test="local-name()='CtaCorrOtrEntPublDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargSalIniDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargPag),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DatSalIniAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DatIng),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DatTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal31DicDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal31DicAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Deudores-->
					<xsl:when test="local-name()='OperNoPresTesDeudDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDeud),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AbRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DeudPendCobr31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Acreedores-->
					<xsl:when test="local-name()='OperNoPresTesAcrDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AbRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotAcr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CargRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AcrPendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Partidas Pendientes de Aplicación. Cobros-->
					<xsl:when test="local-name()='OperNoPresTesPartPendAppCobrDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrPendApp1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotCobrPendApp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrAplicEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrPendApp31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Partidas Pendientes de Aplicación. Pagos-->
					<xsl:when test="local-name()='OperNoPresTesPartPendAppPagDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagPendApp1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagRealizEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotPagPendApp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagAplicEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagPendApp31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Subvenciones Recibidas Pendientes de Justificar-->
					<xsl:when test="local-name()='SubRecPendJustDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" align="left">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpRec),'###.##0,00','european')"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ImpPendJust),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Transferencias y Subvenciones Concedidas Significativas-->
					<xsl:when test="local-name()='TransYSubConcSigDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" align="left" colspan="2">
								<strong>
									TOTAL
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
								<strong>
									<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Imp),'###.##0,00','european')"/>
								</strong>
							</td>
							</tr>
					</xsl:when>
					<!--Estado de Valores Recibidos en Depósito-->
					<xsl:when test="local-name()='EstValRecDepDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Sal1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DepRecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDepRec),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DepCanc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DepPendDev31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Modificaciones de Crédito-->
					<xsl:when test="local-name()='ModCredDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="6" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CredExtra),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:SuplCred),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AmplCred),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TransfCredPos),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TransfCredNeg),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:IncRemCred),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CredGenIng),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:BajAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AjustProrrog),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotMod),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Remanentes de Crédito-->
					<xsl:when test="local-name()='RemCredDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="6" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RemCompIncorp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RemCompNoIncorp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RemNoCompIncorp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RemNoCompNoIncorp),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Proyectos de Gasto-->
					<xsl:when test="local-name()='ProGastDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="4" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastPrev),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastComp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblRec1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblRecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblRecTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:GastPendRealiz),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Acreedores por Operaciones Pendientes de Aplicar a Presupuesto-->
					<xsl:when test="local-name()='AcrOpsPendAplPresDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="7" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Importe),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Pagado),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Proceso de Gestión: Derechos Anulados-->
					<xsl:when test="local-name()='DerAnulDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AnulLiq),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:AplazYFracc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevIng),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDerAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Proceso de Gestión: Derechos Cancelados-->
					<xsl:when test="local-name()='DerCancDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:CobrEsp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Insolv),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OtrCausas),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDerCanc),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Proceso de Gestión: Recaudación Neta-->
					<xsl:when test="local-name()='RecNetDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DevIng),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecNet),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Devoluciones de Ingresos-->
					<xsl:when test="local-name()='DevIngDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPag1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIniYAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:RecEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDevRec),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Prescrip),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Compromisos de Ingreso-->
					<xsl:when test="local-name()='ComprIngDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprConcIncPresCerr),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprConcEj),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprConcTot),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprRealiz),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendReal31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Obligaciones de Presupuestos Cerrados-->
					<xsl:when test="local-name()='OblPresCerrDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" align="left" colspan="7">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblPendPag1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIniYAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotObl),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Prescrip),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PagRealiz),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:OblPendPag31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Derechos a Cobrar de Presupuestos Cerrados. Derechos Anulados-->
					<xsl:when test="local-name()='DerPresCerrAnulDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" align="left" colspan="3">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendCobr1Ene),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ModSalIni),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerAnulLiq),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerAnulAplazYFracc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDerAnul),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Derechos a Cobrar de Presupuestos Cerrados. Derechos Extinguidos-->
					<xsl:when test="local-name()='DerPresCerrCancDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" align="left" colspan="3">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCancCobrEsp),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCancInsolv),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCancPrescrip),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DerCancOtrCausas),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:TotDerCanc),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:Rec),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:PendCobr31Dic),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Compromisos de Gasto con Cargo a Presupuestos de Ejercicios Posteriores-->
					<xsl:when test="local-name()='ComprGastEjPostsApp'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="7" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprGast),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Compromisos de Ingreso con Cargo a Presupuestos de Ejercicios Posteriores-->
					<xsl:when test="local-name()='ComprIngEjPostsApp'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:ComprIng),'###.##0,00','european')"/>
							</strong>
						</td>
						</tr>
					</xsl:when>
					<!--Gastos con Financiación Afectada. Desviaciones de Financiación-->
					<xsl:when test="local-name()='DesvFinDet'">
					<tr style="font-size:8pt" align="right">
						<td />
						<td />
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								TOTAL
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DesvEjPos),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DesvEjNeg),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DesvAcumPos),'###.##0,00','european')"/>
							</strong>
						</td>
						<td style="border:solid; border-width:1px; border-color:black">
							<strong>
								<xsl:value-of select="format-number(sum(parent::*/*/cgel-04-n:DesvAcumNeg),'###.##0,00','european')"/>
							</strong>
						</td>
					</tr>
					</xsl:when>
				</xsl:choose>				
			</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
