<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:cgel-04-s-2008="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-04-s-2008_2008-12-31" xmlns:str="http://exslt.org/strings" exclude-result-prefixes="str">
<xsl:decimal-format name="european" decimal-separator=',' grouping-separator='.' />
<xsl:template match="/">
		<html>
			<head>
				<script language="Javascript" type="text/javascript" src="funciones.js"></script> 
				<link rel="stylesheet" type="text/css" href="estiloHTML.css"></link>
				<title>Modelo Simplificado - Memoria</title>
			</head>
		<body>
			<table height="50px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#FFD700" border="0">
				<tr>
					<td width="15px"><img height="50px" src="cab_lat01.gif" width="15" alt="izqda" /></td>
					<td><img height="50px" alt="Ministerio de Economía y Hacienda" src="logo_meh.gif" width="129px" /></td>
					<td style="font-size:30px; vertical-align:bottom; font-weight:bold; color:#FFEB80" align="center">Cuenta General XML Modelo Simplificado</td>
					<td><img height="50px" alt="Intervención General de la Administración del Estado" src="logo_igae.gif" width="115px" align="right" /></td>
					<td width="15px"><img height="50px" src="cab_lat02.gif" width="15px" alt="dcha" /></td>
				</tr>
			</table>
			<table cellspacing="0" cellpadding="0" width="100%" border="0">
				<tr>
					<td><img height="5px" src="null.gif" width="5px" alt="null" /></td>
				</tr>
			</table>
			<table height="20px" cellspacing="0" cellpadding="0" width="100%" bgcolor="#A5BEE7" border="0">
				<tr style="font-size:8pt">
					<td width="15px"><img height="22px" src="b_estado_lat01.gif" width="15px" alt="" /></td>
					<xsl:apply-templates select="//*[@tipo='I']"/>
					<td width="15px"><img height="22px" src="b_estado_lat02.gif" width="15px" /></td>
				</tr>
			</table>
			<table id="Principal" bgcolor="#ffffff" cellspacing="0" style="left:0px; position:relative; top:5px" border="0">
				<tr bgcolor="darkblue" ID="Tr1">
					<td colspan="8" ID="Td6"><img src='null.gif' height="10"/>
					</td>
				</tr>
				<tr bgcolor="darkblue">
					<td ID="Td7" width="140px">
						<table bgcolor="darkblue" ID="Table5">
							<tr onmousedown="verMenu('Mem')">
								<td class="Menu"><b>Memoria</b><img src='tridownAm.gif' id="MemF" align="absmiddle"/></td>
							</tr>
							<tr>
								<td>
									<div id="Mem">
										<table cellpadding="4" cellspacing="0" class="tablaMenu" width="450px">
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InvDestUsoGen" id="celdaInvDestUsoGen">Inversiones Destinadas al Uso General</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#PatEntUsoGen" id="celdaPatEntUsoGen">Patrimonio Entregado al Uso General</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InmovInmat" id="celdaInmovInmat">Inmovilizaciones Inmateriales</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InmovMat" id="celdaInmovMat">Inmovilizaciones Materiales</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BienCesTemp" id="celdaBienCesTemp">Bienes en Régimen de Cesión Temporal</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BienAdscrip" id="celdaBienAdscrip">Bienes en Régimen de Adscripción</a></td>
											</tr>	
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BienEfectAGarant" id="celdaBienEfectAGarant">Bienes Afectos a Garantías</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InvGest" id="celdaInvGest">Inversiones Gestionadas (opcional)</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#PatrPublSuel" id="celdaPatrPublSuel">Patrimonio Público del Suelo</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#InvFin" id="celdaInvFin">Inversiones Financieras</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#Exist" id="celdaExist">Existencias (opcional)</a></td>
											</tr>											
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#Tes" id="celdaTes">Tesorería</a></td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#EstConcBanc" id="celdaEstConcBanc">Estado de Conciliación Bancaria</a></td>
											</tr>											
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#FondProp" id="celdaFondProp">Fondos Propios</a></td>
											</tr>
											<tr onclick="verMenu('InfEnd');">
												<td style="cursor: pointer;color:gold" class="celdaMenu">Información sobre el Endeudamiento<img src="triright.gif" id="InfEndFL" alt=">" />
													<div onclick="verMenu('InfEnd')" id="InfEnd">
													<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
															<tr onclick="verMenu('PasFinLCP')">
															<td style="cursor: pointer;color:gold" class="celdaMenu">Pasivos financieros a largo y corto plazo<img src="triright.gif" id="PasFinLCPFL" alt=">" />
																<div id="PasFinLCP" onclick="verMenu('InfEnd');verMenu('Mem')">
																	<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																		<tr onclick="verMenu('EstDeudCap');verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');">
																				<td style="cursor: pointer;color:gold" class="celdaMenu">Estado de la deuda. Capitales<img src="triright.gif" id="EstDeudCapFL" alt=">" />
																					<div onclick="verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');" id="EstDeudCap">
																						<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaCapNac" id="celdaEstDeudaCapNac">Deudas en moneda nacional</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaCapDistEur" id="celdaEstDeudaCapDistEur">Deudas en moneda distinta del euro</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																			<tr onclick="verMenu('EstDeudIntExp');verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');">
																				<td style="cursor: pointer;color:gold" class="celdaMenu">Estado de la deuda. Intereses explícitos
																					<img src="triright.gif" id="EstDeudIntExpFL" alt=">" />
																					<div	onclick="verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');" id="EstDeudIntExp">
																						<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntExpNac" id="celdaEstDeudaIntExpNac">Deudas en moneda nacional</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntExpDistEur" id="celdaEstDeudaIntExpDistEur">Deudas en moneda distinta del euro</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																			<tr onclick="verMenu('EstDeudIntImp');verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');">
																				<td style="cursor: pointer;color:gold" class="celdaMenu">Estado de la deuda. Intereses implícitos
																					<img src="triright.gif" id="EstDeudIntImpFL" alt=">" />
																					<div onclick="verMenu('PasFinLCP');verMenu('InfEnd');verMenu('Mem');" id="EstDeudIntImp">
																						<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntImpNac" id="celdaEstDeudaIntImpNac">Deudas en moneda nacional</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#EstDeudaIntImpDistEur" id="celdaEstDeudaIntImpDistEur">Deudas en moneda distinta del euro</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																	</table>
																</div>
															</td>
															</tr>
															<tr onclick="verMenu('OperIntFin')">
																<td style="cursor: pointer;color:gold" class="celdaMenu">Operaciones de Intercambio Financiero (opcional)<img src="triright.gif" id="OperIntFinFL" alt=">" />
																	<div id="OperIntFin" onclick="verMenu('InfEnd');verMenu('Mem')">
																		<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																			<tr>
																				<td class="celdaMenu"><a href="#ResOperIntFinDiv" id="celdaResOperIntFinDiv">Resultado de las Operaciones de Intercambio Financiero de Divisas (opcional)</a></td>
																			</tr>
																			<tr>
																				<td class="celdaMenu"><a href="#ResOperIntFinInter" id="celdaResOperIntFinInter">Resultado de las Operaciones de Intercambio Financiero de Intereses (opcional)</a></td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
															<tr>
																<td onclick="verMenu('InfEnd');verMenu('Mem')" class="celdaMenu"><a href="#AvConc" id="celdaAvConc">Avales Concedidos</a></td>
															</tr>
															<tr>
																<td onclick="verMenu('InfEnd');verMenu('Mem')" class="celdaMenu"><a href="#AvRein" id="celdaAvRein">Avales Reintegrados</a></td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr onclick="verMenu('InfOperOtrEntPubl')">
												<td style="cursor: pointer;color:gold" class="celdaMenu">Información de las operaciones por administración de recursos por cuenta de otros entes públicos (opcional)<img src="triright.gif" id="InfOperOtrEntPublFL" alt=">" />
												<div onclick="verMenu('Mem');" id="InfOperOtrEntPubl">
												<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
													<tr>
												<td class="celdaMenu"><a href="#DesProcGestRecAdmin" id="celdaDesProcGestRecAdmin">Desarrollo del Proceso de Gestión de los Recursos Administrados (opcional)</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#DesDevRecOtrEntPubl" id="celdaDesDevRecOtrEntPubl">Desarrollo de las Devoluciones de Recursos de Otros Entes Públicos (opcional)</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#OblDerGest" id="celdaOblDerGest">Obligaciones Derivadas de la Gestión (opcional)</a></td>
											</tr>
											<tr>
												<td class="celdaMenu"><a href="#CtaCorrOtrEntPubl" id="celdaCtaCorrOtrEntPubl">Cuentas Corrientes con Otros Entes Públicos (opcional)</a></td>
											</tr>
												</table>
											</div>
												</td>
											</tr>
											<tr onclick="verMenu('OperNoPresTes')">
												<td style="cursor: pointer; color:gold" class="celdaMenu">Operaciones No Presupuestarias de Tesorería<img src="triright.gif" id="OperNoPresTesFL" alt=">" />
													<div onclick="verMenu('Mem')" id="OperNoPresTes" >
														<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="400px">
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesDeud" id="celdaOperNoPresTesDeud">Deudores</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesAcr" id="celdaOperNoPresTesAcr">Acreedores</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesPartPendAppCobr" id="celdaOperNoPresTesPartPendAppCobr">Partidas Pendientes de Aplicación. Cobros</a></td>
															</tr>
															<tr>
																<td class="celdaMenu"><a href="#OperNoPresTesPartPendAppPag" id="celdaOperNoPresTesPartPendAppPag">Partidas Pendientes de Aplicación. Pagos</a></td>
															</tr>
														</table>
													</div>
												</td>
											</tr>											
											<tr>
												<td class="celdaMenu"><a href="#EstValRecDepList" id="celdaEstValRecDepList">Estado de Valores Recibidos en Depósito</a></td>
											</tr>
											<tr onclick="verMenu('InfPres')">
												<td style="cursor:pointer; color:gold" class="celdaMenu">Información presupuestaria<img src="triright.gif" id="InfPresFL" alt=">" />
													<div onclick="verMenu('InfPres')" id="InfPres">
													<table cellpadding="4" cellspacing="0" style="font-size:10pt; color:gold; FONT-FAMILY: Verdana, Arial" width="250px">
															<tr onclick="verMenu('EjCorr')">
															<td style="cursor:pointer; color:gold" class="celdaMenu">Ejercicio corriente<img src="triright.gif" id="EjCorrFL" alt=">" />
																<div id="EjCorr" onclick="verMenu('InfPres');verMenu('Mem')">
																	<table cellpadding="4" cellspacing="0" style="font-size: 10pt; color: gold; FONT-FAMILY: Verdana, Arial" width="250px">
																		<tr onclick="verMenu('PresGast');verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');">
																				<td style="cursor:pointer; color:gold" class="celdaMenu">Presupuesto de gastos
																					<img src="triright.gif" id="PresGastFL" alt=">" />
																					<div onclick="verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');" id="PresGast">
																						<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																							<tr>
																								<td class="celdaMenu"><a href="#ModCred" id="celdaModCred">Modificaciones de Crédito</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#RemCred" id="celdaRemCred">Remanentes de Crédito</a></td>
																							</tr>
																							<tr>
																								<td class="celdaMenu"><a href="#ProGast" id="celdaProGast">Proyectos de Gasto (opcional)</a></td>
																							</tr>																							
																							<tr>
																								<td class="celdaMenu"><a href="#AcrOpsPendAplPres" id="celdaAcrOpsPendAplPres">Acreedores por Operaciones Pendientes de Aplicar a Presupuesto</a></td>
																							</tr>
																						</table>
																					</div>
																				</td>
																			</tr>
																			<tr onclick="verMenu('PresIng');verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');">
																				<td style="cursor:pointer; color:gold" class="celdaMenu">Presupuesto de ingresos<img src="triright.gif" id="PresIngFL" alt=">" />
																						<div id="PresIng" onclick="verMenu('InfPres');verMenu('Mem')">
																							<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																							<tr onclick="verMenu('ProcGest');verMenu('PresIng');verMenu('InfPres');verMenu('Mem');">
																										<td style="cursor: pointer;color:gold" class="celdaMenu">Proceso de gestión
																											<img src="triright.gif" id="ProcGestFL" alt=">" />
																												<div onclick="verMenu('PresIng');verMenu('EjCorr');verMenu('InfPres');verMenu('Mem');" id="ProcGest">
																													<table cellpadding="4" cellspacing="0" class="tablaMenu" width="250px">
																														<tr>
																															<td class="celdaMenu"><a href="#DerAnul" id="celdaDerAnul">Derechos Anulados</a></td>
																														</tr>
																														<tr>
																															<td class="celdaMenu"><a href="#DerCanc" id="celdaDerCanc">Derechos Cancelados</a></td>
																														</tr>
																														<tr>
																															<td class="celdaMenu"><a href="#RecNet" id="celdaRecNet">Recaudación Neta</a></td>
																														</tr>
																													</table>
																												</div>
																										</td>
																								</tr>
																								<tr onclick="verMenu('EjCorr');">
																									<td class="celdaMenu"><a href="#DevIng" id="celdaDevIng">Devoluciones de Ingresos</a></td>
																								</tr>
																							</table>
																						</div>
																					</td>
																				</tr>
																			</table>
																</div>
															</td>
															</tr>
															<tr onclick="verMenu('EjCerr')">
															<td style="cursor: pointer; color:gold" class="celdaMenu">Ejercicios cerrados<img src="triright.gif" id="EjCerrFL" alt=">" />
																<div id="EjCerr" onclick="verMenu('InfPres');verMenu('Mem')">
																	<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																		<tr>
																			<td onclick="verMenu('InfPres');verMenu('Mem')" class="celdaMenu"><a href="#OblPresCerr" id="celdaOblPresCerr">Obligaciones de Presupuestos Cerrados</a></td>
																		</tr>
																		<tr onclick="verMenu('DerPresCerr');verMenu('EjCerr');verMenu('InfPres');verMenu('Mem');">
																<td style="cursor: pointer;color:gold" class="celdaMenu">Derechos a Cobrar de Presupuestos Cerrados<img src="triright.gif" id="DerPresCerrFL" alt=">" />
																	<div id="DerPresCerr" onclick="verMenu('EjCerr');verMenu('InfPres');verMenu('Mem')">
																		<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																			<tr>
																				<td class="celdaMenu"><a href="#DerPresCerrAnul" id="celdaDerPresCerrAnul">Derechos Anulados</a></td>
																			</tr>
																			<tr>
																				<td class="celdaMenu"><a href="#DerPresCerrCanc" id="celdaDerPresCerrCanc">Derechos Extinguidos</a></td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
																		</table>
																</div>
															</td>
															</tr>
															<tr onclick="verMenu('EjPost')">
															<td style="cursor: pointer;color:gold" class="celdaMenu">Ejercicios posteriores<img src="triright.gif" id="EjPostFL" alt=">" />
																<div id="EjPost" onclick="verMenu('EjPost');verMenu('InfPres');verMenu('Mem')">
																		<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																			<tr onclick="verMenu('EjPost');">
																				<td class="celdaMenu"><a href="#ComprGastEjPost" id="celdaComprGastEjPost">Compromisos de gasto con cargo a presupuestos de ejercicios posteriores</a></td>
																			</tr>
																		</table>
																	</div>
															</td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr onclick="verMenu('GastFinAfect')">
												<td style="cursor: pointer;color:gold" class="celdaMenu">Gastos con financiación afectada<img src="triright.gif" id="GastFinAfectFL" />
												<div onclick="verMenu('GastFinAfect')" id="GastFinAfect">
													<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
														<tr onclick="verMenu('GastFinAfect');verMenu('Mem')">
															<td class="celdaMenu"><a href="#DesvFin" id="celdaDesvFin">Desviaciones de financiación</a></td>
														</tr>
														<tr onclick="verMenu('InfUniGast')">
															<td style="cursor:pointer; color:gold" class="celdaMenu">Información por unidad de gasto<img src="triright.gif" id="InfUniGastFL" alt=">" />
																<div onclick="verMenu('InfUniGast')" id="InfUniGast">
																	<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="450px">
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DatGenIdent" id="celdaDatGenIdent">A) Datos generales indentificativos</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DatGenIdentAppPres" id="celdaDatGenIdentAppPres">A) Datos generales indentificativos (aplicaciones presupuestarias)</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestGast" id="celdaGestGast">B) Gestión del gasto</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestGastTot" id="celdaGestGastTot">B) Gestión del gasto (totales)</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestIngAfect" id="celdaGestIngAfect">C) Gestión de los ingresos afectados</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#GestIngAfectTot" id="celdaGestIngAfectTot">C) Gestión de los ingresos afectados (totales)</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DesvFinAgent" id="celdaDesvFinAgent">D) Desviaciones de financiación por agentes</a></td>
																		</tr>
																		<tr onclick="verMenu('InfUniGast');verMenu('GastFinAfect');verMenu('Mem')">
																			<td class="celdaMenu"><a href="#DesvFinAgentTot" id="celdaDesvFinAgentTot">D) Desviaciones de financiación por agentes (totales)</a></td>
																		</tr>
																	</table>
																</div>
															</td>
														</tr>
													</table>
												</div>
												</td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#RemTes" id="celdaRemTes">Remanente de tesorería</a></td>
											</tr>
											<tr onclick="verMenu('Ind')">
												<td style="cursor:pointer; color:gold" class="celdaMenu">Indicadores<img src="triright.gif" id="IndFL" alt=">" />
													<div onclick="verMenu('Ind')" id="Ind">
														<table cellpadding="4" cellspacing="0" style="font-size: 10pt; color: gold; FONT-FAMILY: Verdana, Arial" width="250px">
															<tr onclick="verMenu('IndFin');">
																<td style="cursor: pointer;color:gold" class="celdaMenu">Indicadores financieros y patrimoniales<img src="triright.gif" id="IndFinFL" alt=">" />
																	<div onclick="verMenu('IndFin')" id="IndFin">
																		<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																			<tr onclick="verMenu('Ind');verMenu('IndFin');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#LiqInm" id="celdaLiqInm">Liquidez inmediata</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndFin');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#SolvCortPlaz" id="celdaSolvCortPlaz">Solvencia a corto plazo</a></td>
																			</tr>
																			<tr onclick="verMenu('Ind');verMenu('IndFin');verMenu('Mem')">
																				<td class="celdaMenu"><a href="#EndHab" id="celdaEndHab">Endeudamiento por habitante</a></td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
															<tr onclick="verMenu('IndPres');">
																<td style="cursor: pointer;color:gold" class="celdaMenu">Indicadores presupuestarios<img src="triright.gif" id="IndPresFL">
																</img>
																	<div onclick="verMenu('IndPres')" id="IndPres">
																		<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																			<tr onclick="verMenu('IndPresCorr');">
																				<td style="cursor: pointer;color:gold" class="celdaMenu">Del presupuesto corriente<img src="triright.gif" id="IndPresCorrFL">
																					</img>
																						<div onclick="verMenu('IndPres');verMenu('Ind');verMenu('Mem');" id="IndPresCorr">
																							<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																								<tr>
																									<td class="celdaMenu"><a href="#EjecPresGast" id="celdaEjecPresGast">Ejecución del presupuesto de gastos</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#RealPag" id="celdaRealPag">Realización de pagos</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#GastHab" id="celdaGastHab">Gasto por habitante</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#InvHab" id="celdaInvHab">Inversión por habitante</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#EsfInv" id="celdaEsfInv">Esfuerzo inversor</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#PerMedPag" id="celdaPerMedPag">Periodo medio de pago</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#EjecPresIng" id="celdaEjecPresIng">Ejecución del presupuesto de ingresos</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#RealCobr" id="celdaRealCobr">Realización de cobros</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#Aut" id="celdaAut">Autonomía</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#AutFisc" id="celdaAutFisc">Autonomía fiscal</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#PerMedCobr" id="celdaPerMedCobr">Periodo medio de cobro</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#SupDefHab" id="celdaSupDefHab">Superávit (o déficit) por habitante</a></td>
																								</tr>
																								<tr>
																									<td class="celdaMenu"><a href="#ContrPresRemTes" id="celdaContrPresRemTes">Contribución del presupuesto al remanente de tesorería</a></td>
																								</tr>
																							</table>
																						</div>
																					</td>
																			</tr>
																			<tr onclick="verMenu('IndPresCerr');">
																				<td style="cursor: pointer;color:gold" class="celdaMenu">De presupuestos cerrados<img src="triright.gif" id="IndPresCerrFL" alt=">" />
																						<div onclick="verMenu('IndPres');verMenu('Ind');verMenu('Mem');" id="IndPresCerr">
																							<table cellpadding="4" cellspacing="0"  class="tablaMenu" width="250px">
																								<tr>
																									<td class="celdaMenu"><a href="#RealPagCerr" id="celdaRealPagCerr">Realización de pagos</a></td>
																								</tr>																								
																								<tr>
																									<td class="celdaMenu"><a href="#RealCobrCerr" id="celdaRealCobrCerr">Realización de cobros</a></td>
																								</tr>
																								
																							</table>
																						</div>
																				</td>
																			</tr>
																		</table>
																	</div>
																</td>
															</tr>
														</table>
													</div>
												</td>
											</tr>
											<tr>
												<td onclick="verMenu('Mem')" class="celdaMenu"><a href="#BalComp" id="celdaBalComp">Balance de comprobación</a></td>
											</tr>												
										</table>
									</div>
								</td>
							</tr>
						</table>
					</td>
				</tr>
				<tr width="100%" bgcolor="#ffffff">
					<td colspan="8" width="900">
						<br />
						<hr />
						<!-- Cabecera -->
						<!--<xsl:apply-templates select="//*[@tipo='I']"/>-->
						<!-- Listados -->
						<xsl:apply-templates select="//cgel-04-s-2008:Mem//*[@tipo='L']"/>
					</td>
				</tr>
			</table>
		</body>
	</html>
	</xsl:template>
	
	<!--Plantilla Frame Datos Entidad-->
	<xsl:template name="frame_datos" match="//*[@tipo='I']">
		<xsl:for-each select=".//*[@tipo='D']">
			<xsl:if test="@des='Nombre Entidad'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='Código MAP'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='CIF'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
			<xsl:if test="@des='Ejercicio'">
				<td style="border:none; background-color:#A5BEE7">
					<strong>
						<xsl:value-of select="@des" />:
					</strong>
					<xsl:value-of select="." />
				</td>
			</xsl:if>
		</xsl:for-each>
	</xsl:template>

	<!-- Plantilla Listados -->
	<xsl:template name="listado" match="//cgel-04-s-2008:Mem//*[@tipo='L']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<table cellpadding="4" width="100%">
			<tbody>
				<tr>
					<td>
						<h2 style="background-color:darkblue">
							<font color="gold">
								<a>
								<xsl:attribute name="name">
									<xsl:value-of select="local-name()"/>
								</xsl:attribute>
								<xsl:value-of select="@des"/>
								</a>
								<a href='javascript:VolverAlPrincipio()'><img src='ArrowUp.gif' align='absmiddle' alt='Volver al Principio'/></a>
								<!---Esto es el titulo del listado-->
							</font>
						</h2>
					</td>
				</tr>
			</tbody>
		</table>
		<br />
		<table cellspacing="0" cellpadding="4" width="900px" style="border-collapse:collapse">
			<tbody>
				<font face="verdana">
					<tr style="font-size:8pt" align="center">
						<td/>
						<td/>
						<xsl:for-each select=".//*[@tipo='C' and @des!='']">
							<!---Aqui se crean las cabeceras de las columnas-->
							<td style="border: solid; border-width:1; border-color:black" bgcolor="LightSteelBlue">
								<strong>
									<xsl:value-of select="translate(@des, $small, $CAPS)"/>
								</strong>
							</td>
						</xsl:for-each>
					</tr>
					<!-- Aplicar plantilla de detalle -->
					<xsl:apply-templates select=".//*[@tipo='D']"/>
					<!-- Aplicar plantilla de totales -->
					<xsl:call-template name="totales"/>
				</font>
			</tbody>
		</table>
		<br/>
		<br/>
	</xsl:template>
	<!-- Plantilla Detalles listados -->
	<xsl:template name="detalle" match="//*[@tipo='D']">
		<xsl:variable name="small" select="'abcdefghijklmnopqrstuvwxyzäöüèéóáíúñ'"/>
		<xsl:variable name="CAPS" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZÄÖÜÈÉÓÁÍÚÑ'"/>
		<tr style="font-size:8pt">
			<td/>
			<xsl:choose>
				<xsl:when test="@des!=''">
					<td style="border:solid; border-width:1; border-color:black">
					<!---Columnas con descripcion que no son cabeceras ni datos-->
						<strong>
							<xsl:value-of select="@des"/>
						</strong>
					</td>
				</xsl:when>
				<xsl:otherwise>
				<td width="0px"></td>
				</xsl:otherwise>
			</xsl:choose>
			<xsl:for-each select=".//*[@tipo='C']">
				<!---Aqui se crean las columnas con datos-->
				<xsl:choose>
				<!-- Tipo de Bien (Modelo Simplificado)  -->
					<xsl:when test="local-name()='TipoBien' and .='TERR'">
						<td style="border: solid; border-width:1px;border-color:black" align="left">Terrenos y bienes naturales</td>					
					</xsl:when>				
					<xsl:when test="local-name()='TipoBien' and .='CONS'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Construcciones</td>					
					</xsl:when>	
					<xsl:when test="local-name()='TipoBien' and .='INST'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Instalaciones técnicas</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='MAQYUTI'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Maquinaria y utillaje</td>					
					</xsl:when>														
					<xsl:when test="local-name()='TipoBien' and .='MOB'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Mobiliario</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='EQUINF'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Equipos para procesos de información</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='TRANS'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Elementos de transporte</td>					
					</xsl:when>						
					<xsl:when test="local-name()='TipoBien' and .='INMV'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Otro inmovilizado material</td>					
					</xsl:when>
					<!-- Otro tipos de bienes definidos para Patrimonio Entregado al Uso General -->
					<xsl:when test="local-name()='TipoBien' and .='INFR'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Infraestructuras y bienes destinados al uso general</td>					
					</xsl:when>
					<xsl:when test="local-name()='TipoBien' and .='BIEN'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Bienes comunales</td>					
					</xsl:when>
					<xsl:when test="local-name()='TipoBien' and .='PATR'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Bienes del Patrimonio histório, artístico y cultural</td>					
					</xsl:when>
				<!-- Tipos de deuda -->
					<xsl:when test="local-name()='TipDeud' and .='EMPR'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Empréstitos y otras emisiones análogas</td>					
					</xsl:when>		
					<xsl:when test="local-name()='TipDeud' and .='EMPRTES'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Empréstitos y otras emisiones análogas por operaciones de tesorería</td>					
					</xsl:when>	
					<xsl:when test="local-name()='TipDeud' and .='DEUD'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Deudas con entidades de crédito</td>					
					</xsl:when>							
					<xsl:when test="local-name()='TipDeud' and .='DEUDTES'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Deudas con entidades de crédito por Operaciones de Tesorería</td>					
					</xsl:when>							
					<xsl:when test="local-name()='TipDeud' and .='DEUDPUB'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Deudas con Entidades Públicas</td>					
					</xsl:when>		
					<xsl:when test="local-name()='TipDeud' and .='OTRDEUD'">
						<td style="border:solid; border-width:1px;border-color:black" align="left">Otras Deudas</td>					
					</xsl:when>
				<!-- Valor 0 => Poner decimales -->
					<xsl:when test=".=0">
						<td style="border:solid; border-width:1px;border-color:black" align="right">0,00</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')='NaN' or (format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')='')">
						<td style="border:solid; border-width:1px;border-color:black" align="left">
							<xsl:value-of select="concat(substring(translate(., $small, $CAPS),1,1),substring(translate(., $CAPS, $small),2))"/>
						</td>
					</xsl:when>
					<xsl:when test="format-number(., '###.##0,00', 'european')!='NaN' and substring-before(.,'.')!=''">
						<td style="border:solid; border-width:1px;border-color:black" align="right">
							<xsl:value-of select="format-number(., '###.##0,00', 'european')"/>
						</td>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</tr>
	</xsl:template>
	
	<!-- Plantilla totales -->
	<xsl:template name="totales">
			<xsl:for-each select=".//*[@tipo='T']">
			<tr style="font-size:8pt" align="right">
			<td/>
				<xsl:choose>
					<!--Inversiones destinadas al uso general-->
					<xsl:when test="local-name()='TotInvDestUsoGenDet'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SalIni,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:EntODot,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:AumTransfOTraspCuenta,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SalBajRed,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DismTransfOTraspCuenta,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SalFin,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Patrimonio entregado al uso general-->
					<xsl:when test="local-name()='TotPatEntUsoGenDet'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ValorBien,'###.##0,00','european')"/>
							</td>
						</xsl:when>
					<!--Bienes en Régimen de Cesión Temporal-->
					<xsl:when test="local-name()='TotBienCesTempDet'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="4" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ValorBien,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Bienes en Régimen de Adscripción-->
					<xsl:when test="local-name()='TotBienAdscripDet'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ValorBien,'###.##0,00','european')"/>
							</td>
					</xsl:when>					
					<!--Bienes Afectos a Garantías-->
					<xsl:when test="local-name()='TotBienEfectAGarantDet'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="3" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ImpGarant,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ValorBien,'###.##0,00','european')"/>
							</td>							
					</xsl:when>
					<!--Inversiones Gestionadas-->
					<xsl:when test="local-name()='TotInvGestDet'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SalIni,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:EntODot,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:AumTransfOTraspCuenta,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SalBajRed,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DismTransfOTraspCuenta,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SalFin,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Existencias-->
					<xsl:when test="local-name()='TotExistDet'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:PrecAdqCostProd,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ImpProvDepr,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Tesorería-->
					<xsl:when test="local-name()='TotTesDet'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="3" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SalIni,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Cobr,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pag,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SalFin,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Estado de conciliación bancaria-->
					<xsl:when test="local-name()='TotEstConcBancDet'">
						<td/>
						<td style="border:solid; border-width:1px; border-color:black" colspan="1" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SaldSegEntBanc,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:CobrContEntYNoBanc,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:PagContEntYNoBanc,'###.##0,00','european')"/>
							</td>							
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:CobrContBancYNoEnt,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:PagContBancYNoEnt,'###.##0,00','european')"/>
							</td>							
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SaldConc,'###.##0,00','european')"/>
							</td>
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:SaldSegEnt,'###.##0,00','european')"/>
							</td>			
							<td style="border:solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DifSald,'###.##0,00','european')"/>
							</td>											
					</xsl:when>
					<!--Capitales. Deudas en moneda nacional-->
					<xsl:when test="local-name()='TotEstDeudaCapNacDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend1EneLargPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend1EneCortPlaz,'###.##0,00','european')"/>
							</td>														
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend1EneTot,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Creac,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:AmortDism,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend31DicLargPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend31DicCortPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend31DicTot,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Capitales. Deudas en moneda distinta del euro-->
					<xsl:when test="local-name()='TotEstDeudaCapDistEurDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend1EneLargPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend1EneCortPlaz,'###.##0,00','european')"/>
							</td>														
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend1EneTot,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Creac,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DifCamb,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:AmortDism,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend31DicLargPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend31DicCortPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Pend31DicTot,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Intereses Explicitos. Deudas en moneda nacional-->
					<xsl:when test="local-name()='TotEstDeudaIntExpNacDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Dev1EneLargPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Dev1EneCortPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DevEj,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:VencEj,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:RectTrasp,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Dev31DicLargPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Dev31DicCortPlaz,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Intereses Explicitos. Deudas en moneda distinta del euro-->
					<xsl:when test="local-name()='TotEstDeudaIntExpDistEurDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Dev1EneLargPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Dev1EneCortPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DevEj,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:VencEj,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:RectTrasp,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DifCamb,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Dev31DicLargPlaz,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:Dev31DicCortPlaz,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Intereses Implicitos. Deudas en moneda nacional-->
					<xsl:when test="local-name()='TotEstDeudaIntImpNacDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ImpEmision,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black"/>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ImpReembolso,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:TotIntImp,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:BajYRect,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DevEjAnt,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DevEj,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:PendDev31Dic,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Intereses Implicitos. Deudas en moneda distinta del euro-->
					<xsl:when test="local-name()='TotEstDeudaIntImpDistEurDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
								<strong>
									<xsl:value-of select="@des"/>
								</strong>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ImpEmision,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black"/>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:ImpReembolso,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:TotIntImp,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:BajYRect,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DevEjAnt,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:DevEj,'###.##0,00','european')"/>
							</td>
							<td style="border: solid; border-width:1px; border-color:black">
									<xsl:value-of select="format-number(./cgel-04-s-2008:PendDev31Dic,'###.##0,00','european')"/>
							</td>
					</xsl:when>
					<!--Resultado de las Operaciones de Intercambio Financiero de Divisas-->
					<xsl:when test="local-name()='TotResOperIntFinDivDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:GastForm,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:IntDevDeud,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:IntDevAcr,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DifCamb,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ResCancAnt,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ResAcum,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Resultado de las Operaciones de Intercambio Financiero de Intereses-->
					<xsl:when test="local-name()='TotResOperIntFinInterDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:GastForm,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:IntDevDeud,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:IntDevAcr,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DifCamb,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ResCancAnt,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ResAcum,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Avales concedidos-->
					<xsl:when test="local-name()='TotAvConcDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="5" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Av1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:AvConcEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:AvCancEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Av31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Avales reintegrados-->
					<xsl:when test="local-name()='TotAvReinDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="1" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ImpRein,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black"/>
						<td style="border: solid; border-width:1px; border-color:black"/>
					</xsl:when>
					<!--Desarrollo del Proceso de Gestión de los Recursos Administrados-->
					<xsl:when test="local-name()='TotDesProcGestRecAdminDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:SalIniDerPendCobr,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerRecEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerAnul,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RecBrut,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RecDev,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RecLiq,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerCanc,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerPendCobr,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Desarrollo de las Devoluciones de Recursos de Otros Entes Públicos-->
					<xsl:when test="local-name()='TotDesDevRecOtrEntPublDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DevRecSalIniPendPag,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DevRecModSalIni,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DevRecEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DevRecTot,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PagEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendPag31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Obligaciones Derivadas de la Gestión-->
					<xsl:when test="local-name()='TotOblDerGestDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendPagSalIni,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendPagModSalIni,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendPagRecLiq,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendPagReint,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendPagTot,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PagRealiz,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PagPend31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Cuentas Corrientes con Otros Entes Públicos-->
					<xsl:when test="local-name()='TotCtaCorrOtrEntPublDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CargSalIniDeud,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CargPag,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CargTot,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DatSalIniAcr,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DatIng,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DatTot,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Sal31DicDeud,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Sal31DicAcr,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Deudores-->
					<xsl:when test="local-name()='TotOperNoPresTesDeudDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Sal1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ModSalIni,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CargRealizEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotDeud,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:AbRealizEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DeudPendCobr31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Acreedores-->
					<xsl:when test="local-name()='TotOperNoPresTesAcrDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Sal1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ModSalIni,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:AbRealizEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotAcr,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CargRealizEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:AcrPendPag31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Partidas Pendientes de Aplicación. Cobros-->
					<xsl:when test="local-name()='TotOperNoPresTesPartPendAppCobrDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CobrPendApp1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ModSalIni,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CobrRealizEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotCobrPendApp,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CobrAplicEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CobrPendApp31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Operaciones No Presupuestarias de Tesorería. Partidas Pendientes de Aplicación. Pagos-->
					<xsl:when test="local-name()='TotOperNoPresTesPartPendAppPagDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="3" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PagPendApp1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ModSalIni,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PagRealizEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotPagPendApp,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PagAplicEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PagPendApp31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Estado de Valores Recibidos en Depósito-->
					<xsl:when test="local-name()='TotEstValRecDepDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Sal1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ModSalIni,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DepRecEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotDepRec,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DepCanc,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DepPendDev31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Modificaciones de Crédito-->
					<xsl:when test="local-name()='TotModCredDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="6" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CredExtra,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:SuplCred,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:AmplCred,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TransfCredPos,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TransfCredNeg,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:IncRemCred,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CredGenIng,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:BajAnul,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:AjustProrrog,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotMod,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Remanentes de Crédito-->
					<xsl:when test="local-name()='TotRemCredDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="6" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RemCompIncorp,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RemCompNoIncorp,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RemNoCompIncorp,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RemNoCompNoIncorp,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Proyectos de Gasto-->
					<xsl:when test="local-name()='TotProGastDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="5" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:GastPrev,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:GastComp,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:OblRec1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:OblRecEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:OblRecTot,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:GastPendRealiz,'###.##0,00','european')"/>
						</td>
					</xsl:when>					
					<!--Acreedores por Operaciones Pendientes de Aplicar a Presupuesto-->
					<xsl:when test="local-name()='TotAcrOpsPendAplPresDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="7" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Importe,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Pagado,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Proceso de Gestión: Derechos Anulados-->
					<xsl:when test="local-name()='TotDerAnulDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:AnulLiq,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:AplazYFracc,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DevIng,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotDerAnul,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Proceso de Gestión: Derechos Cancelados-->
					<xsl:when test="local-name()='TotDerCancDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:CobrEsp,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Insolv,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:OtrCausas,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotDerCanc,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Proceso de Gestión: Recaudación Neta-->
					<xsl:when test="local-name()='TotRecNetDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RecTot,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DevIng,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RecNet,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Devoluciones de Ingresos-->
					<xsl:when test="local-name()='TotDevIngDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendPag1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ModSalIniYAnul,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:RecEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotDevRec,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Prescrip,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PagEj,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendPag31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Obligaciones de Presupuestos Cerrados-->
					<xsl:when test="local-name()='TotOblPresCerrDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" align="left" colspan="7">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:OblPendPag1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ModSalIniYAnul,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotObl,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Prescrip,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PagRealiz,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:OblPendPag31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Derechos a Cobrar de Presupuestos Cerrados. Derechos Anulados-->
					<xsl:when test="local-name()='TotDerPresCerrAnulDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" align="left" colspan="3">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendCobr1Ene,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ModSalIni,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerAnulLiq,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerAnulAplazYFracc,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotDerAnul,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Derechos a Cobrar de Presupuestos Cerrados. Derechos Extinguidos-->
					<xsl:when test="local-name()='TotDerPresCerrCancDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" align="left" colspan="3">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerCancCobrEsp,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerCancInsolv,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerCancPrescrip,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DerCancOtrCausas,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:TotDerCanc,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:Rec,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:PendCobr31Dic,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Compromisos de Gasto con Cargo a Presupuestos de Ejercicios Posteriores-->
					<xsl:when test="local-name()='TotComprGastEjPostsApp'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="7" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:ComprGast,'###.##0,00','european')"/>
						</td>
					</xsl:when>
					<!--Gastos con Financiación Afectada. Desviaciones de Financiación-->
					<xsl:when test="local-name()='TotDesvFinDet'">
						<td/>
						<td style="border: solid; border-width:1px; border-color:black" colspan="2" align="left">
							<strong>
								<xsl:value-of select="@des"/>
							</strong>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DesvEjPos,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DesvEjNeg,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DesvAcumPos,'###.##0,00','european')"/>
						</td>
						<td style="border: solid; border-width:1px; border-color:black">
								<xsl:value-of select="format-number(./cgel-04-s-2008:DesvAcumNeg,'###.##0,00','european')"/>
						</td>
					</xsl:when>
				</xsl:choose>
				</tr>
			</xsl:for-each>
	</xsl:template>
</xsl:stylesheet>
