<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-bas_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
   <xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Bas-2015.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='EjePpto']//xs:element[@name='CompPptosPosts']" />
      <xsl:variable name="tituloPag" select="$nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>
            
            <table border="1" cellspacing="0" cellpadding="4" style="width:100%">
               <tbody>
                  <tr>
                     <td class="cabecera">
                        AÑO<br />
                        PRESUPUESTO
                     </td>
                     <td class="cabecera">
                        CÓDIGO<br />
                        PROGRAMA
                     </td>
                     <td class="cabecera">
                        DESCRIPCIÓN<br />
                        PROGRAMA
                     </td>
                     <td class="cabecera">
                        CÓDIGO<br />
                        ECONÓMICA
                     </td>
                     <td class="cabecera">
                        DESCRIPCIÓN<br />
                        ECONÓMICA
                     </td>
                     <td class="cabecera">
                        COMPROMISOS DE GASTOS<br/>ADQUIRIDOS
                     </td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:EjePpto/n1:CompPptosPosts" />
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*[position()>1]"> <!-- El primer elemento es "Aplicable" -->
            <!-- Por cada hijo -->
            <tr>
               <xsl:choose>
                  <xsl:when test="name(.) = 'TotCompPptosPostsApp'">
                     <td  class="celdadatosder" colspan="5">
                        <span style="font-weight: bold;">
                           TOTAL
                        </span>
                     </td>                  
                  </xsl:when>
                  <xsl:when  test="name(.)!='TotCompPptosPostsApp'">
                     <td class="celdadatosizq"><xsl:value-of select="n1:AnioPpto"/></td>
                     <td class="celdadatosizq"><xsl:value-of select="n1:CodProg"/></td>
                     <td class="celdadatosizq"><xsl:value-of select="n1:DesProg"/></td>
                     <td class="celdadatosizq"><xsl:value-of select="n1:CodEcoG"/></td>
                     <td class="celdadatosizq"><xsl:value-of select="n1:DesEcoG"/></td>
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:CompGast, '###.##0,00', 'format1')"/></td>
            </tr>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>   
   
</xsl:stylesheet>
