﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-bas_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Bas-2015.xsd')" />
   <xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>

   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Tes']//xs:element[@name='TesDet']" />
      <xsl:variable name="tituloPag" select="$nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>

            <table border="1" cellspacing="0" cellpadding="4" style="width: 60%;">
               <tbody>
                  <tr>
                     <td class="cabecera" style="width: 50%;">
                        CONCEPTO
                     </td>
                     <td style="width: 10%;" class="cabecera" colspan="3">
                        IMPORTES
                     </td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:Tes/n1:TesDet" />
                     <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='Tes']//xs:element[@name='TesDet']"/>
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>

   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoSchema"></xsl:param>

      <xsl:for-each select="$nodoPadre/*">
         <tr>
            <xsl:variable name="nombre" select="name(.)" />
            <xsl:variable name="titulo" select="$nodoSchema//xs:element[@name=$nombre]//xs:documentation"></xsl:variable>
            <!-- nodo de datos -->
            <xsl:call-template name="titulo">
               <xsl:with-param name="texto" select="$titulo" />
            </xsl:call-template>

            <xsl:choose>
               <xsl:when test="substring($titulo,1,2) ='1.'">
                  <td class="celdadatosder">
                     &#160;
                  </td>
                  <td class="celdadatosder">
                     <xsl:value-of select="format-number(., '###.##0,00', 'format1')"/>
                  </td>
                  <td rowspan="9">&#160;</td>
               </xsl:when>
               <xsl:when test="substring($titulo,1,2) ='2.'">
                  <td class="celdadatosder">
                     &#160;
                  </td>
                  <td class="celdadatosder">
                     <xsl:value-of select="format-number(., '###.##0,00', 'format1')"/>
                  </td>
               </xsl:when>
               <xsl:when test="substring($titulo,1,2) ='I.'">
                  <td class="celdadatosder">
                     <xsl:value-of select="format-number(., '###.##0,00', 'format1')"/>
                  </td>
               </xsl:when>
               <xsl:when test="substring($titulo,1,2) ='II' or substring($titulo,1,1) ='3'">
                  <td class="celdadatosder">
                     <xsl:value-of select="format-number(., '###.##0,00', 'format1')"/>
                  </td>
               </xsl:when>
               <xsl:otherwise>
                  <td class="celdadatosder">
                     <xsl:value-of select="format-number(., '###.##0,00', 'format1')"/>
                  </td>
                  <td class="celdadatosder">
                     &#160;
                  </td>
               </xsl:otherwise>
            </xsl:choose>
         </tr>
      </xsl:for-each>
      
   </xsl:template>

   <xsl:template name="titulo">
      <xsl:param name="texto"></xsl:param>
     
         <xsl:choose>
            <xsl:when test="substring($texto,1,1) ='1' or substring($texto,1,1) ='2'">
               <td class="celdadatosizq" style="font-weight: bold;">
                  <xsl:value-of select="$texto" />
               </td>
            </xsl:when>
            <xsl:when test="substring($texto,1,2) ='I.'">
               <td class="celdadatosizq" colspan="2" style="font-weight: bold;">
                  <span><xsl:value-of select="$texto" /></span>
               </td>
            </xsl:when>
            <xsl:when test="substring($texto,1,2) ='II' or substring($texto,1,1) = '3'">
               <td class="celdadatosizq" colspan="3" style="font-weight: bold;">
                  <span>
                     <xsl:value-of select="$texto" />
                  </span>
               </td>
            </xsl:when>
            <xsl:otherwise>
               <td class="celdadatosizq">
                  <span>&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$texto" /></span>
               </td>
            </xsl:otherwise>
         </xsl:choose>
   
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>
