<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-bas_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Bas-2015.xsd')" />
   <xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>

   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='OpsNoPres']//xs:element[@name='Acr']" />
      <xsl:variable name="tituloPag" select="$nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="1" />
            </xsl:call-template>

            <table border="1" cellspacing="0" cellpadding="4" style="width: 100%;">
               <tbody>
                  <tr>
                     <td style="width: 30%;" class="cabecera">
                        CONCEPTO
                     </td>
                     <td style="width: 12%;" class="cabecera">
                        SALDO A 1<br/>DE ENERO
                     </td>
                     <td style="width: 12%;" class="cabecera">
                        RECTIFICACIONES<br/> Y BAJAS
                     </td>
                     <td style="width: 12%;" class="cabecera">
                        ABONOS<br/>DEL<br/>EJERCICIO
                     </td>
                     <td style="width: 12%;" class="cabecera">
                        TOTAL
                     </td>
                     <td style="width: 12%;" class="cabecera">
                        CARGOS<br/>DEL<br/>EJERCICIO
                     </td>
                     <td style="width: 12%;" class="cabecera">
                        SALDO A 31<br/>DE<br/>DICIEMBRE
                     </td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:OpsNoPres//n1:Acr" />
                     <xsl:with-param name="nodoSchema" select="$nodoSchemaActual"/>
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>

   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoSchema"></xsl:param>

      <xsl:for-each select="$nodoPadre/*[position()>1]"> <!-- El primer elemento es "Aplicable" -->
         <tr>
            <xsl:variable name="nombre" select="name(.)" />
            <xsl:variable name="titulo" select="$nodoSchema//xs:element[@name=$nombre]//xs:documentation"></xsl:variable>
            
            <!-- nodo de datos -->
            <xsl:call-template name="titulo">
               <xsl:with-param name="texto" select="$titulo" />
            </xsl:call-template>
            
            <td class="celdadatosder">
               <xsl:value-of select="format-number(n1:Sald1Ene, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number(n1:RectYBaj, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number(n1:AbEj, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number(n1:TotAcr, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number(n1:CargEj, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number(n1:Sald31Dic, '###.##0,00', 'format1')"/>
            </td>
         </tr>
      </xsl:for-each>
      
   </xsl:template>

   <xsl:template name="titulo">
      <xsl:param name="texto"></xsl:param>

      <xsl:choose>
         <xsl:when test="$texto='TOTAL'">
            <td class="celdadatosizq" style="font-weight:bold;">
               <xsl:value-of select="$texto" />
            </td>
         </xsl:when>
         <xsl:otherwise>
            <td class="celdadatosizq">
               <xsl:value-of select="$texto" />
            </td>
         </xsl:otherwise>
      </xsl:choose>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>
