﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-norm_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2015.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='ActFin']//xs:element[@name='InfRiesgos']//xs:element[@name='RiesgoTipoInteres']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>
            
            <table border="1" cellspacing="0" cellpadding="4">
               <tr>
                  <td class="cabecera"><span>CLASES DE ACTIVOS FINANCIEROS</span></td>
                  <td style="width: 10%;" class="cabecera">
                     <span>A TIPO DE INTERÉS<br/>FIJO</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>A TIPO DE INTERÉS<br/>VARIABLE</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>TOTAL</span>
                  </td>
               </tr>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:ActFin/n1:InfRiesgos/n1:RiesgoTipoInteres" />
                  <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='ActFin']//xs:element[@name='InfRiesgos']//xs:element[@name='RiesgoTipoInteres']"/>
               </xsl:call-template>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoSchema"></xsl:param>

      <xsl:for-each select="$nodoPadre/*[not(name()='Aplicable')]">
         <!-- Por cada hijo -->
         <xsl:if test="count(./n1:ATipoIntFijo) = 1">
            <xsl:variable name="nombre" select="name(.)" />
            <xsl:variable name="titulo" select="$nodoSchema//xs:element[@name=$nombre]//xs:documentation" />
            <xsl:choose>
               <xsl:when test="$nombre!='PorActFinTipoIntFijoOVarSobreTotal'">
                  <tr>
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;"><xsl:value-of select="$titulo" /></span>
                     </td>            
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number(n1:ATipoIntFijo, '###.##0,00', 'format1')"/></span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number(n1:ATipoIntVar, '###.##0,00', 'format1')"/></span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number(n1:Total, '###.##0,00', 'format1')"/></span>
                     </td>
                  </tr>
               </xsl:when>
               <xsl:otherwise>
                  <tr>
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;"><xsl:value-of select="$titulo" /></span>
                     </td>            
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number(n1:ATipoIntFijo, '###.##0,00', 'format1')"/>%</span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number(n1:ATipoIntVar, '###.##0,00', 'format1')"/>%</span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number(n1:Total, '###.##0,00', 'format1')"/>%</span>
                     </td>
                  </tr>
               </xsl:otherwise>
            </xsl:choose>
         </xsl:if>
      </xsl:for-each>
      
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
