﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-norm_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2015.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfCtaResulEcoPatriAct']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />
            <xsl:variable name="ejercicio" select="//n1:Entidad/n1:Ejercicio" />
            
            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>

            <table border="1" cellspacing="0" cellpadding="4">
               <tr>
                  <td style="width: 10%;" class="cabecera" colspan="2">
                     <span>GASTOS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera" colspan="3">
                     <span>EJERCICIO <xsl:value-of select="$ejercicio"/>
                  </span>
                  </td>
                  <td style="width: 10%;" class="cabecera" colspan="3">
                     <span>EJERCICIO <xsl:value-of select="$ejercicio - 1"/>
                  </span>
                  </td>
                  <td style="width: 10%;" class="cabecera" rowspan="2">
                     <span>INGRESOS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera" rowspan="2">
                     <span>EJERCICIO <xsl:value-of select="$ejercicio"/></span>
                  </td>
                  <td style="width: 10%;" class="cabecera" rowspan="2">
                     <span>EJERCICIO <xsl:value-of select="$ejercicio - 1"/></span>
                  </td>
               </tr>
               <tr>
                  <td style="width: 10%;" class="cabecera">
                     <span>CÓDIGO<br />GRUPO DE<br />PROGRAMAS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>DESCRIPCIÓN<br />GRUPO DE<br />PROGRAMAS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>PRESUPUESTARIOS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>NO PRESUPUESTARIOS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>TOTAL</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>PRESUPUESTARIOS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>NO PRESUPUESTARIOS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>TOTAL</span>
                  </td>
               </tr>               
               <xsl:call-template name="filas">
                  
                  <xsl:with-param name="nodoGastos" select="//n1:Memoria/n1:InfCtaResulEcoPatriAct/n1:Gastos" />
                  <xsl:with-param name="nodoIngresos" select="//n1:Memoria/n1:InfCtaResulEcoPatriAct/n1:Ingresos" />
                  <xsl:with-param name="totalElmGastos" select="count(//n1:Memoria/n1:InfCtaResulEcoPatriAct/n1:Gastos/n1:GrupoProg)" />
                  <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfCtaResulEcoPatriAct']"/>
               </xsl:call-template>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoSchema" />
      <xsl:param name="nodoGastos" />
      <xsl:param name="nodoIngresos" />
      <xsl:param name="totalElmGastos" />

      <!-- Ingresos tiene siempre 4 elementos, gastos es variable. recorreremos el que más elementos tenga. -->
      <xsl:if test="$totalElmGastos &gt; 2">
         <xsl:for-each select="$nodoGastos/n1:GrupoProg">
            <xsl:variable name="index" select="position()" />
            <xsl:variable name="IdIngreso" select="name($nodoIngresos/*[$index])" />
            
            <tr>
               <td class="celdadatoscentro" style="font-weight:bold;">
                  <span><xsl:value-of select="n1:CodPrograma"/></span>
               </td>
               <td class="celdadatoscentro" style="font-weight:bold;">
                  <span><xsl:value-of select="n1:DesPrograma"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:EjActual/n1:Pptarios, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:EjActual/n1:NoPptarios, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:EjActual/n1:Total, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:EjAnterior/n1:Pptarios, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:EjAnterior/n1:NoPptarios, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:EjAnterior/n1:Total, '###.##0,00', 'format1')"/></span>
               </td>
               <xsl:if test="$index &lt; 4">
                  <td class="celdadatosizd" style="font-weight:bold;">
                     <span><xsl:value-of select="$nodoSchema//xs:element[@name=$IdIngreso]//xs:documentation" /></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($nodoIngresos/*[$index]/n1:EjActual, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($nodoIngresos/*[$index]/n1:EjAnterior, '###.##0,00', 'format1')"/></span>
                  </td>
               </xsl:if>
               <xsl:if test="$index &gt; 3">
                  <td class="celdadatosizd" colspan="3">&#160;</td>
               </xsl:if>
            </tr>         
         </xsl:for-each>
      </xsl:if>
      <xsl:if test="$totalElmGastos &lt; 3">
         <xsl:for-each select="$nodoIngresos/*">
            <xsl:variable name="index" select="position()" />
            <xsl:variable name="IdIngreso" select="name(.)" />
            
            <!-- No entramos en el elemento "TOTAL" -->
            <xsl:if test="$index &lt; count($nodoIngresos/*)">
               <tr>
                  <xsl:if test="$index &lt;= $totalElmGastos">
                     <td class="celdadatoscentro" style="font-weight:bold;">
                        <span><xsl:value-of select="$nodoGastos/*[$index]/n1:CodPrograma"/></span>
                     </td>
                     <td class="celdadatosizq" style="font-weight:bold;">
                        <span><xsl:value-of select="$nodoGastos/*[$index]/n1:DesPrograma"/></span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number($nodoGastos/*[$index]/n1:EjActual/n1:Pptarios, '###.##0,00', 'format1')"/></span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number($nodoGastos/*[$index]/n1:EjActual/n1:NoPptarios, '###.##0,00', 'format1')"/></span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number($nodoGastos/*[$index]/n1:EjActual/n1:Total, '###.##0,00', 'format1')"/></span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number($nodoGastos/*[$index]/n1:EjAnterior/n1:Pptarios, '###.##0,00', 'format1')"/></span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number($nodoGastos/*[$index]/n1:EjAnterior/n1:NoPptarios, '###.##0,00', 'format1')"/></span>
                     </td>
                     <td class="celdadatosder">
                        <span><xsl:value-of select="format-number($nodoGastos/*[$index]/n1:EjAnterior/n1:Total, '###.##0,00', 'format1')"/></span>
                     </td>
                  </xsl:if>
                  <xsl:if test="$index &gt;  $totalElmGastos">
                     <td class="celdadatosizd" colspan="8">&#160;</td>
                  </xsl:if>
                  <td class="celdadatosizd" style="font-weight:bold;">
                     <span>
                        <xsl:value-of select="$nodoSchema//xs:element[@name=$IdIngreso]//xs:documentation" />
                     </span>
                  </td>
                  <td class="celdadatosder">
                     <span>
                        <xsl:value-of select="format-number($nodoIngresos/*[$index]/n1:EjActual, '###.##0,00', 'format1')"/>
                     </span>
                  </td>
                  <td class="celdadatosder">
                     <span>
                        <xsl:value-of select="format-number($nodoIngresos/*[$index]/n1:EjAnterior, '###.##0,00', 'format1')"/>
                     </span>
                  </td>
               </tr>  
            </xsl:if>
         </xsl:for-each>
      </xsl:if>      
      <tr>
         <td class="celdadatosder" style="font-weight:bold;" colspan="2">
            <span>TOTAL</span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoGastos/n1:Total/n1:EjActual/n1:Pptarios, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoGastos/n1:Total/n1:EjActual/n1:NoPptarios, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoGastos/n1:Total/n1:EjActual/n1:Total, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoGastos/n1:Total/n1:EjAnterior/n1:Pptarios, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoGastos/n1:Total/n1:EjAnterior/n1:NoPptarios, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoGastos/n1:Total/n1:EjAnterior/n1:Total, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatoscentro" style="font-weight:bold;">
            <span>TOTAL</span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoIngresos/n1:Total/n1:EjActual, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoIngresos/n1:Total/n1:EjAnterior, '###.##0,00', 'format1')"/></span>
         </td>
       </tr>
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>