<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-norm_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2015.xsd')" />
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   
   <xsl:template match="/">
      
	<xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfPresupuestaria']//xs:element[@name='AcreeOpeDevengadas']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="3" />
            </xsl:call-template>
            
            <table style="width: 100%">
               <tr>
                  <td class="cabecera" width="20%">CUENTA</td>
                  <td class="cabecera" width="60%">DESCRIPCIÓN</td>
                  <td class="cabecera" width="20%">IMPORTE</td>
               </tr>
               
			  <xsl:call-template name="filas">
				 <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:InfPresupuestaria/n1:AcreeOpeDevengadas" />
				 <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfPresupuestaria']//xs:element[@name='AcreeOpeDevengadas']"/>
				 <xsl:with-param name="nivel" select="0"/>
			  </xsl:call-template>
               <!-- TOTAL -->
               <tr>
                  <td class="celdadatosder" colspan="2">
                     <span style="font-weight: bold;">TOTAL</span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(//n1:Memoria/n1:InfPresupuestaria/n1:AcreeOpeDevengadas/n1:Total/n1:Importe, '###.##0,00', 'format1')"/></span>
                  </td>
               </tr>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/n1:Cuenta">
         <tr>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:NumCuenta"/></span>
            </td>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:Descripcion"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:Importe, '###.##0,00', 'format1')"/></span>
            </td>
         </tr>
      </xsl:for-each>

   </xsl:template>
   
   <xsl:template name="titulo">
      <xsl:param name="texto"></xsl:param>
     
         <xsl:choose>
            <xsl:when test="starts-with($texto, 'I') or starts-with($texto, 'V')">
               <td class="celdadatosizq" colspan="2">
                  <span>&#160;&#160;&#160;<xsl:value-of select="$texto" /></span>
               </td>
            </xsl:when>
            <xsl:when test="number(substring($texto,1,1))">
               <td class="celdadatosizq">
                  <span>&#160;&#160;&#160;<xsl:value-of select="$texto" /></span>
               </td>
            </xsl:when>
            <xsl:otherwise>
               <td class="celdadatosizq">
                  <span>&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$texto" /></span>
               </td>
            </xsl:otherwise>
         </xsl:choose>
   
   </xsl:template>   

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
