﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-simp_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2015.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='OperAdmRecurCtaOtrEntPub']//xs:element[@name='ObliDerivGest']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="3" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera" colspan="2">ENTE TITULAR</td>
                  <td class="cabecera" colspan="2">CONCEPTO</td>
                  <td class="cabecera" rowspan="2">
                     <span>
                        PENDIENTE DE<br />
                        PAGO A 1 DE<br/>
                        ENERO<br/>
                     </span>
                  </td>
                  <td class="cabecera" rowspan="2">
                     MODIFICACIONES<br />
                     SALDO INICIAL
                  </td>
                  <td class="cabecera" rowspan="2">
                     RECAUDACIÓN<br />
                     LIQUIDA
                  </td>
                  <td class="cabecera" rowspan="2">
                     REINTEGROS
                  </td>
                  <td class="cabecera" rowspan="2">
                     TOTAL A<br />
                     PAGAR
                  </td>
                  <td class="cabecera" rowspan="2">
                     PAGOS<br />
                     REALIZADOS
                  </td>
                  <td class="cabecera" rowspan="2">
                     PENDIENTE DE<br />
                     PAGO A 31 DE<br />
                     DICIEMBRE
                  </td>
               </tr>
               <tr>
                  <td class="cabecera">NIF</td>
                  <td class="cabecera">
                     <span>DENOMINACIÓN</span>
                  </td>
                  <td class="cabecera">
                     CÓDIGO
                  </td>
                  <td class="cabecera">
                     DESCRIPCIÓN
                  </td>
               </tr>
               <xsl:variable name="padre" select="//n1:Memoria/n1:OperAdmRecurCtaOtrEntPub/n1:ObliDerivGest" />
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="$padre" />
               </xsl:call-template>
               <!-- TOTAL -->
               <tr>
                  <td class="celdadatosder" colspan="4">
                     <span style="font-weight: bold;">TOTAL</span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PendPag1Ene, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ModifSaldIni, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:RecauLiq, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:Reintegros, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:TotPagar, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PagRealizados, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:PendPago31Dic, '###.##0,00', 'format1')"/></span>
                  </td>
               </tr>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre" />
      <xsl:for-each select="$nodoPadre/*">
         <!-- Por cada hijo -->
         <xsl:if test="count(./n1:NIF) = 1">
            
            <xsl:variable name="nifEnte" select="n1:NIF" />
            <xsl:variable name="nombreEnte" select="n1:Nombre" />
            <xsl:variable name="totFilas" select="count(./*[name(.)='Concepto'])" />
            
            <xsl:for-each select="./*[name(.)='Concepto']">
               <tr>
                  <xsl:if test="position() = 1">
                     <td class="celdadatosizq" rowspan="{$totFilas}">
                        <span><xsl:value-of select="$nifEnte" /></span>
                     </td>
                     <td class="celdadatosizq" rowspan="{$totFilas}">
                        <span><xsl:value-of select="$nombreEnte" /></span>
                     </td>
                  </xsl:if>
                  <!--<xsl:if test="position() &gt; 1">
                     <td colspan="2">&#160;</td>                     
                  </xsl:if>-->
                  <td class="celdadatosizq">
                     <span><xsl:value-of select="n1:Id" /></span>
                  </td>
                  <td class="celdadatosizq">
                     <span><xsl:value-of select="n1:Descripcion" /></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:PendPag1Ene, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:ModifSaldIni, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:RecauLiq, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:Reintegros, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:TotPagar, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:PagRealizados, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number(n1:PendPago31Dic, '###.##0,00', 'format1')"/></span>
                  </td>
               </tr>
            </xsl:for-each>
            <tr>
               <!-- TOTAL ENTE -->
               <td class="celdadatosder" colspan="4">
                  <span style="font-weight: bold;">TOTAL <xsl:value-of select="$nombreEnte"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:PendPag1Ene, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:ModifSaldIni, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:RecauLiq, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:Reintegros, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:TotPagar, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:PagRealizados, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:Total/n1:PendPago31Dic, '###.##0,00', 'format1')"/></span>
               </td>
            </tr>
         </xsl:if>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>
