﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-simp_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2015.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='PasFin']//xs:element[@name='InfDeudas']//xs:element[@name='ResDeudas']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />
            <xsl:variable name="ejercicio" select="//n1:Entidad/n1:Ejercicio" />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>

            <table style="width:100%;" border="1" cellspacing="0" cellpadding="4">
               <tr>
                  <td rowspan="3" class="cabecera">IDENTIFICACIÓN<br/>DEUDA</td>
                  <td colspan="6" class="cabecera">LARGO PLAZO</td>
                  <td colspan="6" class="cabecera">CORTO PLAZO</td>
                  <td colspan="2" class="cabecera" rowspan="2">TOTAL</td>
               </tr>
               <tr>
                  <td colspan="2" class="cabecera">
                     OBLIGACIONES Y
                     <br/>
                     OTROS VALORES
                     <br/>
                     NEGOCIABLES
                  </td>
                  <td colspan="2" class="cabecera">
                     DEUDAS CON
                     <br/>
                     ENTIDADES DE
                     <br/>
                     CRÉDITO
                  </td>
                  <td colspan="2" class="cabecera">
                     OTRAS
                     <br/>
                     DEUDAS
                  </td>
                  <td colspan="2" class="cabecera">
                     OBLIGACIONES Y
                     <br/>
                     OTROS VALORES
                     <br/>
                     NEGOCIABLES
                  </td>
                  <td colspan="2" class="cabecera">
                     DEUDAS CON
                     <br/>
                     ENTIDADES DE
                     <br/>
                     CRÉDITO
                  </td>
                  <td colspan="2" class="cabecera">
                     OTRAS
                     <br/>
                     DEUDAS
                  </td>
               </tr>
               <tr>
                  <td class="cabecera"><xsl:value-of select="$ejercicio"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio - 1"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio - 1"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio - 1"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio - 1"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio - 1"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio - 1"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio"/></td>
                  <td class="cabecera"><xsl:value-of select="$ejercicio - 1"/></td>
               </tr>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:PasFin/n1:InfDeudas/n1:ResDeudas" />
                  <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='Memoria']//xs:element[@name='PasFin']//xs:element[@name='ResDeudas']"/>
               </xsl:call-template>
               <tr>
                  <td class="celdadatosder" style="font-weight: bold;">TOTAL</td>
                  <xsl:for-each select="//n1:Memoria/n1:PasFin/n1:InfDeudas/n1:ResDeudas/n1:Total/*">
                        <xsl:call-template name="datos">
                           <xsl:with-param name="nodo" select="." />
                        </xsl:call-template>
                  </xsl:for-each>
               </tr>
            </table>
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoSchema"></xsl:param>

      <xsl:for-each select="$nodoPadre/*[not(name()='Aplicable') and not(name()='Total')]">
         <tr>
            <xsl:variable name="nombre" select="n1:IdDeuda" />
            <td><xsl:value-of select="$nombre" /></td>
            <xsl:call-template name="datos">
               <xsl:with-param name="nodo" select="." />
            </xsl:call-template>
         </tr>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="datos">
      <xsl:param name="nodo" />
      <xsl:for-each select="$nodo/*[not(name()='Aplicable')]">
         <xsl:choose>
            <xsl:when test="name(.)='EjActual' or name(.)='EjAnterior'">
               <td class="celdadatosder"><xsl:value-of select="format-number(., '###.##0,00', 'format1')"/></td>
            </xsl:when>
            <xsl:otherwise>
               <xsl:call-template name="datos">
                  <xsl:with-param name="nodo" select="."  />
               </xsl:call-template>
            </xsl:otherwise>
         </xsl:choose>
      </xsl:for-each>            
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
</xsl:stylesheet>