﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="http://www.pap.meh.es/ficherosxsd/BASICAL_cgel-simp_2015-01-01"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2015.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='PasFin']//xs:element[@name='RiesgoTipoCambio']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="3" />
            </xsl:call-template>

            <table border="1" cellspacing="0" cellpadding="4">
               <tr>
                  <td style="width: 10%;" class="cabecera">
                     <span>MONEDAS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>OBLIGACIONES Y<br/>OTROS VALORES<br/>NEGOCIABLES</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>DEUDAS CON<br />ENTIDADES DE<br />CREDITO</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>OTRAS<br />DEUDAS</span>
                  </td>
                  <td style="width: 10%;" class="cabecera">
                     <span>TOTAL</span>
                  </td>
               </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:PasFin/n1:RiesgoTipoCambio" />
                  </xsl:call-template>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>

      <xsl:for-each select="$nodoPadre//n1:Moneda">
         <tr>
            <td class="celdadatosizq" style="font-weight:bold;">
               <span><xsl:value-of select="n1:Nombre"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ObliYOtrosValNeg, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:DeudaEntCred, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:OtrasDeudas, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:Total, '###.##0,00', 'format1')"/></span>
            </td>
         </tr>         
      </xsl:for-each>
      
      <tr>
         <td class="celdadatosizq" style="font-weight:bold;">
            <span><xsl:value-of select="$nodoPadre/n1:Total/n1:Nombre"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:Total/n1:ObliYOtrosValNeg, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:Total/n1:DeudaEntCred, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:Total/n1:OtrasDeudas, '###.##0,00', 'format1')"/></span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:Total/n1:Total, '###.##0,00', 'format1')"/></span>
         </td>
       </tr>
      <tr>
         <td class="celdadatosder" style="font-weight:bold;" colspan="4">
            <span>% DEUDA EN MONEDA DISTINTA DEL EURO SOBRE DEUDA TOTAL</span>
         </td>
         <td class="celdadatosder">
            <span><xsl:value-of select="format-number($nodoPadre/n1:PorDeudMonedaNoEuroDeudTot, '###.##0,00', 'format1')"/>%</span>
         </td>
       </tr> 
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
</xsl:stylesheet>
