<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/BASICAL_Cuenta-Norm-2019"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">
   
   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2019.xsd')" />
   
   <xsl:template match="/">
      
      <xsl:variable name="tituloPag" select="$schema//xs:element[@name='Entidad']//xs:documentation" />
      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />
            
            <h1>
               <xsl:value-of select="$tituloPag" />
            </h1>
            <table border="1" cellpadding="4px" cellspacing="0px">
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>Nombre Entidad</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:NomEnt" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>Código MAP</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:CodEnt" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>NIF</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:CIF" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>Población a 1 de Enero</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:Pob" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>Ejercicio</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:Ejercicio" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>Fecha de aprobación definitiva del Presupuesto</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:FAprPres" /></td>
               </tr>
               <tr>
                  <td class="cabecera" style="text-align:left;"><span>Fecha de aprobación de la Cuenta General</span></td>
                  <td><xsl:value-of select="//n1:Entidad/n1:FAprCtaGral" /></td>
               </tr>
            </table>
         </body>
      </html>
   </xsl:template>

</xsl:stylesheet>
