﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/BASICAL_Cuenta-Norm-2019"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Norm-2019.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfPresupuestaria']//xs:element[@name='EjecProyGasto']//xs:element[@name='ResumenEjec']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>
           
            <table style="width: 100%">
               <tr>
                  <td class="cabecera" rowspan="2"><span>CÓDIGO<br/>PROYECTO</span></td>
                  <td class="cabecera" rowspan="2"><span>DENOMINACIÓN</span></td>
                  <td class="cabecera" rowspan="2"><span>AÑO INICIO</span></td>
                  <td class="cabecera" rowspan="2"><span>DURACIÓN</span></td>
                  <td class="cabecera" rowspan="2"><span>GASTO<br/>PREVISTO</span></td>
                  <td class="cabecera" rowspan="2"><span>GASTO<br/>COMPROMETIDO</span></td>
                  <td class="cabecera" colspan="3"><span>OBLIGACIONES RECONOCIDAS</span></td>
                  <td class="cabecera" rowspan="2"><span>GASTO<br/>PENDIENTE DE<br/>REALIZAR</span></td>
                  <td class="cabecera" rowspan="2"><span>FINANCIACIÓN<br/>AFECTADA</span></td>
               </tr>
               <tr>
                  <td class="cabecera"><span>A 1 DE ENERO</span></td>
                  <td class="cabecera"><span>EN EL<br/>EJERCICIO</span></td>
                  <td class="cabecera"><span>TOTAL</span></td>
               </tr>
               <xsl:variable name="padre" select="//n1:Memoria/n1:InfPresupuestaria/n1:EjecProyGasto/n1:ResumenEjec" />
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="$padre" />
               </xsl:call-template>
               <!-- TOTAL -->
               <tr>
                  <td class="celdadatosder" colspan="4">
                     <span style="font-weight: bold;">TOTAL</span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:GastoPrev, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:GastoComp, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ObliReconA1Ene, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ObliReconEnEje, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:ObliReconTotal, '###.##0,00', 'format1')"/></span>
                  </td>
                  <td class="celdadatosder">
                     <span><xsl:value-of select="format-number($padre/n1:Total/n1:GastoPendRealiz, '###.##0,00', 'format1')"/></span>
                  </td>  
                  <td class="celdadatosizq">
                     <span><xsl:value-of select="$padre/n1:Total/n1:FinanAfect"/></span>
                  </td>  
               </tr>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/n1:Proyecto">
         <tr>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:CodProy" /></span>
            </td>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:Denominacion" /></span>
            </td>
            <td class="celdadatoscentro">
               <span><xsl:value-of select="n1:AnioIni" /></span>
            </td>
            <td class="celdadatoscentro">
               <span><xsl:value-of select="n1:Duracion" /></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:GastoPrev, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:GastoComp, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ObliReconA1Ene, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ObliReconEnEje, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ObliReconTotal, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:GastoPendRealiz, '###.##0,00', 'format1')"/></span>
            </td>  
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:FinanAfect"/></span>
            </td>  
         </tr>
      </xsl:for-each>
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>
