﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/BASICAL_Cuenta-Simp-2019"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2019.xsd')" />
   <xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>

   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfPresupuestaria']//xs:element[@name='RemanenteTesoreria']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="3" />
            </xsl:call-template>

            <xsl:variable name="ejercicio" select="//n1:Entidad/n1:Ejercicio" />
            <table border="1" cellspacing="0" cellpadding="4">
               <tbody>
                  <tr>
                     <td class="cabecera">
                        COMPONENTES
                     </td>
                     <td style="width: 10%;" class="cabecera" colspan="2">
                        <span>
                           <xsl:value-of select="$ejercicio"/>
                        </span>
                     </td>
                     <td style="width: 10%;" class="cabecera" colspan="2">
                        <span>
                           <xsl:value-of select="$ejercicio -1"/>
                        </span>
                     </td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:InfPresupuestaria/n1:RemanenteTesoreria" />
                     <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='Memoria']//xs:element[@name='InfPresupuestaria']//xs:element[@name='RemanenteTesoreria']"/>
                     <xsl:with-param name="nivel" select="0"/>
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoSchema"></xsl:param>
      <xsl:param name="nivel"></xsl:param>
      <xsl:param name="nombre"></xsl:param>

      <xsl:if test="count($nodoPadre/n1:EjActual) &gt; 0">
         <xsl:variable name="titulo" select="$nodoSchema[@name=$nombre]//xs:documentation"></xsl:variable>
         <!-- Por cada hijo -->
         <tr>
            <!-- nodo de datos -->
            <xsl:call-template name="titulo">
               <xsl:with-param name="texto" select="$titulo" />
            </xsl:call-template>

            <xsl:choose>
               <xsl:when test="$nivel &lt;= 1">
                  <xsl:choose>
                     <xsl:when test="substring($titulo,1,2)='I.'">
                        <td class="celdadatosder" style="width: 15%">
                           <xsl:value-of select="format-number($nodoPadre/n1:EjActual, '###.##0,00', 'format1')"/>
                        </td>
                        <td class="celdadatosder" style="width: 15%" rowspan="4">
                           &#160;
                        </td>
                        <td class="celdadatosder" style="width: 15%">
                           <xsl:value-of select="format-number($nodoPadre/n1:EjAnterior, '###.##0,00', 'format1')"/>
                        </td>
                     </xsl:when>
                     <xsl:when test="starts-with($titulo, 'I')">
                        <td class="celdadatosder" style="width: 15%">
                           <xsl:value-of select="format-number($nodoPadre/n1:EjActual, '###.##0,00', 'format1')"/>
                        </td>
                        <td class="celdadatosder" style="width: 15%">
                           <xsl:value-of select="format-number($nodoPadre/n1:EjAnterior, '###.##0,00', 'format1')"/>
                        </td>
                     </xsl:when>
                     <xsl:otherwise>
                        <td class="celdadatosder" style="width: 15%">
                           &#160;
                        </td>
                        <td class="celdadatosder" style="width: 15%">
                           <xsl:value-of select="format-number($nodoPadre/n1:EjActual, '###.##0,00', 'format1')"/>
                        </td>
                        <td class="celdadatosder" style="width: 15%">
                           &#160;
                        </td>
                        <td class="celdadatosder" style="width: 15%">
                           <xsl:value-of select="format-number($nodoPadre/n1:EjAnterior, '###.##0,00', 'format1')"/>
                        </td>                        
                     </xsl:otherwise>
                  </xsl:choose>
               </xsl:when>
               <xsl:otherwise>
                  <td class="celdadatosder" style="width: 15%">
                     <xsl:value-of select="format-number($nodoPadre/n1:EjActual, '###.##0,00', 'format1')"/>
                  </td>
                  <td class="celdadatosder" style="width: 15%">
                     &#160;
                  </td>
                  <td class="celdadatosder" style="width: 15%">
                     <xsl:value-of select="format-number($nodoPadre/n1:EjAnterior, '###.##0,00', 'format1')"/>
                  </td>
                  <td class="celdadatosder" style="width: 15%">
                     &#160;
                  </td>
               </xsl:otherwise>
            </xsl:choose>
         </tr>
      </xsl:if>
      
      <xsl:for-each select="$nodoPadre/*">
         <xsl:call-template name="filas">
            <xsl:with-param name="nodoPadre" select="." />
            <xsl:with-param name="nodoSchema" select="$nodoSchema//xs:element[position()]"/>
            <xsl:with-param name="nivel" select="$nivel+1" />
            <xsl:with-param name="nombre" select="name(.)" />
         </xsl:call-template>
      </xsl:for-each>
      
   </xsl:template>

   <xsl:template name="titulo">
      <xsl:param name="texto"></xsl:param>
     
         <xsl:choose>
            <xsl:when test="starts-with($texto, 'I') or starts-with($texto, 'V')">
               <td class="celdadatosizq" colspan="2">
                  <span>&#160;&#160;&#160;<xsl:value-of select="$texto" /></span>
               </td>
            </xsl:when>
            <xsl:when test="number(substring($texto,1,1))">
               <td class="celdadatosizq">
                  <span>&#160;&#160;&#160;<xsl:value-of select="$texto" /></span>
               </td>
            </xsl:when>
            <xsl:otherwise>
               <td class="celdadatosizq">
                  <span>&#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$texto" /></span>
               </td>
            </xsl:otherwise>
         </xsl:choose>
   
   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>

</xsl:stylesheet>
