﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/BASICAL_Cuenta-Simp-2019"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-Simp-2019.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='PasFin']//xs:element[@name='InfDeudas']//xs:element[@name='DeudasCostAmort']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />
      
      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="4" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td rowspan="2" class="cabecera" style="vertical-align: bottom">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">IDENTIFICACIÓN</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">DEUDA</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td rowspan="2" class="cabecera" style="vertical-align: bottom">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">T.I.E</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td colspan="2" class="cabecera">
                     DEUDA AL 1 ENERO
                  </td>
                  <td colspan="2" class="cabecera">
                     CREACIONES
                  </td>
                  <td colspan="2" class="cabecera">
                     INTERESES DEVENGADOS SEGÚN
                     T.I.E.&#160;
                  </td>
                  <td class="cabecera" rowspan="2" style="vertical-align:bottom;">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">INTERESES</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">CANCELADOS</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(7)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td colspan="2" class="cabecera">
                     DIFERENCIAS
                     <br />
                     DE CAMBIO
                  </td>
                  <td colspan="2" class="cabecera">
                     DISMINUCIONES
                  </td>
                  <td colspan="2" class="cabecera">
                     DEUDA AL 31
                     <br />
                     DICIEMBRE
                  </td>
               </tr>
               <tr>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">COSTE</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">AMORTIZADO</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(1)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">INTERESES</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">EXPLÍCITOS</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(2)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">EFECTIVO</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(3)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">GASTOS</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(4)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">EXPLICITOS</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(5)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">RESTO</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(6)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">DEL COSTE</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">AMORTIZADO</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(8)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">DE</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">INTERESES</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">EXPLÍCITOS</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(9)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">VALOR</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">CONTABLE</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(10)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">RESULTADO</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(11)</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">COSTE</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">AMORTIZADO</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(12)=1+3-4</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">+6+8-10</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
                  <td class="cabecera">
                     <table style="width:100%">
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">INTERESES</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">EXPLÍCITOS</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">(13)=2+5</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">-7+9</td>
                        </tr>
                        <tr>
                           <td class="cabeceraSinBorde">&#160;</td>
                        </tr>
                     </table>
                  </td>
               </tr>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:PasFin/n1:InfDeudas/n1:DeudasCostAmort" />
               </xsl:call-template>
            </table>
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>

      <xsl:for-each select="$nodoPadre/*[not(name()='Aplicable')]">
         <!-- Por cada hijo -->
         <xsl:if test="count(./n1:IdDeuda) = 1">
            <tr>
               <td class="celdadatosizq">
                  <span style="font-weight: bold;"><xsl:value-of select="n1:IdDeuda" /></span>
               </td>            
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:TIE, '###.##0,00', 'format1')"/>%</span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:CostAmor1Ene, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:IntExpli1Ene, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:CreacEfectivo, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:CreacGastos, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:IntDevenTIEExpli, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:IntDevenTIEResto, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:IntCancelados, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:DifCambCostAmort, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:DifCambIntExpli, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:DismValorCont, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:DismResul, '###.##0,00', 'format1')"/></span>
               </td>
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:CostAmort31Dic, '###.##0,00', 'format1')"/></span>
               </td>               
               <td class="celdadatosder">
                  <span><xsl:value-of select="format-number(n1:IntExpl131Dic, '###.##0,00', 'format1')"/></span>
               </td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
      <tr>
         <td class="celdadatosder" style="font-weight: bold;" colspan="2">
            <span>TOTAL</span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:CostAmor1Ene, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:IntExpli1Ene, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:CreacEfectivo, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:CreacGastos, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:IntDevenTIEExpli, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:IntDevenTIEResto, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:IntCancelados, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:DifCambCostAmort, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:DifCambIntExpli, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:DismValorCont, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:DismResul, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:CostAmort31Dic, '###.##0,00', 'format1')"/>
            </span>
         </td>
         <td class="celdadatosder">
            <span>
               <xsl:value-of select="format-number($nodoPadre/n1:Total/n1:IntExpl131Dic, '###.##0,00', 'format1')"/>
            </span>
         </td>
      </tr>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
</xsl:stylesheet>
