<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">

     <xsl:variable name="tituloPag" select="$schema//xs:element[@name='LiqPpto']//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

              <h1>
               <xsl:value-of select="$tituloPag" />
            </h1>   
            <h2 style="text-transform:none">II. LIQUIDACIÓN DEL PRESUPUESTO DE GASTO. CLASIFICACIÓN ECONÓMICA (por Capítulo)</h2>
          
            
            <table border="1" cellspacing="0" cellpadding="4" style="width:100%;">
               <tbody>
                  <tr>
                     <td rowspan="2" class="cabecera">
                        CÓDIGO
    				      </td>
                     <td rowspan="2" style="width: 30%;" class="cabecera">
                        DESCRIPCIÓN
                     </td>
                     <td colspan="3" class="cabecera">
                        CRÉDITOS PRESUPUESTARIOS
                     </td>
                     <td style="width: 10%;" class="cabecera" rowspan="2">
                        GASTOS<br />
                        COMPROMETIDOS<br/>(4)
                     </td>
                     <td class="cabecera" rowspan="2">
                        OBLIGACIONES<br />
                        RECONOCIDAS<br />
                        NETAS<br/>(5)
                     </td>
                     <td class="cabecera" rowspan="2">
                        PAGOS<br />(6)
                     </td>
                     <td class="cabecera" rowspan="2">
                        OBLIGACIONES<br />
                        PENDIENTES DE<br />
                        PAGO A 31 DE<br />
                        DICIEMBRE<br />
                        (7=5-6)
                     </td>
                     <td class="cabecera" rowspan="2">
                        REMANETES<br />
                        DE CRÉDITO<br />
                        (8=3-5)
                     </td>
                  </tr>
                  <tr>
                     <td class="cabecera">
                        INICIALES<br/>(1)
                     </td>
                     <td class="cabecera">
                        MODIFIC.<br/>(2)
                     </td>
                     <td class="cabecera">
                        DEFINITIVOS<br/>(3=1+2)
                     </td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:LiqPpto/n1:LiqPptoGastE" />
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
            <!-- Por cada hijo -->
            <tr>
               <xsl:choose>
                  <xsl:when test="name(.) = 'TotLiqPptoGastClasifEcon'">
                     <td class="celdadatosder" colspan="2">
                        <span style="font-weight: bold;">
                           TOTAL
                        </span>
                     </td>                  
                  </xsl:when>
                  <xsl:when  test="name(.)='ClasifEcon'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:ApliPpria/n1:CodEcoG"/>
                        </span>
                     </td>
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:ApliPpria/n1:DesEcoG" />
                        </span>
                     </td>
                  </xsl:when>
               </xsl:choose>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:CredIni, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ModCred, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:CredDef, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:GastCompr, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:Oblig, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:Pag, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:ObligPendPag, '###.##0,00', 'format1')"/></td>
               <td class="celdadatosder"><xsl:value-of select="format-number(n1:RemCred, '###.##0,00', 'format1')"/></td>
            </tr>
      </xsl:for-each>

   </xsl:template>

  
   
</xsl:stylesheet>
