<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">
      
      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='ArrFinanYOtrOperaNatSimilar']" />
      <xsl:variable name="nodoEnumNatAct" select="$schema//xs:simpleType[@name='NatAct']//xs:restriction" />
      <xsl:variable name="nodoEnumArrFin" select="$schema//xs:simpleType[@name='ArrFinOtrOperaValoracion']//xs:restriction" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />
      

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>

            <table style="width: 100%">
               <tr>
                  <td class="cabecera">CLASE ACTIVO</td>
                  <td class="cabecera">IMPORTE<br/>RECONOCIMIENTO<br/>INICIAL</td>
                  <td class="cabecera">VALORACIÓN</td>
                  <td class="cabecera">OPCIÓN DE<br />COMPRA (SI/NO)</td>
                  <td class="cabecera">ACUERDOS<br/>SIGNIFICATIVOS<br/>ARRENDAMIENTO<br/>FINANCIERO</td>
                  <td class="cabecera">NATURALEZA DE<br/>LOS ACTIVOS QUE<br/>SURGEN DE ESTOS<br/>CONTRATOS</td>
               </tr>
               <xsl:call-template name="filas">
                  <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:ArrFinanYOtrOperaNatSimilar" />
                  <xsl:with-param name="nodoEnumArrFin" select="$nodoEnumArrFin"></xsl:with-param>
                  <xsl:with-param name="nodoEnumNatAct" select="$nodoEnumNatAct"></xsl:with-param>
               </xsl:call-template>
            </table> 
         </body>
      </html>
   </xsl:template>
   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumArrFin"></xsl:param>
      <xsl:param name="nodoEnumNatAct"></xsl:param>
      <xsl:for-each select="$nodoPadre/n1:ClaseActivo">
         <!-- Por cada hijo -->
         <xsl:variable name="Val" select="n1:Valoracion" />
         <xsl:variable name="NatAct" select="n1:NatActSurgContratos" />
         <tr>
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:NomClase" /></span>
            </td>
            <td class="celdadatosder">
               <span><xsl:value-of select="format-number(n1:ImpReconoInicial, '###.##0,00', 'format1')"/></span>
            </td>
            <td class="celdadatosizq">
               <span><xsl:value-of select="$nodoEnumArrFin/xs:enumeration[@value=$Val]//xs:documentation"/></span>
            </td>
            <td class="celdadatoscentro">
               <xsl:if test="n1:OpcionCompra='1' or n1:OpcionCompra='true'">
                  <span>SÍ</span>   
               </xsl:if>
               <xsl:if test="n1:OpcionCompra='0' or n1:OpcionCompra='false'">
                  <span>NO</span>
               </xsl:if>
            </td>               
            <td class="celdadatosizq">
               <span><xsl:value-of select="n1:AcuerdosSignifArrFinan"/></span>
            </td>
            <td class="celdadatosizd">
               <span><xsl:value-of select="$nodoEnumNatAct/xs:enumeration[@value=$NatAct]//xs:documentation"/></span>
            </td>                 
         </tr>
      </xsl:for-each>

   </xsl:template>

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>   

</xsl:stylesheet>
