<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='DifNegConso']//xs:element[@name='DifNegConsoEntConso']" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>
            
           
            <table border="1" cellspacing="0" cellpadding="4" style="width:70%;">
               <tbody>
                  <tr>
                     <td colspan="7" class="cabecera">DIFERENCIA NEGATIVA DE CONSOLIDACIÓN DE ENTIDADES CONSOLIDADAS</td>
                  </tr>
                  <tr>
                     <td  class="cabecera">NIF</td>
                     <td  class="cabecera">ENTIDADES <br/> CONSOLIDADAS</td>
                     <td  class="cabecera">VALOR CONTABLE<br/> DE LA <br/>PARTICIPACIÓN<br/>(1)</td>
                     <td  class="cabecera">VALOR DE LA <br/> PARTICIPACIÓN<br/> SEGÚN %<br/> SOBRE <br/> PATRIMONIO<br/> NETO<br/> (2)</td>
                     <td  class="cabecera">IMPORTE<br/> IMPUTABLE<br/>  AL ACTIVO<br/> (3) </td>
                     <td  class="cabecera">IMPORTE<br/> IMPUTABLE<br/> AL PASIVO<br/> (4)</td>
                     <td  class="cabecera">DIFERENCIA<br/> NEGATIVA DE <br/> CONSOLIDACIÓN <br/> (5)=(1)-(2)+(3)+(4)</td>
                  </tr>
                  
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientes/n1:DependIntegradas" />
                     <xsl:with-param name="nodoPadre2" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigIntegradas" />
                     <xsl:with-param name="nodoPadre3" select="//n1:Memoria/n1:DifNegConso/n1:DifNegConsoEntConso" />
                  </xsl:call-template>
                </tbody>
            </table> 
         </body>
      </html>
   </xsl:template>
  <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoPadre2"></xsl:param>
      <xsl:param name="nodoPadre3"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">        
         <xsl:choose>	
            <xsl:when  test="name(.)='DependI'">
               <xsl:if test="n1:InfoNota9Part18/n1:IndEntPart18 = '1' and n1:MetIntegracion='GLOBAL'">
               
               <tr>
                  <td class="celdadatosizq"><span style="font-weight: bold;"><xsl:value-of select="n1:NIF" /></span></td>
                  <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
                  <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:ValContParticip , '###.##0,00', 'format1')"/></td>
                  <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:ValParticipSobrePatriNeto, '###.##0,00', 'format1')"/></td>
                  <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:ImpImputAct, '###.##0,00', 'format1')"/></td>
                  <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:ImpImputPas, '###.##0,00', 'format1')"/></td>
                  <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:DifNegConso, '###.##0,00', 'format1')"/></td>
               </tr>
               </xsl:if>
            </xsl:when>
         </xsl:choose>
      </xsl:for-each>

      
      <xsl:for-each select="$nodoPadre2/*">       
         <xsl:if test="$nodoPadre2/n1:IndEntPart18 = '1' and  $nodoPadre2/n1:MetConsoIdent = 'INT-PROP' "> 
            <xsl:choose>	            
               <xsl:when  test="name(.)='DependIM'">               
                  <tr>

                     <td class="celdadatosizq"><span style="font-weight: bold;"><xsl:value-of select="n1:NIF" /></span></td>
                     <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>
                     <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:ValContParticip , '###.##0,00', 'format1')"/></td>
                     <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:ValParticipSobrePatriNeto, '###.##0,00', 'format1')"/></td>
                     <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:ImpImputAct, '###.##0,00', 'format1')"/></td>
                     <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:ImpImputPas, '###.##0,00', 'format1')"/></td>
                     <td class="celdadatosder"><xsl:value-of select="format-number(n1:InfoNota9Part18/n1:DifNegConso, '###.##0,00', 'format1')"/></td>
                  </tr>
               </xsl:when>    
               </xsl:choose>
             </xsl:if>       
      </xsl:for-each>  
      
 
      <tr>
         <td class="celdadatosder" colspan="2"> <span style="font-weight: bold;"> TOTAL </span></td>       
         <td class="celdadatosder"><xsl:value-of select="format-number($nodoPadre3/n1:TotValContParticip, '###.##0,00', 'format1')"/></td>
         <td class="celdadatosder"><xsl:value-of select="format-number($nodoPadre3/n1:TotValParticipSobrePatriNeto, '###.##0,00', 'format1')"/></td>
         <td class="celdadatosder"><xsl:value-of select="format-number($nodoPadre3/n1:TotImpImputAct, '###.##0,00', 'format1')"/></td>  
         <td class="celdadatosder"><xsl:value-of select="format-number($nodoPadre3/n1:TotImpImputPas, '###.##0,00', 'format1')"/></td>
         <td class="celdadatosder"><xsl:value-of select="format-number($nodoPadre3/n1:TotDifNegConso, '###.##0,00', 'format1')"/></td>                      
      </tr>
   </xsl:template> 

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
