<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>

   <xsl:template match="/">
      
      <xsl:variable name="tituloPag" select="$schema//xs:element[@name='Memoria']//xs:element[@name='PartEntMultigrupo']//xs:documentation" />
      <xsl:variable name="tituloPag2" select="$schema//xs:element[@name='Memoria']//xs:element[@name='PartEntMultigrupo']//xs:element[@name='PartBalConsoMulti']//xs:documentation" />
      <xsl:variable name="tituloPag3" select="$schema//xs:element[@name='Memoria']//xs:element[@name='PartEntMultigrupo']//xs:element[@name='PartBalConsoMulti']//xs:element[@name='Pasivo']//xs:documentation" />
      
      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />
            
             <h1>
               <xsl:value-of select="$tituloPag" />
            </h1>            
            <h2>
               <xsl:value-of select="$tituloPag2" />              
            </h2>  
            <h2>
               <xsl:value-of select="$tituloPag3" />              
            </h2>            
            
            <xsl:variable name="ejercicio" select="//n1:Entidad/n1:Ejercicio" />
            <table border="1" cellspacing="0" cellpadding="4" style="width:60%;">
               <tbody>

                  <tr>
                     <td class="cabecera" rowspan="2">PASIVO</td>
                     <td class="cabecera" colspan="2"><span><xsl:value-of select="$ejercicio"/></span></td>
                     <td class="cabecera" colspan="2"><span><xsl:value-of select="$ejercicio -1"/></span></td>
                  </tr>
                  <tr>
                     <td class="cabecera">IMPORTE <br /> TOTAL</td>
                     <td class="cabecera">IMPORTE<br />ENTIDADES<br />MULTIGRUPO</td>
                     <td class="cabecera">IMPORTE <br /> TOTAL</td>
                     <td class="cabecera">IMPORTE<br />ENTIDADES<br />MULTIGRUPO</td>
                  </tr>
                  <xsl:call-template name="filas">
                     <xsl:with-param name="nodoPadre" select="//n1:Balance/n1:Pasivo" />                    
                     <xsl:with-param name="nombre" select="'Pasivo'" />
                     <xsl:with-param name="nodoSchema" select="$schema//xs:element[@name='Pasivo']"/>
                     <xsl:with-param name="esPrincipal" select="1"/>
                  </xsl:call-template>

                </tbody>
            </table>            
         </body>
      </html>
   </xsl:template>

   <xsl:template name="filas">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoPadre2"></xsl:param>
      <xsl:param name="nodoSchema"></xsl:param>
      <xsl:param name="esPrincipal"></xsl:param>
      <xsl:param name="nombre"></xsl:param>

      <xsl:variable name="titulo" select="$nodoSchema[@name=$nombre]//xs:documentation"></xsl:variable>

      <!-- Por cada hijo -->
      <xsl:if test="count($nodoPadre/n1:NotMemoria ) = 1 ">
         <xsl:if test="count($nodoPadre[n1:IndPartEntMultigrupo = '1'] ) ">
         <tr>
            <!-- nodo de datos -->
            <xsl:call-template name="titulo">
               <xsl:with-param name="texto" select="$titulo" />
            </xsl:call-template>
            <td style="overflow: auto;" class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:EjActual, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:EjActualMultigrupo, '###.##0,00', 'format1')"/>
            </td>
            <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:EjAnterior, '###.##0,00', 'format1')"/>
            </td>
             <td class="celdadatosder">
               <xsl:value-of select="format-number($nodoPadre/n1:EjAnteriorMultigrupo, '###.##0,00', 'format1')"/>
            </td>
         </tr>
         </xsl:if>
      </xsl:if>

      <xsl:if test="count($nodoPadre/n1:NotMemoria) = 0">
         <xsl:if test="$esPrincipal=0">
            <!-- nodo padre -->
            <tr>
               <xsl:call-template name="titulo">
                  <xsl:with-param name="texto" select="$titulo" />
               </xsl:call-template>
               <td class="celdadatosder" colspan="4">&#160;</td>
            </tr>
         </xsl:if>
         <xsl:for-each select="$nodoPadre/*">
            <xsl:variable name="nombreNodAct" select="name(.)" />
            <xsl:call-template name="filas">
               <xsl:with-param name="nodoPadre" select="." />
               <xsl:with-param name="esPrincipal" select="0" />
               <xsl:with-param name="nombre" select="name(.)" />
               <xsl:with-param name="nodoSchema" select="$nodoSchema//xs:element[@name=$nombreNodAct]"/>
            </xsl:call-template>
         </xsl:for-each>
      </xsl:if>
    
   </xsl:template>

   <xsl:template name="titulo">
      <xsl:param name="texto"></xsl:param>

      <td class="celdadatosizq">

         <xsl:choose>
            <xsl:when test="starts-with($texto, 'I') or starts-with($texto, 'V')">
               <span style="font-weight: bold;">
                  &#160;&#160;&#160;<xsl:value-of select="$texto" />
               </span>
            </xsl:when>
            <xsl:when test="number(substring($texto,1,1))=number(substring($texto,1,1))">
               <span>
                  &#160;&#160;&#160;&#160;&#160;&#160;<xsl:value-of select="$texto" />
               </span>
            </xsl:when>
            <xsl:otherwise>
               <span style="font-weight: bold;">
                  <xsl:value-of select="$texto" />
               </span>
            </xsl:otherwise>
         </xsl:choose>

      </td>
   </xsl:template>


</xsl:stylesheet>
