<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
                xmlns:n1="https://www.pap.hacienda.gob.es/ficherosxsd/Cuenta-CAC-2022"
                xmlns:xs="http://www.w3.org/2001/XMLSchema"
                xmlns:msxsl="urn:schemas-microsoft-com:xslt"
                exclude-result-prefixes="n1 xs xsl msxsl">

   <xsl:import href="Cabecera.xslt"/>
	<xsl:output method="html" indent="yes" encoding="UTF-8" doctype-system="about:legacy-compat" />
   <xsl:decimal-format name="format1" grouping-separator="." decimal-separator=","/>
   <xsl:variable name="schema" select="document('../xsd/Cuenta-CAC-2022.xsd')" />
   <xsl:template match="/">

      <xsl:variable name="nodoSchemaActual" select="$schema//xs:element[@name='Memoria']//xs:element[@name='EntDependientesMA']//xs:element[@name='MultigrupoExcluidas']" />
      <xsl:variable name="nodoEnumTipoEnte" select="$schema//xs:simpleType[@name='TipoEnte']//xs:restriction" />
      <xsl:variable name="nodoEnumFormaInt" select="$schema//xs:simpleType[@name='FormaInt']//xs:restriction" />
      <xsl:variable name="nodoEnumCausasExcl" select="$schema//xs:simpleType[@name='CausasExcl']//xs:restriction" />
      <xsl:variable name="tituloPag" select="nodoSchemaActual//xs:documentation" />

      <html>
         <head>
            <title>
               <xsl:value-of select="$tituloPag" />
            </title>
            <link href="estiloHTMLscreen.css" rel="stylesheet" />
            <link href="menu.css" rel="Stylesheet"></link>
            <xsl:element name="script">
               <xsl:attribute name="src">jquery.js</xsl:attribute>
               <xsl:attribute name="type">text/javascript</xsl:attribute>
               //
            </xsl:element>
         </head>
         <body>

            <!-- cabecera y menu -->
            <xsl:apply-imports />

            <xsl:call-template name="tituloPagina">
               <xsl:with-param name="nodoUltimo" select="$nodoSchemaActual"></xsl:with-param>
               <xsl:with-param name="nivelInicio" select="1" />
               <xsl:with-param name="nivelUltimo" select="2" />
            </xsl:call-template>
            
            <h2>Entidades multigrupo</h2>
            <h3>Identificación de las entidades  multigrupo excluidas</h3> 

            <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8a' and n1:TipoEnte='CONS'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera"> ARTÍCULO 8a) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas1">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

              <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8a' and n1:TipoEnte='FUN'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas2">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluida" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8a' and n1:TipoEnte='OA'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas3">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8a' and n1:TipoEnte='EPE'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas4">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8a' and n1:TipoEnte='SM'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8a) NOFCAC-SPL - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas5">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8b' and n1:TipoEnte='CONS'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera"> ARTÍCULO 8b) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas6">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8b' and n1:TipoEnte='FUN'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas7">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8b' and n1:TipoEnte='OA'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas8">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8b' and n1:TipoEnte='EPE'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas9">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8b' and n1:TipoEnte='SM'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8b) NOFCAC-SPL - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas10">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

            <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8c' and n1:TipoEnte='CONS'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera"> ARTÍCULO 8c) NOFCAC-SPL  - CONSORCIO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas11">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8c' and n1:TipoEnte='FUN'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL - FUNDACIÓN</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas12">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8c' and n1:TipoEnte='OA'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - ORGANISMO AUTÓNOMO</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas13">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8c' and n1:TipoEnte='EPE'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL  - ENTIDAD PÚBLICA EMPRESARIAL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas14">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>

             <xsl:if test="count(//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas/n1:DependExM[n1:CausasExclusion='8c' and n1:TipoEnte='SM'])">            
               <table border="1" cellspacing="0" cellpadding="4" style="width:40%;">
                  <tbody>
                     <tr>
                        <td colspan="3" class="cabecera">IDENTIFICACIÓN DE LAS ENTIDADES MULTIGRUPO EXCLUIDAS</td>
                        
                     </tr>
                     <tr>
                        <td colspan="4" class="cabecera">ARTÍCULO 8c) NOFCAC-SPL - SOCIEDAD MERCANTIL</td>
                        
                     </tr>
                     <tr>
                        <td class="cabecera">NIF</td>
                        <td class="cabecera">NOMBRE ENTIDAD</td>
                     </tr>
                     <xsl:call-template name="filas15">
                        <xsl:with-param name="nodoPadre" select="//n1:Memoria/n1:EntDependientesMA/n1:MultigrupoExcluidas" />
                        <xsl:with-param name="nodoEnumTipoEnte" select="$nodoEnumTipoEnte"></xsl:with-param>
                     </xsl:call-template>
                  </tbody>
               </table>                          
            </xsl:if>
            
         </body>
      </html>
   </xsl:template>

   <xsl:template name="filas1">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

    <xsl:template name="filas2">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas3">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas4">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas5">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8a' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas6">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 
   
   <xsl:template name="filas7">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas8">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 

   <xsl:template name="filas9">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template> 
   
   <xsl:template name="filas10">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8b' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>
   
   <xsl:template name="filas11">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='CONS'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>  
   
   <xsl:template name="filas12">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='FUN'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>  
   
   <xsl:template name="filas13">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='OA'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>  
   
   <xsl:template name="filas14">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='EPE'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>  

   <xsl:template name="filas15">
      <xsl:param name="nodoPadre"></xsl:param>
      <xsl:param name="nodoEnumTipoEnte"></xsl:param>
      <xsl:for-each select="$nodoPadre/*">
         <xsl:variable name="TipoEnte" select="n1:TipoEnte" /> 
         <xsl:if test="n1:CausasExclusion='8c' and n1:TipoEnte='SM'">         
            <tr>
               <xsl:choose>	
                  <xsl:when  test="name(.)='DependExM'">
                     <td class="celdadatosizq">
                        <span style="font-weight: bold;">
                           <xsl:value-of select="n1:NIF" />
                        </span>
                     </td>                     
                  </xsl:when>
               </xsl:choose>
               
               <td class="celdadatosizq" ><xsl:value-of select="n1:NomEnt"/></td>                     
            </tr>
         </xsl:if>
      </xsl:for-each>
   </xsl:template>    

   <xsl:template name="tituloPagina">
      <xsl:param name="padres" />
      <xsl:param name="nodoUltimo" />
      <xsl:param name="nivelInicio" />
      <xsl:param name="nivelUltimo" />

      <xsl:if test="$nivelUltimo &gt; $nivelInicio">

         <xsl:variable name="totPadres" select="count($nodoUltimo/ancestor::xs:element)"/>

         <xsl:call-template name="tituloPagina">
            <xsl:with-param name="padres" select="$totPadres" />
            <xsl:with-param name="nodoUltimo" select="$nodoUltimo/ancestor::xs:element[1]" />
            <xsl:with-param name="nivelInicio" select="$nivelInicio" />
            <xsl:with-param name="nivelUltimo" select="$nivelUltimo - 1" />
         </xsl:call-template>
      </xsl:if>

      <xsl:element name="h{$nivelUltimo}">
         <xsl:value-of select="$nodoUltimo/xs:annotation/xs:documentation"/>
      </xsl:element>

   </xsl:template>
   
</xsl:stylesheet>
